/*
 * Decompiled with CFR 0.152.
 */
package com.doo.xhp.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Path path = FileSystems.getDefault().getPath("config", "doo.json");
    private static final Gson json = new GsonBuilder().setPrettyPrinting().create();

    public static <T> T read(String key, Class<T> t, T defaultValue) {
        try {
            FileChannel open = FileChannel.open(path, StandardOpenOption.READ);
            JsonObject read = Config.read(open);
            JsonElement e = read.get(key);
            return (T)(e == null ? defaultValue : json.fromJson(e, t));
        }
        catch (NoSuchFileException open) {
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25(read file error) : " + path.toString(), (Throwable)e);
        }
        return defaultValue;
    }

    private static JsonObject read(FileChannel open) throws Exception {
        ByteBuffer bb = ByteBuffer.allocate((int)open.size());
        if (open.size() < 1L) {
            return new JsonObject();
        }
        open.read(bb);
        return (JsonObject)json.fromJson(new String(bb.array(), StandardCharsets.UTF_8), JsonObject.class);
    }

    private static void unlock(FileLock lock) {
        if (lock != null) {
            try {
                lock.release();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String key, Object value) {
        FileLock lock = null;
        try {
            FileChannel open = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
            long time = System.currentTimeMillis();
            while (lock == null) {
                try {
                    lock = open.tryLock();
                }
                catch (OverlappingFileLockException e) {
                    if (System.currentTimeMillis() - time <= 10000L) continue;
                    throw e;
                }
            }
            JsonObject read = Config.read(open);
            read.add(key, json.toJsonTree(value));
            open = lock.channel();
            open.truncate(0L);
            open.write(ByteBuffer.wrap(json.toJson((JsonElement)read).getBytes(StandardCharsets.UTF_8)));
            Config.unlock(lock);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "\u6587\u4ef6\u5199\u5165\u5931\u8d25(write file error) : " + path.toString() + ", " + value.toString(), (Throwable)e);
        }
        finally {
            Config.unlock(lock);
        }
    }
}

