/*
 * Decompiled with CFR 0.152.
 */
package com.doo.xhp.util;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1297;

public abstract class HpUtil {
    private static final Map<Integer, Deque<DamageTaken>> LAST_DAMAGE_TAKEN_MAP = new HashMap<Integer, Deque<DamageTaken>>();
    private static final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(5);
    private static final Random random = new Random();
    public static final int BASE_HEIGHT = 15;
    public static final int HEALTH = 10;

    public static void set(int id, float width, float height, class_1297 attacker, float damage, long age) {
        int attackerId;
        int x = random.nextInt(15) + (int)(width * 15.0f);
        int y = HpUtil.getShowY(height, false);
        x = random.nextBoolean() ? -x : x;
        y = random.nextInt(y / 2) + y / 4;
        int n = attackerId = attacker == null ? -1 : attacker.method_5628();
        if (!LAST_DAMAGE_TAKEN_MAP.containsKey(id)) {
            LAST_DAMAGE_TAKEN_MAP.put(id, new LinkedList());
        }
        Deque<DamageTaken> result = LAST_DAMAGE_TAKEN_MAP.get(id);
        result.push(new DamageTaken(attackerId, damage, age, x, y));
        if (result.size() > 10) {
            result.pollLast();
        }
    }

    public static Deque<DamageTaken> get(int id) {
        return LAST_DAMAGE_TAKEN_MAP.getOrDefault(id, new ConcurrentLinkedDeque());
    }

    public static void remove(int id) {
        executor.schedule(() -> LAST_DAMAGE_TAKEN_MAP.remove(id), 1L, TimeUnit.SECONDS);
    }

    public static boolean isAttacker(int id, int attacker, long now) {
        return ((Deque)LAST_DAMAGE_TAKEN_MAP.getOrDefault(id, new ConcurrentLinkedDeque())).stream().anyMatch(d -> attacker == d.attacker && now - d.time <= 100L);
    }

    public static int getShowY(float height, boolean isBaby) {
        return (int)(((double)height + 0.5) / (double)HpUtil.getScale(isBaby));
    }

    public static float getScale(boolean isBaby) {
        return isBaby ? 0.02f : 0.04f;
    }

    public static class DamageTaken {
        public final float damage;
        public final int attacker;
        public final long time;
        public final int x;
        public final int y;

        private DamageTaken(int attacker, float damage, long time, int x, int y) {
            this.attacker = attacker;
            this.damage = damage;
            this.time = time;
            this.x = x;
            this.y = y;
        }
    }
}

