/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics;

import java.util.ArrayList;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class CursorBox {
    private ArrayList<String> strings;
    private String language;
    private String fullCode = "";
    private String formatting;
    private int boxWidth = 150;
    private static final int color = -939524096;
    private boolean customLines;

    public CursorBox(String code) {
        this(code, "");
    }

    public CursorBox(String code, String formatting) {
        this.fullCode = code;
        this.formatting = formatting;
    }

    public CursorBox(int size) {
        this.strings = new ArrayList();
        for (int i = 0; i < size; ++i) {
            this.strings.add("");
        }
        this.customLines = true;
    }

    private String currentLanguage() {
        return class_310.method_1551().method_1526().method_4669().getCode();
    }

    public void createLines(String text) {
        try {
            this.language = this.currentLanguage();
        }
        catch (NullPointerException e) {
            this.language = "en_us";
        }
        this.strings = new ArrayList();
        String[] words = text.split(" ");
        int spaceWidth = class_310.method_1551().field_1772.method_1727(" ");
        StringBuilder line = new StringBuilder();
        int width = 0;
        for (int i = 0; i < words.length; ++i) {
            int wordWidth = class_310.method_1551().field_1772.method_1727(words[i]);
            if (width == 0 && wordWidth > this.boxWidth - 15) {
                this.boxWidth = wordWidth + 15;
            }
            if (!words[i].equals("\n") && width + wordWidth <= this.boxWidth - 15) {
                width += spaceWidth + wordWidth;
                line.append(words[i]).append(" ");
            } else {
                this.strings.add(this.formatting + line.toString());
                line.delete(0, line.length());
                width = 0;
                if (!words[i].equals("\n")) {
                    --i;
                }
            }
            if (i != words.length - 1) continue;
            this.strings.add(this.formatting + line.toString());
        }
    }

    public String getString(int line) {
        return this.strings.get(line);
    }

    public void drawBox(int x, int y, int width, int height) {
        try {
            if (!(this.customLines || this.language != null && this.language.equals(this.currentLanguage()))) {
                this.createLines(class_1074.method_4662((String)this.fullCode, (Object[])new Object[0]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int fix = x + this.boxWidth > width ? x + this.boxWidth - width : 0;
        int h = 5 + this.strings.size() * 10 + 5;
        int fiy = y + h > height ? y + h - height : 0;
        class_332.fill((int)(x - fix), (int)(y - fiy), (int)(x + this.boxWidth - fix), (int)(y + h - fiy), (int)-939524096);
        for (int i = 0; i < this.strings.size(); ++i) {
            String s = this.getString(i);
            class_310.method_1551().field_1772.method_1729("\u00a7f" + s, (float)(x + 10 - fix), (float)(y + 5 + 10 * i - fiy), 0xFFFFFF);
        }
    }

    public CursorBox withWidth(int boxWidth) {
        this.boxWidth = boxWidth;
        return this;
    }
}

