/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiClearSet;
import xaero.common.gui.GuiDeleteSet;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.GuiNewSet;
import xaero.common.gui.GuiWaypointContainers;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.gui.GuiWaypointWorlds;
import xaero.common.gui.GuiWaypointsOptions;
import xaero.common.gui.IDropDownCallback;
import xaero.common.gui.KeySortableByOther;
import xaero.common.gui.MyTinyButton;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.WaypointsSort;
import xaero.common.misc.Misc;
import xaero.common.mixin.MixinEntryListWidgetAccessor;

public class GuiWaypoints
extends class_437
implements IDropDownCallback {
    private static final int FRAME_TOP_SIZE = 58;
    private static final int FRAME_BOTTOM_SIZE = 61;
    public static double distanceDivided;
    private class_437 parentScreen;
    private List list;
    private WaypointWorld displayedWorld;
    private ConcurrentSkipListSet<Integer> selectedListSet;
    private ArrayList<GuiDropDown> dropDowns;
    private GuiWaypointContainers containers;
    private GuiWaypointWorlds worlds;
    private GuiWaypointSets sets;
    private GuiDropDown containersDD;
    private GuiDropDown worldsDD;
    private GuiDropDown setsDD;
    private AXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private WaypointsManager waypointsManager;
    private int draggingFromX;
    private int draggingFromY;
    private int draggingFromSlot;
    private Waypoint draggingWaypoint;
    private boolean dropped;
    private boolean displayingTeleportableWorld;
    private int shiftSelectFirst;
    private ArrayList<Waypoint> waypointsSorted;
    private final String frozenAutoContainerID;
    private final String frozenAutoWorldID;

    public GuiWaypoints(AXaeroMinimap modMain, XaeroMinimapSession minimapSession, class_437 par1GuiScreen) {
        super((class_2561)new class_2588("gui.xaero_waypoints", new Object[0]));
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.waypointsManager = minimapSession.getWaypointsManager();
        this.parentScreen = par1GuiScreen;
        this.selectedListSet = new ConcurrentSkipListSet();
        this.dropDowns = new ArrayList();
        this.draggingFromX = -1;
        this.draggingFromY = -1;
        this.draggingFromSlot = -1;
        this.frozenAutoContainerID = this.waypointsManager.getAutoContainerID();
        this.frozenAutoWorldID = this.waypointsManager.getAutoWorldID();
        this.displayedWorld = this.waypointsManager.getCurrentWorld(this.frozenAutoContainerID, this.frozenAutoWorldID);
        String currentContainer = this.displayedWorld.getContainer().getRootContainer().getKey();
        this.containers = new GuiWaypointContainers(modMain, this.waypointsManager, currentContainer, this.frozenAutoContainerID);
        this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()), this.waypointsManager, this.displayedWorld.getFullId(), this.frozenAutoContainerID, this.frozenAutoWorldID);
        this.displayingTeleportableWorld = this.waypointsManager.isWorldTeleportable(this.displayedWorld);
        this.waypointsSorted = new ArrayList();
    }

    public void init() {
        super.init();
        this.updateSortedList();
        this.list = new List();
        this.sets = new GuiWaypointSets(true, this.displayedWorld);
        this.children.add(this.list);
        this.addButton((class_339)new MyTinyButton(this.width / 2 + 129, this.height - 53, class_1074.method_4662((String)"gui.xaero_delete", (Object[])new Object[0]), b -> {
            if (!this.selectedListSet.isEmpty()) {
                Waypoint w;
                this.undrag();
                boolean shouldRestore = true;
                for (int i : this.selectedListSet) {
                    w = this.list.getWaypoint(i);
                    if (!w.isTemporary()) {
                        shouldRestore = false;
                    }
                    w.setTemporary(true);
                }
                if (shouldRestore) {
                    for (int i : this.selectedListSet) {
                        w = this.list.getWaypoint(i);
                        w.setTemporary(false);
                    }
                }
                try {
                    this.modMain.getSettings().saveWaypoints(this.displayedWorld);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }));
        this.addButton((class_339)new class_4185(this.width / 2 - 100, this.height - 29, 200, 20, class_1074.method_4662((String)"gui.done", (Object[])new Object[0]), b -> this.minecraft.method_1507(this.parentScreen)));
        this.addButton((class_339)new MyTinyButton(this.width / 2 - 203, this.height - 53, class_1074.method_4662((String)"gui.xaero_add_edit", (Object[])new Object[0]), b -> {
            ArrayList selectedWaypoints = this.getSelectedWaypointsList().stream().filter(w -> !w.isServerWaypoint()).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            this.minecraft.method_1507((class_437)new GuiAddWaypoint(this.modMain, this.waypointsManager, this, selectedWaypoints, this.displayedWorld.getContainer().getRootContainer().getKey(), this.displayedWorld, selectedWaypoints.isEmpty()));
            this.list.setSelected((List.WaypointEntry)null);
        }));
        this.addButton((class_339)new MyTinyButton(this.width / 2 - 120, this.height - 53, class_1074.method_4662((String)"gui.xaero_waypoint_teleport", (Object[])new Object[0]) + " (T)", b -> {
            this.displayingTeleportableWorld = this.waypointsManager.isWorldTeleportable(this.displayedWorld);
            this.waypointsManager.teleportToWaypoint(this.list.getWaypoint(this.selectedListSet.first()), this.displayedWorld, this);
        }));
        this.addButton((class_339)new MyTinyButton(this.width / 2 + 46, this.height - 53, class_1074.method_4662((String)"gui.xaero_disable_enable", (Object[])new Object[0]), b -> {
            ArrayList<Waypoint> selectedWaypoints = this.getSelectedWaypointsList();
            if (GuiWaypoints.allWaypointsAre(selectedWaypoints, Waypoint::isTemporary)) {
                for (Waypoint selected : selectedWaypoints) {
                    this.displayedWorld.getCurrentSet().getList().remove(selected);
                }
                this.selectedListSet.clear();
            } else if (GuiWaypoints.allWaypointsAre(selectedWaypoints, Waypoint::isDisabled)) {
                for (Waypoint selected : selectedWaypoints) {
                    selected.setDisabled(false);
                }
            } else {
                for (Waypoint selected : selectedWaypoints) {
                    selected.setDisabled(true);
                }
            }
            this.updateSortedList();
            try {
                this.modMain.getSettings().saveWaypoints(this.displayedWorld);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
        this.addButton((class_339)new MyTinyButton(this.width / 2 + 130, 32, class_1074.method_4662((String)"gui.xaero_clear", (Object[])new Object[0]), b -> {
            String[] worldKeys = this.worlds.getCurrentKeys();
            String name = this.sets.getOptions()[this.sets.getCurrentSet()];
            if (this.shouldDeleteSet()) {
                this.minecraft.method_1507((class_437)new GuiDeleteSet(class_1074.method_4662((String)name, (Object[])new Object[0]), worldKeys[0], worldKeys[1], name, this, this.modMain, this.minimapSession));
            } else {
                this.minecraft.method_1507((class_437)new GuiClearSet(class_1074.method_4662((String)name, (Object[])new Object[0]), worldKeys[0], worldKeys[1], name, this, this.modMain, this.minimapSession));
            }
        }));
        this.addButton((class_339)new MyTinyButton(this.width / 2 - 203, 32, class_1074.method_4662((String)"gui.xaero_options", (Object[])new Object[0]), b -> this.minecraft.method_1507((class_437)new GuiWaypointsOptions(this.modMain, this.minimapSession, this, this.displayedWorld, this.frozenAutoContainerID, this.frozenAutoWorldID))));
        this.addButton((class_339)new MyTinyButton(this.width / 2 - 37, this.height - 53, class_1074.method_4662((String)"gui.xaero_share", (Object[])new Object[0]), b -> {
            Waypoint selected;
            Waypoint waypoint = selected = this.selectedListSet.isEmpty() ? null : this.list.getWaypoint(this.selectedListSet.first());
            if (selected != null) {
                this.minimapSession.getWaypointSharing().shareWaypoint(this, selected, this.displayedWorld);
            }
        }));
        this.dropDowns.clear();
        this.containersDD = new GuiDropDown(this.containers.options, this.width / 2 - 202, 17, 200, this.containers.current, this);
        this.dropDowns.add(this.containersDD);
        this.worldsDD = new GuiDropDown(this.worlds.options, this.width / 2 + 2, 17, 200, this.worlds.current, this);
        this.dropDowns.add(this.worldsDD);
        this.setsDD = new GuiDropDown(this.sets.getOptions(), this.width / 2 - 100, 33, 200, this.sets.getCurrentSet(), this);
        this.dropDowns.add(this.setsDD);
    }

    private ArrayList<Waypoint> getSelectedWaypointsList() {
        return this.selectedListSet.stream().map(i -> this.list.getWaypoint(i)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public static boolean allWaypointsAre(ArrayList<Waypoint> waypoints, Predicate<Waypoint> predicate) {
        boolean allTrue = true;
        for (Waypoint w : waypoints) {
            if (predicate.test(w)) continue;
            allTrue = false;
            break;
        }
        return allTrue;
    }

    public boolean shouldDeleteSet() {
        return !this.sets.getOptions()[this.sets.getCurrentSet()].equals("gui.xaero_default") && this.displayedWorld.getCurrentSet().getList().isEmpty();
    }

    private void undrag() {
        this.draggingFromX = -1;
        this.draggingFromY = -1;
        this.draggingFromSlot = -1;
        this.draggingWaypoint = null;
    }

    public boolean mouseClicked(double par1, double par2, int par3) {
        for (GuiDropDown d : this.dropDowns) {
            if (!d.isClosed() && d.onDropDown((int)par1, (int)par2, this.height)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.height);
                return true;
            }
            d.setClosed(true);
        }
        for (GuiDropDown d : this.dropDowns) {
            if (d.onDropDown((int)par1, (int)par2, this.height)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.height);
                return true;
            }
            d.setClosed(true);
        }
        if (this.dropped) {
            return true;
        }
        if (par3 == 0) {
            if (par2 >= 58.0 && par2 < (double)(this.height - 61) && this.displayedWorld.getContainer().getRootContainer().getSortType() == WaypointsSort.NONE) {
                this.draggingFromX = (int)par1;
                this.draggingFromY = (int)par2;
                this.draggingFromSlot = this.list.getEntryAt(par1, par2);
                if (this.draggingFromSlot >= this.displayedWorld.getCurrentSet().getList().size()) {
                    this.draggingFromSlot = -1;
                }
            }
        } else {
            this.list.setSelected((List.WaypointEntry)null);
        }
        if (this.list.mouseClicked(par1, par2, par3)) {
            return true;
        }
        return super.mouseClicked(par1, par2, par3);
    }

    public boolean mouseReleased(double par1, double par2, int par3) {
        try {
            if (this.draggingWaypoint != null) {
                this.modMain.getSettings().saveWaypoints(this.displayedWorld);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.undrag();
        for (GuiDropDown d : this.dropDowns) {
            d.mouseReleased((int)par1, (int)par2, par3, this.height);
        }
        if (this.list.mouseReleased(par1, par2, par3)) {
            return true;
        }
        return super.mouseReleased(par1, par2, par3);
    }

    public boolean mouseDragged(double par1, double par2, int par3, double par4, double par5) {
        return this.list.mouseDragged(par1, par2, par3, par4, par5);
    }

    public boolean mouseScrolled(double par1, double par2, double wheel) {
        if ((int)wheel != 0) {
            int mouseXScaled = (int)(Misc.getMouseX(class_310.method_1551()) / class_310.method_1551().field_1704.method_4495());
            int mouseYScaled = (int)(Misc.getMouseY(class_310.method_1551()) / class_310.method_1551().field_1704.method_4495());
            for (GuiDropDown d : this.dropDowns) {
                if (d.isClosed() || !d.onDropDown(mouseXScaled, mouseYScaled, this.height)) continue;
                d.mouseScrolled((int)wheel, mouseXScaled, mouseYScaled, this.height);
                return true;
            }
        }
        return this.list.mouseScrolled(par1, par2, wheel);
    }

    public boolean method_16803(int par1, int par2, int par3) {
        switch (par1) {
            case 261: {
                if (!((class_339)this.buttons.get((int)4)).active) break;
                for (int i : this.selectedListSet) {
                    this.list.getWaypoint(i).setTemporary(true);
                }
                ((class_339)this.buttons.get(4)).onClick(0.0, 0.0);
                break;
            }
            case 84: {
                if (!((class_339)this.buttons.get((int)3)).active) break;
                ((class_339)this.buttons.get(3)).onClick(0.0, 0.0);
            }
        }
        return super.method_16803(par1, par2, par3);
    }

    public void render(int par1, int par2, float par3) {
        int k;
        if (this.minecraft.field_1724 == null) {
            this.minecraft.method_1507(null);
            return;
        }
        this.updateButtons();
        this.list.render(par1, par2, par3);
        this.drawCenteredString(this.font, class_1074.method_4662((String)"gui.xaero_world_server", (Object[])new Object[0]), this.width / 2 - 102, 5, 0xFFFFFF);
        this.drawCenteredString(this.font, class_1074.method_4662((String)"gui.xaero_subworld_dimension", (Object[])new Object[0]), this.width / 2 + 102, 5, 0xFFFFFF);
        if (this.draggingFromSlot != -1) {
            int distance = (int)Math.sqrt(Math.pow(par1 - this.draggingFromX, 2.0) + Math.pow(par2 - this.draggingFromY, 2.0));
            int toSlot = Math.min(this.displayedWorld.getCurrentSet().getList().size() - 1, this.list.getEntryAt(par1, par2));
            if (distance > 4 && this.draggingWaypoint == null) {
                this.draggingWaypoint = this.displayedWorld.getCurrentSet().getList().get(this.draggingFromSlot);
                this.list.setSelected((List.WaypointEntry)null);
            }
            if (this.draggingWaypoint != null && this.draggingFromSlot != toSlot && toSlot != -1) {
                int direction = toSlot > this.draggingFromSlot ? 1 : -1;
                for (int i = this.draggingFromSlot; i != toSlot; i += direction) {
                    this.displayedWorld.getCurrentSet().getList().set(i, this.displayedWorld.getCurrentSet().getList().get(i + direction));
                }
                this.displayedWorld.getCurrentSet().getList().set(toSlot, this.draggingWaypoint);
                this.draggingFromSlot = toSlot;
            }
            int fromCenter = this.draggingFromX - ((MixinEntryListWidgetAccessor)((Object)this.list)).getWidth() / 2;
            this.list.drawWaypointSlot(this.draggingWaypoint, par1 - 108 - fromCenter, par2 - this.list.getItemHeight() / 4);
        }
        if (this.dropped) {
            super.render(0, 0, par3);
        } else {
            super.render(par1, par2, par3);
        }
        this.dropped = false;
        for (k = 0; k < this.dropDowns.size(); ++k) {
            if (this.dropDowns.get(k).isClosed()) {
                this.dropDowns.get(k).drawButton(par1, par2, this.height);
                continue;
            }
            this.dropped = true;
        }
        for (k = 0; k < this.dropDowns.size(); ++k) {
            if (this.dropDowns.get(k).isClosed()) continue;
            this.dropDowns.get(k).drawButton(par1, par2, this.height);
        }
    }

    private void updateButtons() {
        ((class_4185)this.buttons.get((int)4)).active = !this.selectedListSet.isEmpty();
        ((class_4185)this.buttons.get((int)0)).active = ((class_4185)this.buttons.get((int)4)).active;
        ((class_4185)this.buttons.get((int)7)).active = this.selectedListSet.size() == 1;
        ((class_4185)this.buttons.get((int)3)).active = this.selectedListSet.size() == 1 && (this.modMain.getSettings().allowWrongWorldTeleportation || this.displayingTeleportableWorld) && this.displayedWorld.getContainer().getRootContainer().isTeleportationEnabled();
        ArrayList<Waypoint> selectedWaypointsList = this.getSelectedWaypointsList();
        ((class_4185)this.buttons.get((int)2)).active = this.selectedListSet.isEmpty() && this.minecraft.field_1724 != null || !GuiWaypoints.allWaypointsAre(selectedWaypointsList, Waypoint::isServerWaypoint);
        ((class_4185)this.buttons.get(5)).setMessage(class_1074.method_4662((String)(this.shouldDeleteSet() ? "gui.xaero_delete_set" : "gui.xaero_clear"), (Object[])new Object[0]));
        if (!this.selectedListSet.isEmpty() && GuiWaypoints.allWaypointsAre(selectedWaypointsList, Waypoint::isTemporary)) {
            ((class_4185)this.buttons.get(4)).setMessage(class_1074.method_4662((String)"gui.xaero_delete", (Object[])new Object[0]));
            ((class_4185)this.buttons.get(0)).setMessage(class_1074.method_4662((String)"gui.xaero_restore", (Object[])new Object[0]));
        } else {
            ((class_4185)this.buttons.get(0)).setMessage(class_1074.method_4662((String)"gui.xaero_delete", (Object[])new Object[0]));
            String[] enabledisable = class_1074.method_4662((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
            ((class_4185)this.buttons.get(4)).setMessage(enabledisable[!GuiWaypoints.allWaypointsAre(selectedWaypointsList, Waypoint::isDisabled) ? 0 : 1]);
        }
    }

    public class_437 getParentScreen() {
        return this.parentScreen;
    }

    @Override
    public boolean onSelected(GuiDropDown menu, int selectedIndex) {
        if (menu == this.containersDD || menu == this.worldsDD) {
            if (menu == this.containersDD) {
                this.containers.current = selectedIndex;
                if (this.containers.current != this.containers.auto) {
                    WaypointWorld firstWorld = this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()).getFirstWorld();
                    this.waypointsManager.setCustomContainerID(firstWorld.getContainer().getKey());
                    this.waypointsManager.setCustomWorldID(firstWorld.getId());
                } else {
                    this.waypointsManager.setCustomContainerID(null);
                    this.waypointsManager.setCustomWorldID(null);
                }
                this.displayedWorld = this.waypointsManager.getCurrentWorld(this.frozenAutoContainerID, this.frozenAutoWorldID);
                this.updateSortedList();
                this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()), this.waypointsManager, this.displayedWorld.getFullId(), this.frozenAutoContainerID, this.frozenAutoWorldID);
                this.worldsDD = new GuiDropDown(this.worlds.options, this.width / 2 + 2, 17, 200, this.worlds.current, this);
                this.dropDowns.set(1, this.worldsDD);
            } else if (menu == this.worldsDD) {
                this.worlds.current = selectedIndex;
                if (this.worlds.current != this.worlds.auto) {
                    String[] keys = this.worlds.getCurrentKeys();
                    this.waypointsManager.setCustomContainerID(keys[0]);
                    this.waypointsManager.setCustomWorldID(keys[1]);
                } else {
                    this.waypointsManager.setCustomContainerID(null);
                    this.waypointsManager.setCustomWorldID(null);
                }
                this.displayedWorld = this.waypointsManager.getCurrentWorld(this.frozenAutoContainerID, this.frozenAutoWorldID);
                this.updateSortedList();
            }
            this.displayingTeleportableWorld = this.waypointsManager.isWorldTeleportable(this.displayedWorld);
            this.waypointsManager.updateWaypoints();
            this.list.setSelected((List.WaypointEntry)null);
            this.sets = new GuiWaypointSets(true, this.displayedWorld);
            this.setsDD = new GuiDropDown(this.sets.getOptions(), this.width / 2 - 100, 33, 200, this.sets.getCurrentSet(), this);
            this.dropDowns.set(2, this.setsDD);
            return true;
        }
        if (menu == this.setsDD) {
            if (selectedIndex == menu.size() - 1) {
                System.out.println("New waypoint set gui");
                this.minecraft.method_1507((class_437)new GuiNewSet(this.modMain, this.minimapSession, this, this.displayedWorld));
                return false;
            }
            this.sets.setCurrentSet(selectedIndex);
            this.displayedWorld.setCurrent(this.sets.getCurrentSetKey());
            this.updateSortedList();
            this.waypointsManager.updateWaypoints();
            this.list.setSelected((List.WaypointEntry)null);
            try {
                this.modMain.getSettings().saveWaypoints(this.displayedWorld);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private void updateSortedList() {
        WaypointsSort sortType = this.displayedWorld.getContainer().getRootContainer().getSortType();
        if (sortType == WaypointsSort.NONE) {
            this.waypointsSorted = this.displayedWorld.getCurrentSet().getList();
            return;
        }
        distanceDivided = this.waypointsManager.getDimensionDivision(this.displayedWorld.getContainer().getKey());
        ArrayList<KeySortableByOther<Waypoint>> sortableKeys = new ArrayList<KeySortableByOther<Waypoint>>();
        for (Waypoint waypoint : this.displayedWorld.getCurrentSet().getList()) {
            sortableKeys.add(new KeySortableByOther<Waypoint>(waypoint, new Comparable[]{sortType == WaypointsSort.NAME ? waypoint.getComparisonName() : (sortType == WaypointsSort.SYMBOL ? waypoint.getSymbol() : Double.valueOf(waypoint.getComparisonDistance(this.minecraft.method_1560(), distanceDivided)))}));
        }
        Collections.sort(sortableKeys);
        this.waypointsSorted = new ArrayList();
        for (KeySortableByOther keySortableByOther : sortableKeys) {
            this.waypointsSorted.add((Waypoint)keySortableByOther.getKey());
        }
        if (this.displayedWorld.getContainer().getRootContainer().isSortReversed()) {
            Collections.reverse(this.waypointsSorted);
        }
    }

    class List
    extends class_4280<WaypointEntry> {
        private int createdCount;

        public List() {
            super(GuiWaypoints.this.minecraft, GuiWaypoints.this.width, GuiWaypoints.this.height, 58, Math.max(62, GuiWaypoints.this.height - 61), 18);
            this.createEntries(this.getWaypointCount());
        }

        protected int getWaypointCount() {
            int size = GuiWaypoints.this.displayedWorld.getCurrentSet().getList().size();
            if (GuiWaypoints.this.waypointsManager.getServerWaypoints() != null) {
                size += GuiWaypoints.this.waypointsManager.getServerWaypoints().size();
            }
            return size;
        }

        private Waypoint getWaypoint(int slotIndex) {
            int serverWPIndex;
            Waypoint waypoint = null;
            if (slotIndex < GuiWaypoints.this.displayedWorld.getCurrentSet().getList().size()) {
                waypoint = (Waypoint)GuiWaypoints.this.waypointsSorted.get(slotIndex);
            } else if (GuiWaypoints.this.waypointsManager.getServerWaypoints() != null && (serverWPIndex = slotIndex - GuiWaypoints.this.displayedWorld.getCurrentSet().getList().size()) < GuiWaypoints.this.waypointsManager.getServerWaypoints().size()) {
                waypoint = GuiWaypoints.this.waypointsManager.getServerWaypoints().get(serverWPIndex);
            }
            return waypoint;
        }

        protected boolean isSelectedItem(int p_148131_1_) {
            return !GuiWaypoints.this.selectedListSet.isEmpty() && GuiWaypoints.this.selectedListSet.contains(p_148131_1_);
        }

        protected void renderBackground() {
            GuiWaypoints.this.renderBackground();
        }

        private void createEntries(int count) {
            this.clearEntries();
            this.createdCount = count;
            for (int i = 0; i < count; ++i) {
                WaypointEntry entry = new WaypointEntry(i);
                this.addEntry((class_350.class_351)entry);
            }
        }

        public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
            int currentCount = this.getWaypointCount();
            if (currentCount != this.createdCount) {
                this.createEntries(currentCount);
                this.setScrollAmount(this.getScrollAmount());
            }
            super.render(p_render_1_, p_render_2_, p_render_3_);
        }

        public boolean isFocused() {
            if (GuiWaypoints.this.dropped || GuiWaypoints.this.draggingWaypoint != null) {
                return false;
            }
            return super.isFocused();
        }

        public void setSelected(WaypointEntry e) {
            if (e == null) {
                GuiWaypoints.this.selectedListSet.clear();
                GuiWaypoints.this.shiftSelectFirst = -1;
                return;
            }
            Waypoint waypoint = this.getWaypoint(e.index);
            int currentSize = GuiWaypoints.this.selectedListSet.size();
            boolean shiftPressed = class_437.hasShiftDown();
            if ((currentSize > 1 || currentSize == 1 && (Integer)GuiWaypoints.this.selectedListSet.first() != e.index) && !class_437.hasControlDown() && !shiftPressed) {
                GuiWaypoints.this.selectedListSet.clear();
            }
            if (currentSize > 0 && shiftPressed) {
                int direction = e.index > GuiWaypoints.this.shiftSelectFirst ? 1 : -1;
                GuiWaypoints.this.selectedListSet.clear();
                for (int i = GuiWaypoints.this.shiftSelectFirst; i != e.index + direction; i += direction) {
                    GuiWaypoints.this.selectedListSet.add(i);
                }
            } else if (GuiWaypoints.this.selectedListSet.contains(e.index)) {
                GuiWaypoints.this.selectedListSet.remove(e.index);
            } else {
                GuiWaypoints.this.shiftSelectFirst = e.index;
                GuiWaypoints.this.selectedListSet.add(e.index);
            }
            String narration = "";
            if (waypoint != null) {
                narration = narration + class_1074.method_4662((String)"narrator.select", (Object[])new Object[]{waypoint.getName()}) + (waypoint.isDisabled() ? " " + class_1074.method_4662((String)"gui.xaero_disabled", (Object[])new Object[0]) : "") + (waypoint.isTemporary() ? " " + class_1074.method_4662((String)"gui.xaero_temporary", (Object[])new Object[0]) : "") + ", ";
            }
            if (GuiWaypoints.this.selectedListSet.size() != 1) {
                narration = narration + class_1074.method_4662((String)"narrator.select", (Object[])new Object[]{class_1074.method_4662((String)"gui.xaero_waypoints", (Object[])new Object[0]) + " " + GuiWaypoints.this.selectedListSet.size()});
            }
            class_333.field_2054.method_19788(narration);
            super.setSelected((class_350.class_351)(GuiWaypoints.this.selectedListSet.isEmpty() ? null : e));
        }

        public int getItemHeight() {
            return this.itemHeight;
        }

        public void drawWaypointSlot(Waypoint w, int p_180791_2_, int p_180791_3_) {
            if (w == null) {
                return;
            }
            GuiWaypoints.this.drawCenteredString(GuiWaypoints.this.font, w.getLocalizedName() + (w.isDisabled() ? " \u00a74" + class_1074.method_4662((String)"gui.xaero_disabled", (Object[])new Object[0]) : (w.isTemporary() ? " \u00a74" + class_1074.method_4662((String)"gui.xaero_temporary", (Object[])new Object[0]) : "")), p_180791_2_ + 110, p_180791_3_ + 1, 0xFFFFFF);
            int rectX = p_180791_2_ + 8 + 4;
            int rectY = p_180791_3_ + 6;
            if (w.isGlobal()) {
                GuiWaypoints.this.drawCenteredString(GuiWaypoints.this.font, "*", rectX - 25, rectY - 3, 0xFFFFFF);
            }
            GuiWaypoints.this.modMain.getInterfaces().getMinimapInterface().getWaypointsGuiRenderer().drawIconOnGUI(w, GuiWaypoints.this.modMain.getSettings(), rectX, rectY);
        }

        public int getEntryAt(double x, double y) {
            WaypointEntry entry = (WaypointEntry)this.getEntryAtPosition(x, y);
            return entry == null ? -1 : entry.index;
        }

        @Environment(value=EnvType.CLIENT)
        public class WaypointEntry
        extends class_4280.class_4281<WaypointEntry> {
            private int index;

            public WaypointEntry(int index) {
                this.index = index;
            }

            public void render(int index, int p_render_2_, int p_render_3_, int p_render_4_, int p_render_5_, int p_render_6_, int p_render_7_, boolean p_render_8_, float p_render_9_) {
                Waypoint w = List.this.getWaypoint(index);
                if (w == GuiWaypoints.this.draggingWaypoint) {
                    return;
                }
                List.this.drawWaypointSlot(w, p_render_3_, p_render_2_);
            }

            public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                if (p_mouseClicked_5_ == 0) {
                    List.this.setSelected(this);
                    return true;
                }
                return false;
            }
        }
    }
}

