/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1542;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_270;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.settings.ModSettings;

public class MinimapRadar {
    public static final int radarPlayers = -1;
    public static final int radarShadow = -16777216;
    private AXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private ArrayList<class_1297> players;
    private ArrayList<class_1297> living;
    private ArrayList<class_1297> livingTamed;
    private ArrayList<class_1297> hostile;
    private ArrayList<class_1297> items;
    private ArrayList<class_1297> entities;
    private ArrayList<class_1297> playersOtherTeams;

    public MinimapRadar(AXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.players = new ArrayList();
        this.living = new ArrayList();
        this.livingTamed = new ArrayList();
        this.hostile = new ArrayList();
        this.items = new ArrayList();
        this.entities = new ArrayList();
        this.playersOtherTeams = new ArrayList();
    }

    public int getType(class_1297 e, class_1657 p, boolean ignoreTamed) {
        if (e instanceof class_1657) {
            if (p.method_5781() != ((class_1657)e).method_5781()) {
                return 6;
            }
            return 1;
        }
        if (!ignoreTamed && e instanceof class_1321 && ((class_1321)e).method_6181()) {
            return 7;
        }
        if (class_310.method_1551().field_1687.method_8407() != class_1267.field_5801 && !this.hostileException(e) && (e instanceof class_1588 || e instanceof class_1569 || e.method_5634() == class_3419.field_15251)) {
            return 2;
        }
        if (e instanceof class_1309) {
            return 3;
        }
        if (e instanceof class_1542) {
            return 4;
        }
        return 0;
    }

    public void updateRadar(class_638 world, class_1657 p, class_1297 renderEntity) {
        this.players.clear();
        this.hostile.clear();
        this.living.clear();
        this.items.clear();
        this.entities.clear();
        this.playersOtherTeams.clear();
        this.livingTamed.clear();
        Iterable worldEntities = world.method_18112();
        for (class_1297 e : worldEntities) {
            try {
                int type = this.getType(e, p, false);
                if (type == 1 ? e != p && !this.modMain.getSettings().getShowPlayers() : (type == 2 ? !this.modMain.getSettings().getShowHostile() : (type == 3 ? !this.modMain.getSettings().getShowMobs() : (type == 4 ? !this.modMain.getSettings().getShowItems() : (type == 6 ? !this.modMain.getSettings().getShowOtherTeam() : (type == 7 ? !this.modMain.getSettings().getShowTamedMobs() : !this.modMain.getSettings().getShowOther())))))) continue;
                double offx = e.field_5987 - renderEntity.field_5987;
                double offy = e.field_6035 - renderEntity.field_6035;
                double offh = renderEntity.field_6010 - e.field_6010;
                double offheight2 = offh * offh;
                double offx2 = offx * offx;
                double offy2 = offy * offy;
                double maxDistance = 50625.0 / (this.minimapSession.getMinimapProcessor().getMinimapZoom() * this.minimapSession.getMinimapProcessor().getMinimapZoom());
                if (offx2 > maxDistance || offy2 > maxDistance || offheight2 > (double)(this.modMain.getSettings().heightLimit * this.modMain.getSettings().heightLimit)) continue;
                ArrayList<class_1297> typeList = this.entities;
                switch (type) {
                    case 1: {
                        typeList = this.players;
                        break;
                    }
                    case 2: {
                        typeList = this.hostile;
                        break;
                    }
                    case 3: {
                        typeList = this.living;
                        break;
                    }
                    case 4: {
                        typeList = this.items;
                        break;
                    }
                    case 6: {
                        typeList = this.playersOtherTeams;
                        break;
                    }
                    case 7: {
                        typeList = this.livingTamed;
                    }
                }
                if (this.modMain.getSettings().entityAmount != 0 && typeList.size() >= 100 * this.modMain.getSettings().entityAmount) continue;
                typeList.add(e);
            }
            catch (Exception ex) {}
        }
    }

    private boolean hostileException(class_1297 e) {
        return false;
    }

    public double getEntityX(class_1297 e, float partial) {
        return e.field_6038 + (e.field_5987 - e.field_6038) * (double)partial;
    }

    public double getEntityZ(class_1297 e, float partial) {
        return e.field_5989 + (e.field_6035 - e.field_5989) * (double)partial;
    }

    public boolean shouldRenderEntity(class_1297 e) {
        return !e.method_5715() && !e.method_5767();
    }

    public int getPlayerTeamColour(class_1657 p) {
        Integer teamColour = null;
        class_270 team = p.method_5781();
        if (team != null) {
            teamColour = team.method_1202().method_532();
        }
        return teamColour == null ? -1 : teamColour;
    }

    public int getEntityColour(class_1657 p, class_1297 e, float offh) {
        int entityTeamColour;
        int type = this.getType(e, p, this.modMain.getSettings().tamedMobsColor == -1);
        if (type == 6 && this.modMain.getSettings().otherTeamColor == -1) {
            type = 1;
        }
        int color = type == 1 ? (this.modMain.getSettings().playersColor != -1 ? ModSettings.COLORS[this.modMain.getSettings().playersColor] : ((entityTeamColour = this.getPlayerTeamColour((class_1657)e)) != -1 ? entityTeamColour : -1)) : (type == 2 ? ModSettings.COLORS[this.modMain.getSettings().hostileColor] : (type == 3 ? ModSettings.COLORS[this.modMain.getSettings().mobsColor] : (type == 4 ? ModSettings.COLORS[this.modMain.getSettings().itemsColor] : (type == 6 ? ModSettings.COLORS[this.modMain.getSettings().otherTeamColor] : (type == 7 ? ModSettings.COLORS[this.modMain.getSettings().tamedMobsColor] : ModSettings.COLORS[this.modMain.getSettings().otherColor])))));
        float brightness = this.getEntityBrightness(offh);
        if (brightness < 1.0f) {
            int l = color >> 16 & 0xFF;
            int i1 = color >> 8 & 0xFF;
            int j1 = color & 0xFF;
            if ((l = (int)((float)l * brightness)) > 255) {
                l = 255;
            }
            if ((i1 = (int)((float)i1 * brightness)) > 255) {
                i1 = 255;
            }
            if ((j1 = (int)((float)j1 * brightness)) > 255) {
                j1 = 255;
            }
            color = 0xFF000000 | l << 16 | i1 << 8 | j1;
        }
        return color;
    }

    public float getEntityBrightness(float offh) {
        float level = (float)this.modMain.getSettings().heightLimit - offh;
        if (level < 0.0f) {
            level = 0.0f;
        }
        float brightness = 1.0f;
        if (level <= (float)(this.modMain.getSettings().heightLimit / 2) && this.modMain.getSettings().showEntityHeight) {
            brightness = 0.25f + 0.25f * level / (float)this.modMain.getSettings().heightLimit;
        }
        return brightness;
    }

    public Iterator<class_1297> getEntitiesIterator() {
        return this.entities.iterator();
    }

    public Iterator<class_1297> getItemsIterator() {
        return this.items.iterator();
    }

    public Iterator<class_1297> getLivingIterator() {
        return this.living.iterator();
    }

    public Iterator<class_1297> getLivingTamedIterator() {
        return this.livingTamed.iterator();
    }

    public Iterator<class_1297> getHostileIterator() {
        return this.hostile.iterator();
    }

    public Iterator<class_1297> getPlayersIterator() {
        return this.players.iterator();
    }

    public Iterator<class_1297> getPlayersOtherTeamsIterator() {
        return this.playersOtherTeams.iterator();
    }
}

