/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Iterator;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_742;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.MinimapRadar;
import xaero.common.minimap.region.MinimapChunk;
import xaero.common.minimap.render.MinimapRenderer;
import xaero.common.minimap.render.radar.EntityIconManager;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.minimap.write.MinimapWriter;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;

public class MinimapFBORenderer
extends MinimapRenderer {
    private ImprovedFramebuffer scalingFramebuffer;
    private ImprovedFramebuffer rotationFramebuffer;
    private EntityIconManager entityIconManager;
    private boolean triedFBO;
    private boolean loadedFBO;

    public MinimapFBORenderer(AXaeroMinimap modMain, class_310 mc, WaypointsGuiRenderer waypointsGuiRenderer, MinimapInterface minimapInterface) {
        super(modMain, mc, waypointsGuiRenderer, minimapInterface);
    }

    public void loadFrameBuffer(MinimapProcessor minimapProcessor) {
        if (!minimapProcessor.canUseFrameBuffer()) {
            System.out.println("FBO mode not supported! Using minimap safe mode.");
        } else {
            this.scalingFramebuffer = new ImprovedFramebuffer(512, 512, false);
            this.rotationFramebuffer = new ImprovedFramebuffer(512, 512, false);
            this.rotationFramebuffer.method_1232(9729);
            this.loadedFBO = this.scalingFramebuffer.field_1476 != -1 && this.rotationFramebuffer.field_1476 != -1;
            this.entityIconManager = new EntityIconManager(new EntityIconPrerenderer());
        }
        this.triedFBO = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderChunks(XaeroMinimapSession minimapSession, MinimapProcessor minimap, int mapSize, int bufferSize, float sizeFix, float partial, int lightLevel, boolean useWorldMap, boolean lockedNorth, double ps, double pc) {
        MinimapWriter minimapWriter = minimap.getMinimapWriter();
        synchronized (minimapWriter) {
            this.renderChunksToFBO(minimapSession, minimap, (class_1657)this.mc.field_1724, this.mc.method_1560(), bufferSize, mapSize, sizeFix, partial, lightLevel, true, useWorldMap, lockedNorth, ps, pc);
        }
        class_310.method_1551().method_1522().method_1235(false);
        GlStateManager.viewport((int)0, (int)0, (int)class_310.method_1551().method_1522().field_1480, (int)class_310.method_1551().method_1522().field_1477);
        this.rotationFramebuffer.method_1241();
    }

    public void renderChunksToFBO(XaeroMinimapSession minimapSession, MinimapProcessor minimap, class_1657 player, class_1297 renderEntity, int bufferSize, int viewW, float sizeFix, float partial, int level, boolean retryIfError, boolean useWorldMap, boolean lockedNorth, double ps, double pc) {
        double zInsidePixel;
        double maxVisibleLength = lockedNorth ? (double)viewW : (double)viewW * Math.sqrt(2.0);
        int radius = (int)Math.ceil(maxVisibleLength / 2.0 / this.zoom / 64.0);
        double playerX = minimap.getEntityRadar().getEntityX(renderEntity, partial);
        double playerZ = minimap.getEntityRadar().getEntityZ(renderEntity, partial);
        int xFloored = OptimizedMath.myFloor(playerX);
        int zFloored = OptimizedMath.myFloor(playerZ);
        int playerChunkX = xFloored >> 6;
        int playerChunkZ = zFloored >> 6;
        int offsetX = xFloored & 0x3F;
        int offsetZ = zFloored & 0x3F;
        boolean zooming = (double)((int)this.zoom) != this.zoom;
        this.scalingFramebuffer.method_1235(true);
        GL11.glClear((int)16640);
        GlStateManager.enableTexture();
        class_308.method_1450();
        long before = System.currentTimeMillis();
        GlStateManager.clear((int)256, (boolean)class_310.field_1703);
        GlStateManager.matrixMode((int)5889);
        this.helper.defaultOrtho();
        GlStateManager.matrixMode((int)5888);
        GL11.glPushMatrix();
        GlStateManager.loadIdentity();
        before = System.currentTimeMillis();
        double xInsidePixel = minimap.getEntityRadar().getEntityX(renderEntity, partial) - (double)xFloored;
        if (xInsidePixel < 0.0) {
            xInsidePixel += 1.0;
        }
        if ((zInsidePixel = minimap.getEntityRadar().getEntityZ(renderEntity, partial) - (double)zFloored) < 0.0) {
            zInsidePixel += 1.0;
        }
        float halfWView = (float)viewW / 2.0f;
        float angle = (float)(90.0 - this.getRenderAngle(renderEntity, lockedNorth, partial));
        GlStateManager.enableBlend();
        GlStateManager.translatef((float)256.0f, (float)256.0f, (float)-2000.0f);
        GlStateManager.scaled((double)this.zoom, (double)this.zoom, (double)1.0);
        class_332.fill((int)-256, (int)-256, (int)256, (int)256, (int)-16777216);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (useWorldMap) {
            this.modMain.getSupportMods().worldmapSupport.drawMinimap(minimapSession, this.helper, xFloored, zFloored, radius, zooming, this.zoom);
        } else if (minimap.getMinimapWriter().getLoadedBlocks() != null && level >= 0) {
            int minX = playerChunkX - radius;
            int minZ = playerChunkZ - radius;
            int maxX = playerChunkX + radius + 1;
            int maxZ = playerChunkZ + radius + 1;
            for (int X = minX; X <= maxX; ++X) {
                int canvasX = X - minimap.getMinimapWriter().getLoadedMapChunkX();
                if (canvasX < 0 || canvasX >= minimap.getMinimapWriter().getLoadedBlocks().length) continue;
                for (int Z = minZ; Z <= maxZ; ++Z) {
                    MinimapChunk mchunk;
                    int canvasZ = Z - minimap.getMinimapWriter().getLoadedMapChunkZ();
                    if (canvasZ < 0 || canvasZ >= minimap.getMinimapWriter().getLoadedBlocks().length || (mchunk = minimap.getMinimapWriter().getLoadedBlocks()[canvasX][canvasZ]) == null) continue;
                    mchunk.bindTexture(level);
                    if (!mchunk.isHasSomething() || level >= mchunk.getLevelsBuffered() || mchunk.getGlTexture(level) == 0) continue;
                    if (!zooming) {
                        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    } else {
                        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    }
                    int drawX = (mchunk.getX() - playerChunkX) * 64 - offsetX;
                    int drawZ = (mchunk.getZ() - playerChunkZ) * 64 - offsetZ;
                    GlStateManager.enableBlend();
                    GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                    this.helper.drawMyTexturedModalRect(drawX, drawZ, 0, 64, 64.0f, 64.0f, -64.0f, 64.0f);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    if (this.modMain.getSettings().chunkGrid > -1) {
                        int grid = ModSettings.COLORS[this.modMain.getSettings().chunkGrid];
                        r = grid >> 16 & 0xFF;
                        g = grid >> 8 & 0xFF;
                        b = grid & 0xFF;
                    }
                    for (int t = 0; t < 16; ++t) {
                        if (mchunk.getTile(t % 4, t / 4) == null || !this.modMain.getSettings().getSlimeChunks(minimapSession.getWaypointsManager()) || !mchunk.getTile(t % 4, t / 4).isSlimeChunk()) continue;
                        int slimeDrawX = drawX + 16 * (t % 4);
                        int slimeDrawZ = drawZ + 16 * (t / 4);
                        class_332.fill((int)slimeDrawX, (int)slimeDrawZ, (int)(slimeDrawX + 16), (int)(slimeDrawZ + 16), (int)-2142047936);
                    }
                    if (this.modMain.getSettings().chunkGrid > -1) {
                        float top;
                        GlStateManager.disableTexture();
                        GlStateManager.enableBlend();
                        GlStateManager.pushMatrix();
                        GlStateManager.translatef((float)(drawX + 64), (float)(drawZ + 64), (float)0.0f);
                        GlStateManager.scaled((double)(1.0 / this.zoom), (double)(1.0 / this.zoom), (double)1.0);
                        GlStateManager.color4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)0.5f);
                        float left = top = (float)(-64.0 * this.zoom);
                        this.helper.drawMyColoredRect(left, -1.0f, 0.0f, 0.0f);
                        this.helper.drawMyColoredRect(left, (float)(-16.0 * this.zoom) - 1.0f, 0.0f, (float)(-16.0 * this.zoom));
                        this.helper.drawMyColoredRect(left, (float)(-32.0 * this.zoom) - 1.0f, 0.0f, (float)(-32.0 * this.zoom));
                        this.helper.drawMyColoredRect(left, (float)(-48.0 * this.zoom) - 1.0f, 0.0f, (float)(-48.0 * this.zoom));
                        this.helper.drawMyColoredRect(-1.0f, top, 0.0f, 0.0f);
                        this.helper.drawMyColoredRect((float)(-16.0 * this.zoom) - 1.0f, top, (float)(-16.0 * this.zoom), 0.0f);
                        this.helper.drawMyColoredRect((float)(-32.0 * this.zoom) - 1.0f, top, (float)(-32.0 * this.zoom), 0.0f);
                        this.helper.drawMyColoredRect((float)(-48.0 * this.zoom) - 1.0f, top, (float)(-48.0 * this.zoom), 0.0f);
                        GlStateManager.popMatrix();
                        GlStateManager.disableBlend();
                        GlStateManager.enableTexture();
                    }
                    GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        }
        this.scalingFramebuffer.method_1240();
        this.rotationFramebuffer.method_1235(false);
        GL11.glClear((int)16640);
        this.scalingFramebuffer.method_1241();
        GlStateManager.loadIdentity();
        if (this.modMain.getSettings().getAntiAliasing()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        GlStateManager.translatef((float)halfWView, (float)halfWView, (float)-2000.0f);
        GL11.glPushMatrix();
        if (!lockedNorth) {
            GL11.glRotatef((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.translated((double)(-xInsidePixel * this.zoom), (double)(-zInsidePixel * this.zoom), (double)0.0);
        GlStateManager.disableBlend();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(this.modMain.getSettings().minimapOpacity / 100.0)));
        this.helper.drawMyTexturedModalRect(-256.0f, -256.0f, 0, 0, 512.0f, 512.0f, 512.0f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        before = System.currentTimeMillis();
        GlStateManager.disableAlphaTest();
        GlStateManager.alphaFunc((int)516, (float)1.0f);
        GlStateManager.disableBlend();
        GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)1);
        GlStateManager.depthFunc((int)519);
        GlStateManager.depthFunc((int)515);
        GlStateManager.depthMask((boolean)false);
        GlStateManager.depthMask((boolean)true);
        GlStateManager.bindTexture((int)1);
        GlStateManager.bindTexture((int)0);
        this.mc.method_1531().method_4618(InterfaceRenderer.guiTextures);
        if (this.modMain.getSettings().getSmoothDots()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc((int)516, (float)0.0f);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        class_1657 p = player;
        ModSettings settings = this.modMain.getSettings();
        boolean smoothDots = settings.getSmoothDots();
        boolean debugEntityIcons = settings.debugEntityIcons;
        int dotsStyle = settings.getDotsStyle();
        MinimapRadar minimapRadar = minimap.getEntityRadar();
        this.renderEntityListToFBO(minimap, p, renderEntity, minimapRadar.getEntitiesIterator(), ps, pc, playerX, playerZ, partial, settings.otherNames, 0, minimapRadar, settings, lockedNorth, dotsStyle, smoothDots, debugEntityIcons);
        this.renderEntityListToFBO(minimap, p, renderEntity, minimapRadar.getItemsIterator(), ps, pc, playerX, playerZ, partial, settings.itemNames, 0, minimapRadar, settings, lockedNorth, dotsStyle, smoothDots, debugEntityIcons);
        this.renderEntityListToFBO(minimap, p, renderEntity, minimapRadar.getLivingIterator(), ps, pc, playerX, playerZ, partial, settings.friendlyMobNames, settings.mobIcons, minimapRadar, settings, lockedNorth, dotsStyle, smoothDots, debugEntityIcons);
        this.renderEntityListToFBO(minimap, p, renderEntity, minimapRadar.getHostileIterator(), ps, pc, playerX, playerZ, partial, settings.hostileMobNames, settings.hostileIcons, minimapRadar, settings, lockedNorth, dotsStyle, smoothDots, debugEntityIcons);
        this.renderEntityListToFBO(minimap, p, renderEntity, minimapRadar.getLivingTamedIterator(), ps, pc, playerX, playerZ, partial, settings.tamedMobNames, settings.tamedIcons, minimapRadar, settings, lockedNorth, dotsStyle, smoothDots, debugEntityIcons);
        this.renderEntityListToFBO(minimap, p, renderEntity, minimapRadar.getPlayersIterator(), ps, pc, playerX, playerZ, partial, settings.playerNames, settings.playerIcons, minimapRadar, settings, lockedNorth, dotsStyle, smoothDots, debugEntityIcons);
        this.renderEntityListToFBO(minimap, p, renderEntity, minimapRadar.getPlayersOtherTeamsIterator(), ps, pc, playerX, playerZ, partial, settings.otherTeamsNames == 3 ? settings.playerNames : settings.otherTeamsNames, settings.playerIcons, minimapRadar, settings, lockedNorth, dotsStyle, smoothDots, debugEntityIcons);
        this.mc.method_1531().method_4618(InterfaceRenderer.guiTextures);
        if (this.modMain.getSettings().mainEntityAs == 1) {
            this.renderEntityDotToFBO(minimap, p, renderEntity, renderEntity, ps, pc, playerX, playerZ, partial, false, false, minimapRadar, lockedNorth, dotsStyle, smoothDots, debugEntityIcons);
        }
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GlStateManager.disableAlphaTest();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        this.rotationFramebuffer.method_1240();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableBlend();
        GlStateManager.matrixMode((int)5889);
        Misc.minecraftOrtho(this.mc);
        GlStateManager.matrixMode((int)5888);
        GL11.glPopMatrix();
    }

    public void renderEntityListToFBO(MinimapProcessor minimap, class_1657 p, class_1297 renderEntity, Iterator<class_1297> iter, double ps, double pc, double playerX, double playerZ, float partial, int names, int icons, MinimapRadar minimapRadar, ModSettings settings, boolean lockedNorth, int style, boolean smooth, boolean debug) {
        boolean iconsForList;
        boolean alwaysNameTags = this.modMain.getSettings().alwaysEntityNametags;
        boolean playerListPressed = this.mc.field_1690.field_1907.method_1434();
        boolean namesForList = names == 1 && playerListPressed || names == 2;
        boolean bl = iconsForList = icons == 1 && playerListPressed || icons == 2;
        while (iter.hasNext()) {
            int entityType;
            class_1297 e = iter.next();
            if (renderEntity == e) continue;
            boolean name = namesForList;
            boolean icon = iconsForList;
            if (names == 3) {
                entityType = minimapRadar.getType(e, p, true);
                int fallbackNames = 0;
                if (entityType == 2) {
                    fallbackNames = settings.hostileMobNames;
                } else if (entityType == 3) {
                    fallbackNames = settings.friendlyMobNames;
                }
                boolean bl2 = name = fallbackNames == 1 && playerListPressed || fallbackNames == 2;
            }
            if (icons == 3) {
                entityType = minimapRadar.getType(e, p, true);
                int fallbackIcons = 0;
                if (entityType == 2) {
                    fallbackIcons = settings.hostileIcons;
                } else if (entityType == 3) {
                    fallbackIcons = settings.mobIcons;
                }
                boolean bl3 = icon = fallbackIcons == 1 && playerListPressed || fallbackIcons == 2;
            }
            if (!(e instanceof class_1657)) {
                boolean bl4 = name = name || alwaysNameTags && e.method_16914();
            }
            if (icon && e instanceof class_742) {
                this.renderPlayerHeadToFBO(minimap, p, renderEntity, (class_742)e, ps, pc, playerX, playerZ, partial, name, minimapRadar, lockedNorth);
                continue;
            }
            this.renderEntityDotToFBO(minimap, p, renderEntity, e, ps, pc, playerX, playerZ, partial, name, icon, minimapRadar, lockedNorth, style, smooth, debug);
        }
    }

    public void renderPlayerHeadToFBO(MinimapProcessor minimap, class_1657 p, class_1297 renderEntity, class_742 e, double ps, double pc, double playerX, double playerZ, float partial, boolean name, MinimapRadar minimapRadar, boolean lockedNorth) {
        if (!minimapRadar.shouldRenderEntity((class_1297)e)) {
            return;
        }
        double offx = minimap.getEntityRadar().getEntityX((class_1297)e, partial) - playerX;
        double offz = minimap.getEntityRadar().getEntityZ((class_1297)e, partial) - playerZ;
        float offh = (float)(renderEntity.field_6010 - e.field_6010);
        GlStateManager.pushMatrix();
        double zoomedOffX = offx * this.zoom;
        double zoomedOffZ = offz * this.zoom;
        double translateX = ps * zoomedOffX - pc * zoomedOffZ;
        double translateY = pc * zoomedOffX + ps * zoomedOffZ;
        int roundedX = (int)Math.round(translateX);
        int roundedY = (int)Math.round(translateY);
        GlStateManager.translated((double)roundedX, (double)roundedY, (double)0.0);
        GlStateManager.scaled((double)2.0, (double)2.0, (double)1.0);
        float brightness = minimap.getEntityRadar().getEntityBrightness(offh);
        GlStateManager.color4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        boolean flag1 = e != null && e.method_7348(class_1664.field_7559) && (e.method_7334().getName().equals("Dinnerbone") || e.method_7334().getName().equals("Grumm"));
        class_310.method_1551().method_1531().method_4618(e.method_3117());
        int l2 = 8 + (flag1 ? 8 : 0);
        int i3 = 8 * (flag1 ? -1 : 1);
        GL11.glPushMatrix();
        double headsScale = this.modMain.getSettings().headsScale;
        GL11.glScaled((double)headsScale, (double)headsScale, (double)1.0);
        class_332.blit((int)-4, (int)-4, (int)8, (int)8, (float)8.0f, (float)l2, (int)8, (int)i3, (int)64, (int)64);
        if (e != null && e.method_7348(class_1664.field_7563)) {
            class_310.method_1551().method_1531().method_4618(e.method_3117());
            int j3 = 8 + (flag1 ? 8 : 0);
            int k3 = 8 * (flag1 ? -1 : 1);
            class_332.blit((int)-4, (int)-4, (int)8, (int)8, (float)40.0f, (float)j3, (int)8, (int)k3, (int)64, (int)64);
        }
        GL11.glPopMatrix();
        if (name) {
            GlStateManager.pushMatrix();
            GlStateManager.scaled((double)0.5, (double)0.5, (double)1.0);
            GlStateManager.disableCull();
            int color = minimap.getEntityRadar().getEntityColour(p, (class_1297)e, 0.0f);
            double dotNameScale = this.modMain.getSettings().dotNameScale;
            GlStateManager.translatef((float)0.0f, (float)Math.round(11.0 * headsScale), (float)0.0f);
            GL11.glScaled((double)dotNameScale, (double)dotNameScale, (double)1.0);
            this.mc.field_1772.method_1720(e.method_5476().method_10863(), (float)(-this.mc.field_1772.method_1727(e.method_5476().method_10863()) / 2), 0.0f, color);
            GlStateManager.enableCull();
            GlStateManager.popMatrix();
        }
        GL11.glPopMatrix();
    }

    public void renderEntityDotToFBO(MinimapProcessor minimap, class_1657 p, class_1297 renderEntity, class_1297 e, double ps, double pc, double playerX, double playerZ, float partial, boolean name, boolean icon, MinimapRadar minimapRadar, boolean lockedNorth, int style, boolean smooth, boolean debug) {
        double dotsScale;
        int entityHeadTexture;
        if (!minimapRadar.shouldRenderEntity(e)) {
            return;
        }
        double offx = minimapRadar.getEntityX(e, partial) - playerX;
        double offz = minimapRadar.getEntityZ(e, partial) - playerZ;
        float offh = (float)(renderEntity.field_6010 - e.field_6010);
        GL11.glPushMatrix();
        double zoomedOffX = offx * this.zoom;
        double zoomedOffZ = offz * this.zoom;
        double translateX = ps * zoomedOffX - pc * zoomedOffZ;
        double translateY = pc * zoomedOffX + ps * zoomedOffZ;
        int roundedX = (int)Math.round(translateX);
        int roundedY = (int)Math.round(translateY);
        GlStateManager.translated((double)roundedX, (double)roundedY, (double)0.0);
        int nameOffsetX = 0;
        int nameOffsetY = 0;
        GL11.glPushMatrix();
        int n = entityHeadTexture = icon ? this.entityIconManager.getEntityHeadTexture(e, this.rotationFramebuffer, this.helper, debug) : -1;
        if (entityHeadTexture != -1) {
            GlStateManager.translated((double)(translateX - (double)roundedX), (double)(translateY - (double)roundedY), (double)0.0);
            dotsScale = this.modMain.getSettings().headsScale;
            GL11.glScaled((double)dotsScale, (double)dotsScale, (double)1.0);
            float brightness = minimapRadar.getEntityBrightness(offh);
            GlStateManager.blendFuncSeparate((int)1, (int)771, (int)1, (int)771);
            GlStateManager.bindTexture((int)entityHeadTexture);
            GlStateManager.color4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
            this.helper.drawMyTexturedModalRect(-32.0f, -32.0f, 0, 64, 64.0f, 64.0f, -64.0f, 64.0f);
            this.mc.method_1531().method_4618(InterfaceRenderer.guiTextures);
            GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        } else {
            int dotsSize = this.modMain.getSettings().dotsSize;
            dotsScale = 1.0 + 0.5 * (double)(dotsSize - 1);
            int color = minimapRadar.getEntityColour(p, e, offh);
            float f = (float)(color >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(color & 0xFF) / 255.0f;
            GlStateManager.color4f((float)f, (float)f1, (float)f2, (float)1.0f);
            this.mc.method_1531().method_4618(InterfaceRenderer.guiTextures);
            GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            double partialX = translateX - (double)roundedX;
            double partialY = translateY - (double)roundedY;
            GlStateManager.translated((double)partialX, (double)partialY, (double)0.0);
            int dotTextureX = 0;
            int dotTextureY = 0;
            int dotTextureW = 0;
            int dotTextureH = 0;
            float dotOffset = 0.0f;
            double dotActualScale = 1.0;
            if (style == 1) {
                if (smooth) {
                    dotTextureX = 1;
                    dotTextureY = 88;
                } else {
                    dotsScale = (int)dotsScale;
                    dotTextureX = 9;
                    dotTextureY = 77;
                }
                dotOffset = -3.5f;
                dotTextureH = 8;
                dotTextureW = 8;
                dotActualScale = dotsScale;
                GL11.glScaled((double)dotsScale, (double)dotsScale, (double)1.0);
            } else {
                switch (dotsSize) {
                    case 1: {
                        dotOffset = -4.5f;
                        dotTextureY = 108;
                        dotTextureH = 9;
                        dotTextureW = 9;
                        break;
                    }
                    case 3: {
                        dotOffset = -7.5f;
                        dotTextureY = 128;
                        dotTextureH = 15;
                        dotTextureW = 15;
                        break;
                    }
                    case 4: {
                        dotOffset = -10.5f;
                        dotTextureY = 160;
                        dotTextureH = 21;
                        dotTextureW = 21;
                        break;
                    }
                    default: {
                        dotOffset = -5.5f;
                        dotTextureY = 117;
                        dotTextureH = 11;
                        dotTextureW = 11;
                    }
                }
            }
            if (!smooth) {
                double dotRadius = (double)(-dotOffset) * dotActualScale;
                double dotRadiusPartial = dotRadius - (double)((int)dotRadius);
                nameOffsetX = partialX - dotRadiusPartial <= -0.5 ? -1 : 0;
                nameOffsetY = partialY - dotRadiusPartial < -0.5 ? -1 : 0;
            }
            this.helper.drawMyTexturedModalRect(dotOffset, dotOffset, dotTextureX, dotTextureY, dotTextureW, dotTextureH, 256.0f);
        }
        GL11.glPopMatrix();
        if (name) {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.pushMatrix();
            GlStateManager.disableCull();
            String nameString = e.method_5671().method_9214();
            int nameW = this.mc.field_1772.method_1727(nameString);
            int offsetY = icon ? 11 : 5;
            double dotNameScale = this.modMain.getSettings().dotNameScale;
            GlStateManager.translated((double)nameOffsetX, (double)((long)nameOffsetY + Math.round((double)offsetY * dotsScale)), (double)0.0);
            GL11.glScaled((double)dotNameScale, (double)dotNameScale, (double)1.0);
            this.mc.field_1772.method_1729(nameString, (float)(-nameW / 2 + 1), 1.0f, -12566464);
            this.mc.field_1772.method_1729(nameString, (float)(-nameW / 2), 0.0f, -1);
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            GlStateManager.enableAlphaTest();
            GlStateManager.alphaFunc((int)516, (float)0.0f);
            GlStateManager.enableCull();
            GlStateManager.popMatrix();
            this.mc.method_1531().method_4618(InterfaceRenderer.guiTextures);
        }
        GL11.glPopMatrix();
    }

    public void deleteFramebuffers() {
        this.scalingFramebuffer.method_1238();
        this.rotationFramebuffer.method_1238();
        if (this.entityIconManager != null) {
            this.entityIconManager.reset();
        }
    }

    public boolean isLoadedFBO() {
        return this.loadedFBO;
    }

    public void setLoadedFBO(boolean loadedFBO) {
        this.loadedFBO = loadedFBO;
    }

    public boolean isTriedFBO() {
        return this.triedFBO;
    }

    public void resetEntityIcons() {
        if (this.entityIconManager != null) {
            this.entityIconManager.reset();
        }
    }
}

