/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.lwjgl.opengl.GL11;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.misc.OptimizedMath;

public abstract class MinimapRenderer {
    public static final int black = -16777216;
    public static final int slime = -2142047936;
    protected AXaeroMinimap modMain;
    protected class_310 mc;
    protected MinimapInterface minimapInterface;
    protected MinimapRendererHelper helper;
    private WaypointsGuiRenderer waypointsGuiRenderer;
    private int lastMinimapSize;
    private ArrayList<String> underText;
    protected double zoom = 1.0;
    private class_2338.class_2339 mutableBlockPos;

    public MinimapRenderer(AXaeroMinimap modMain, class_310 mc, WaypointsGuiRenderer waypointsGuiRenderer, MinimapInterface minimapInterface) {
        this.modMain = modMain;
        this.mc = mc;
        this.waypointsGuiRenderer = waypointsGuiRenderer;
        this.minimapInterface = minimapInterface;
        this.underText = new ArrayList();
        this.helper = new MinimapRendererHelper();
        this.mutableBlockPos = new class_2338.class_2339();
    }

    public double getRenderAngle(class_1297 player, boolean lockedNorth, float partial) {
        if (lockedNorth) {
            return 90.0;
        }
        return this.getActualAngle(player, partial);
    }

    public double getActualAngle(class_1297 player, float partial) {
        double angle;
        double rotation = player.method_5705(partial);
        if (rotation < 0.0 || rotation > 360.0) {
            rotation %= 360.0;
        }
        if ((angle = 270.0 - rotation) < 0.0 || angle > 360.0) {
            angle %= 360.0;
        }
        return angle;
    }

    protected abstract void renderChunks(XaeroMinimapSession var1, MinimapProcessor var2, int var3, int var4, float var5, float var6, int var7, boolean var8, boolean var9, double var10, double var12);

    public void renderMinimap(XaeroMinimapSession minimapSession, MinimapProcessor minimap, int x, int y, int width, int height, double scale, int size, float partial) {
        int specW;
        if (this.modMain.getSettings().getMinimapSize() != this.lastMinimapSize) {
            this.lastMinimapSize = this.modMain.getSettings().getMinimapSize();
            minimap.setToResetImage(true);
        }
        long before = System.currentTimeMillis();
        int mapSize = minimapSession.getMinimapProcessor().getMinimapSize();
        int bufferSize = minimapSession.getMinimapProcessor().getMinimapBufferSize(mapSize);
        if (this.minimapInterface.usingFBO()) {
            bufferSize = minimap.getFBOBufferSize();
        }
        float mapScale = (float)(scale / 2.0 / (double)this.modMain.getSettings().getMinimapScale());
        minimap.updateZoom();
        this.zoom = minimap.getMinimapZoom();
        class_308.method_1450();
        GlStateManager.disableDepthTest();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.pixelStore((int)3317, (int)4);
        GlStateManager.pixelStore((int)3316, (int)0);
        GlStateManager.pixelStore((int)3315, (int)0);
        GlStateManager.pixelStore((int)3314, (int)0);
        float sizeFix = (float)bufferSize / 512.0f;
        int shape = this.modMain.getSettings().minimapShape;
        boolean lockedNorth = this.modMain.getSettings().getLockNorth(mapSize / 2, shape);
        double angle = Math.toRadians(this.getRenderAngle(this.mc.method_1560(), lockedNorth, partial));
        double ps = Math.sin(Math.PI - angle);
        double pc = Math.cos(Math.PI - angle);
        boolean useWorldMap = this.modMain.getSupportMods().shouldUseWorldMapChunks() && minimap.getMinimapWriter().getLoadedCaving() == -1 && minimap.getMinimapWriter().loadedLightOverlayType <= 0;
        int lightLevel = (int)((1.0f - Math.min(1.0f, this.getSunBrightness())) * (float)(minimap.getMinimapWriter().getLoadedLevels() - 1));
        this.renderChunks(minimapSession, minimap, mapSize, bufferSize, sizeFix, partial, lightLevel, useWorldMap, lockedNorth, ps, pc);
        if (this.minimapInterface.usingFBO()) {
            sizeFix = 1.0f;
        }
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GL11.glScalef((float)(1.0f / mapScale), (float)(1.0f / mapScale), (float)1.0f);
        int scaledX = (int)((float)x * mapScale);
        int scaledY = (int)((float)y * mapScale);
        int minimapFrameSize = (int)((float)(mapSize / 2) / sizeFix);
        boolean circleShape = shape == 1;
        int circleSides = Math.max(32, (int)Math.ceil(Math.PI * (double)(minimapFrameSize + 8) / 8.0));
        if (!circleShape) {
            this.helper.drawMyTexturedModalRect((int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, minimapFrameSize, 256.0f);
        } else {
            this.helper.drawTexturedElipseInsideRectangle(circleSides, (int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, 256.0f);
        }
        if (!this.minimapInterface.usingFBO()) {
            GL11.glScalef((float)(1.0f / sizeFix), (float)(1.0f / sizeFix), (float)1.0f);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.mc.method_1531().method_4618(InterfaceRenderer.guiTextures);
        int specH = specW = mapSize / 2 + 6;
        if (!circleShape) {
            int rightCornerStartX = scaledX + 9 + mapSize / 2 + 4 - 17;
            int bottomCornerStartY = scaledY + 9 + mapSize / 2 + 4 - 15;
            this.mc.field_1705.blit(scaledX + 9 - 4, scaledY + 9 - 4, 0, 0, 17, 15);
            this.mc.field_1705.blit(rightCornerStartX, scaledY + 9 - 4, 0, 15, 17, 15);
            this.mc.field_1705.blit(scaledX + 9 - 4, bottomCornerStartY, 0, 30, 17, 15);
            this.mc.field_1705.blit(rightCornerStartX, bottomCornerStartY, 0, 45, 17, 15);
            int horLineStartX = scaledX + 9 - 4 + 17;
            int horLineWidth = rightCornerStartX - horLineStartX;
            int horLineLength = (int)Math.ceil((double)horLineWidth / 16.0);
            for (int i = 0; i < horLineLength; ++i) {
                int lineX = scaledX + 9 - 4 + 17 + i * 16;
                int lineW = 16;
                if (i == horLineLength - 1 && lineX + lineW > rightCornerStartX) {
                    lineW = rightCornerStartX - lineX;
                }
                this.mc.field_1705.blit(lineX, scaledY + 9 - 4, 0, 60, lineW, 4);
                this.mc.field_1705.blit(lineX, scaledY + 9 - 4 + mapSize / 2 + 9 - 5, 0, 64, lineW, 4);
            }
            int verLineStartY = scaledY + 9 - 4 + 15;
            int verLineHeight = bottomCornerStartY - verLineStartY;
            int vertLineLength = (int)Math.ceil((double)verLineHeight / 5.0);
            for (int i = 0; i < vertLineLength; ++i) {
                int lineY = scaledY + 9 - 4 + 15 + i * 5;
                int lineH = 5;
                if (i == vertLineLength - 1 && lineY + lineH > bottomCornerStartY) {
                    lineH = bottomCornerStartY - lineY;
                }
                this.mc.field_1705.blit(scaledX + 9 - 4, lineY, 0, 68, 4, lineH);
                this.mc.field_1705.blit(scaledX + 9 - 4 + mapSize / 2 + 9 - 5, lineY, 0, 73, 4, lineH);
            }
        } else {
            this.helper.drawTexturedElipseInsideRectangleFrame(circleSides, 4.0f, scaledX + 9, scaledY + 9, 1, 60, mapSize / 2, 4.0f, 256.0f);
        }
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)0.5f, (float)0.5f, (float)1.0f);
        GlStateManager.translatef((float)(2 * scaledX + 18 + mapSize / 2), (float)(2 * scaledY + 18 + mapSize / 2), (float)0.0f);
        double playerX = minimap.getEntityRadar().getEntityX(this.mc.method_1560(), partial);
        double playerZ = minimap.getEntityRadar().getEntityZ(this.mc.method_1560(), partial);
        this.waypointsGuiRenderer.render(minimapSession, playerX, playerZ, specW, specH, ps, pc, partial, this.zoom, circleShape);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
        GlStateManager.enableBlend();
        if (this.modMain.getSettings().mainEntityAs == 0 && !lockedNorth) {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)(scaledX + 9), (float)(scaledY + 9), (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            GlStateManager.disableTexture();
            GlStateManager.translatef((float)(mapSize / 2), (float)(mapSize / 2), (float)0.0f);
            GlStateManager.blendFuncSeparate((int)775, (int)0, (int)1, (int)0);
            this.helper.drawMyColoredRect(-5.0f, -1.0f, 5.0f, 1.0f);
            this.helper.drawMyColoredRect(-1.0f, 3.0f, 1.0f, 5.0f);
            this.helper.drawMyColoredRect(-1.0f, -5.0f, 1.0f, -3.0f);
            GlStateManager.blendFunc((int)770, (int)771);
            int crosshairColor = minimap.getEntityRadar().getEntityColour((class_1657)this.mc.field_1724, this.mc.method_1560(), 0.0f);
            GlStateManager.color4f((float)((float)(crosshairColor >> 16 & 0xFF) / 255.0f), (float)((float)(crosshairColor >> 8 & 0xFF) / 255.0f), (float)((float)(crosshairColor & 0xFF) / 255.0f), (float)1.0f);
            this.helper.drawMyColoredRect(1.0f, -1.0f, 3.0f, 1.0f);
            this.helper.drawMyColoredRect(-3.0f, -1.0f, -1.0f, 1.0f);
            this.helper.drawMyColoredRect(-1.0f, 1.0f, 1.0f, 3.0f);
            this.helper.drawMyColoredRect(-1.0f, -3.0f, 1.0f, -1.0f);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.enableTexture();
            GlStateManager.enableBlend();
            GlStateManager.popMatrix();
        }
        this.mc.method_1531().method_4618(InterfaceRenderer.guiTextures);
        if (lockedNorth || this.modMain.getSettings().mainEntityAs == 2) {
            float a;
            float b;
            float g;
            float r;
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            double arrowX = 2 * scaledX + 18 + mapSize / 2;
            double arrowY = 2 * scaledY + 18 + mapSize / 2;
            GL11.glPushMatrix();
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            float arrowAngle = lockedNorth ? this.mc.method_1560().method_5705(partial) : 180.0f;
            float arrowOpacity = (float)this.modMain.getSettings().playerArrowOpacity / 100.0f;
            if (arrowOpacity == 1.0f) {
                this.drawArrow(arrowAngle, arrowX, arrowY + 1.0, 0.0f, 0.0f, 0.0f, 0.5f);
            }
            if (this.modMain.getSettings().arrowColour != -1) {
                float[] c = this.modMain.getSettings().arrowColours[this.modMain.getSettings().arrowColour];
                r = c[0];
                g = c[1];
                b = c[2];
                a = c[3];
            } else {
                int rgb = minimap.getEntityRadar().getPlayerTeamColour((class_1657)this.mc.field_1724);
                if (rgb != -1) {
                    r = (float)(rgb >> 16 & 0xFF) / 255.0f;
                    g = (float)(rgb >> 8 & 0xFF) / 255.0f;
                    b = (float)(rgb & 0xFF) / 255.0f;
                    a = 1.0f;
                } else {
                    float[] c = this.modMain.getSettings().arrowColours[0];
                    r = c[0];
                    g = c[1];
                    b = c[2];
                    a = c[3];
                }
            }
            this.drawArrow(arrowAngle, arrowX, arrowY, r, g, b, a *= arrowOpacity);
            GL11.glPopMatrix();
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        if (this.modMain.getSettings().getShowCoords()) {
            int interfaceSize = size / 2;
            String coords = OptimizedMath.myFloor(this.mc.method_1560().field_5987) + ", " + OptimizedMath.myFloor(this.mc.method_1560().field_6010) + ", " + OptimizedMath.myFloor(this.mc.method_1560().field_6035);
            if (this.mc.field_1772.method_1727(coords) >= interfaceSize) {
                String stringLevel = "" + OptimizedMath.myFloor(this.mc.method_1560().field_6010);
                coords = OptimizedMath.myFloor(this.mc.method_1560().field_5987) + ", " + OptimizedMath.myFloor(this.mc.method_1560().field_6035);
                this.underText.add(coords);
                this.underText.add(stringLevel);
            } else {
                this.underText.add(coords);
            }
        }
        int playerBlockX = OptimizedMath.myFloor(this.mc.method_1560().field_5987);
        int playerBlockY = OptimizedMath.myFloor(this.mc.method_1560().method_5829().field_1322);
        int playerBlockZ = OptimizedMath.myFloor(this.mc.method_1560().field_6035);
        class_2338.class_2339 pos = this.mutableBlockPos.method_10103(playerBlockX, playerBlockY, playerBlockZ);
        class_2818 chunk = this.mc.field_1687.method_8500((class_2338)pos);
        if (this.modMain.getSettings().showBiome) {
            String biomeText;
            class_1959 biome = chunk.method_16552((class_2338)pos);
            String string = biomeText = biome == null ? "Unknown Biome" : biome.method_8693().method_10863();
            if ((double)this.mc.field_1772.method_1727(biomeText) * scale <= (double)size) {
                this.underText.add(biomeText);
            } else {
                String[] biomeWords = biomeText.split(" ");
                StringBuilder lineBuilder = new StringBuilder();
                for (int i = 0; i < biomeWords.length; ++i) {
                    int lineWidth;
                    int wordStart = lineBuilder.length();
                    if (i > 0) {
                        lineBuilder.append(' ');
                    }
                    lineBuilder.append(biomeWords[i]);
                    if (i == 0 || (lineWidth = (int)((double)this.mc.field_1772.method_1727(lineBuilder.toString()) * scale)) <= size) continue;
                    lineBuilder.delete(wordStart, lineBuilder.length());
                    this.underText.add(lineBuilder.toString());
                    lineBuilder.delete(0, lineBuilder.length());
                    lineBuilder.append(biomeWords[i]);
                }
                this.underText.add(lineBuilder.toString());
            }
        }
        if (this.modMain.getSettings().showLightLevel > 0) {
            boolean lightFetchable;
            int playerBlockLightLevel = 0;
            int playerSkyLightLevel = 0;
            boolean bl = lightFetchable = playerBlockY >= 0 && playerBlockY < 256;
            if (this.modMain.getSettings().showLightLevel == 1 || this.modMain.getSettings().showLightLevel == 3) {
                int n = playerBlockLightLevel = lightFetchable ? this.mc.field_1687.method_8314(class_1944.field_9282, (class_2338)pos) : 0;
            }
            if (this.modMain.getSettings().showLightLevel == 2 || this.modMain.getSettings().showLightLevel == 3) {
                playerSkyLightLevel = lightFetchable ? this.mc.field_1687.method_8314(class_1944.field_9284, (class_2338)pos) : 15;
            }
            this.underText.add(String.format("Light: %d", Math.max(playerBlockLightLevel, playerSkyLightLevel)));
        }
        if (this.modMain.getSettings().showTime != 0) {
            long totalTime = 6000L + this.mc.field_1687.method_8532();
            int dayNumber = (int)(totalTime / 24000L) + 1;
            int dayTimeSinceMidnight = (int)(totalTime % 24000L);
            int timeHours = dayTimeSinceMidnight / 1000;
            int minutes = (int)((double)(dayTimeSinceMidnight % 1000) / 1000.0 * 60.0);
            if ((this.modMain.getSettings().showTime - 1) % 2 == 0) {
                if (this.modMain.getSettings().showTime < 3) {
                    this.underText.add(class_1074.method_4662((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d", dayNumber, timeHours, minutes));
                } else {
                    this.underText.add(String.format("%02d:%02d", timeHours, minutes));
                }
            } else {
                String half = "AM";
                if (timeHours >= 12) {
                    timeHours -= 12;
                    half = "PM";
                }
                if (timeHours == 0) {
                    timeHours = 12;
                }
                if (this.modMain.getSettings().showTime < 3) {
                    this.underText.add(class_1074.method_4662((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d %s", dayNumber, timeHours, minutes, half));
                } else {
                    this.underText.add(String.format("%02d:%02d %s", timeHours, minutes, half));
                }
            }
        }
        if (minimap.getMinimapWriter().debugTotalTime) {
            this.underText.add(String.format("Min Time %d", minimap.getMinimapWriter().minTimeDebug));
            this.underText.add(String.format("Average %d", minimap.getMinimapWriter().averageTimeDebug));
            this.underText.add(String.format("Max Time %d", minimap.getMinimapWriter().maxTimeDebug));
        }
        if (this.modMain.getSettings().showAngles) {
            this.underText.add(String.format("%.1f / %.1f", Float.valueOf(class_3532.method_15393((float)this.mc.method_1560().field_6031)), Float.valueOf(class_3532.method_15393((float)this.mc.method_1560().field_5965))));
        }
        if (this.modMain.getSettings().lightOverlayType > 0) {
            this.underText.add(class_1074.method_4662((String)"gui.xaero_light_overlay_status", (Object[])new Object[0]));
        }
        this.drawTextUnderMinimap(scaledX, scaledY, height, size, mapScale);
        GL11.glScalef((float)mapScale, (float)mapScale, (float)1.0f);
    }

    private void drawArrow(float angle, double arrowX, double arrowY, float r, float g, float b, float a) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)arrowX, (double)arrowY, (double)0.0);
        GlStateManager.rotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScaled((double)(0.5 * this.modMain.getSettings().arrowScale), (double)(0.5 * this.modMain.getSettings().arrowScale), (double)1.0);
        GL11.glTranslated((double)-13.0, (double)-6.0, (double)0.0);
        GlStateManager.color4f((float)r, (float)g, (float)b, (float)a);
        this.mc.field_1705.blit(0, 0, 49, 0, 26, 27);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void drawTextUnderMinimap(int scaledX, int scaledY, int height, int size, float mapScale) {
        int interfaceSize = size / 2;
        int scaledHeight = (int)((float)height * mapScale);
        GlStateManager.disableDepthTest();
        for (int i = 0; i < this.underText.size(); ++i) {
            String s = this.underText.get(i);
            int stringWidth = this.mc.field_1772.method_1727(s);
            boolean under = scaledY + interfaceSize / 2 < scaledHeight / 2;
            int stringY = scaledY + (under ? interfaceSize : -9) + i * 10 * (under ? 1 : -1);
            int align = this.modMain.getSettings().minimapTextAlign;
            class_310.method_1551().field_1772.method_1720(s, (float)(scaledX + (align == 0 ? interfaceSize / 2 - stringWidth / 2 : (align == 1 ? 6 : interfaceSize - 6 - stringWidth))), (float)stringY, -1);
        }
        this.underText.clear();
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    private float getSunBrightness() {
        return class_3532.method_15363((float)((this.mc.field_1687.method_8453(1.0f) - 0.2f) / 0.8f), (float)0.0f, (float)1.0f);
    }
}

