/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import net.minecraft.class_1074;
import net.minecraft.class_1297;

public class Waypoint {
    private int x;
    private int y;
    private int z;
    private String name;
    private String symbol;
    private int color;
    private boolean global;
    private boolean disabled = false;
    private int type = 0;
    private boolean rotation = false;
    private int yaw = 0;
    private boolean temporary;

    public Waypoint(int x, int y, int z, String name, String symbol, int color) {
        this(x, y, z, name, symbol, color, 0, false);
    }

    public Waypoint(int x, int y, int z, String name, String symbol, int color, int type) {
        this(x, y, z, name, symbol, color, type, false);
    }

    public Waypoint(int x, int y, int z, String name, String symbol, int color, int type, boolean temp) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.symbol = symbol;
        this.color = color;
        this.type = type;
        this.name = name;
        this.temporary = temp;
        if (this.type == 1) {
            this.global = true;
        }
    }

    public double getDistanceSq(double x, double y, double z) {
        double d3 = (double)this.x - x;
        double d4 = (double)this.y - y;
        double d5 = (double)this.z - z;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public String getLocalizedName() {
        return class_1074.method_4662((String)this.name, (Object[])new Object[0]);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean b) {
        this.temporary = false;
        this.disabled = b;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
        if (this.type == 1) {
            this.global = true;
        }
    }

    public int getX() {
        return this.x;
    }

    public int getX(double dimDiv) {
        if (dimDiv == 1.0) {
            return this.x;
        }
        return (int)Math.floor((double)this.x / dimDiv);
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int getZ(double dimDiv) {
        if (dimDiv == 1.0) {
            return this.z;
        }
        return (int)Math.floor((double)this.z / dimDiv);
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public String getName() {
        return this.name;
    }

    public String getNameSafe(String replacement) {
        return this.getName().replace(":", replacement);
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
        this.disabled = false;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbolSafe(String replacement) {
        return this.getSymbol().replace(":", replacement);
    }

    public boolean isRotation() {
        return this.rotation;
    }

    public void setRotation(boolean rotation) {
        this.rotation = rotation;
    }

    public int getYaw() {
        return this.yaw;
    }

    public void setYaw(int yaw) {
        this.yaw = yaw;
    }

    public int getColor() {
        if (this.color < 0) {
            return 0;
        }
        return this.color;
    }

    public int getActualColor() {
        return this.color;
    }

    public void setColor(int c) {
        this.color = c;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        if (this.type != 1) {
            this.global = global;
        }
    }

    public static String getStringFromStringSafe(String stringSafe, String replacement) {
        return stringSafe.replace(replacement, ":");
    }

    public boolean isServerWaypoint() {
        return false;
    }

    public String getComparisonName() {
        String comparisonName = this.getLocalizedName().toLowerCase().trim();
        if (comparisonName.startsWith("the ")) {
            comparisonName = comparisonName.substring(4);
        }
        if (comparisonName.startsWith("a ")) {
            comparisonName = comparisonName.substring(2);
        }
        return comparisonName;
    }

    public double getComparisonDistance(class_1297 entity, double dimDiv) {
        double offX = (double)this.getX(dimDiv) - entity.field_5987;
        double offY = (double)this.getY() - entity.field_6010;
        double offZ = (double)this.getZ(dimDiv) - entity.field_6035;
        return offX * offX + offY * offY + offZ * offZ;
    }
}

