/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.mods;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.region.MinimapTile;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.settings.ModSettings;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiWorldMapSettings;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTileChunk;
import xaero.map.world.MapDimension;

public class SupportXaeroWorldmap {
    public static int WORLDMAP_COMPATIBILITY_VERSION = 3;
    public int compatibilityVersion;
    private static final HashMap<MapTileChunk, Long> seedsUsed = new HashMap();
    public static final int black = -16777216;
    public static final int slime = -2142047936;
    private AXaeroMinimap modMain;

    public SupportXaeroWorldmap(AXaeroMinimap modMain) {
        this.modMain = modMain;
        try {
            this.compatibilityVersion = WorldMap.MINIMAP_COMPATIBILITY_VERSION;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        if (this.compatibilityVersion < 3) {
            throw new RuntimeException("Xaero's World Map 1.11.0 or newer required!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawMinimap(XaeroMinimapSession minimapSession, MinimapRendererHelper helper, int xFloored, int zFloored, int radius, boolean zooming, double zoom) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.renderThreadPauseSync;
        synchronized (object) {
            if (!mapProcessor.isRenderingPaused()) {
                if (mapProcessor.getCurrentDimension() == null) {
                    return;
                }
                String worldString = mapProcessor.getCurrentWorldString();
                if (worldString == null) {
                    return;
                }
                int mapX = xFloored >> 4;
                int mapZ = zFloored >> 4;
                int chunkX = mapX >> 2;
                int chunkZ = mapZ >> 2;
                int tileX = mapX & 3;
                int tileZ = mapZ & 3;
                int insideX = xFloored & 0xF;
                int insideZ = zFloored & 0xF;
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.enableBlend();
                int minX = (mapX >> 2) - 4;
                int maxX = (mapX >> 2) + 4;
                int minZ = (mapZ >> 2) - 4;
                int maxZ = (mapZ >> 2) + 4;
                int minViewX = (mapX >> 2) - radius;
                int maxViewX = (mapX >> 2) + radius + 1;
                int minViewZ = (mapZ >> 2) - radius;
                int maxViewZ = (mapZ >> 2) + radius + 1;
                float brightness = this.compatibilityVersion < 4 ? mapProcessor.getBrightness() : mapProcessor.getBrightness(this.modMain.getSettings().getLighting());
                for (int i = minX; i < maxX + 1; ++i) {
                    for (int j = minZ; j < maxZ + 1; ++j) {
                        boolean newSeed;
                        MapTileChunk chunk;
                        MapRegion region = mapProcessor.getMapRegion(i >> 3, j >> 3, mapProcessor.regionExists(i >> 3, j >> 3));
                        if (region == null) continue;
                        MapRegion mapRegion = region;
                        synchronized (mapRegion) {
                            if (!region.recacheHasBeenRequested() && !region.reloadHasBeenRequested() && (region.getVersion() != mapProcessor.getGlobalVersion() || region.getLoadState() == 4 && region.shouldCache())) {
                                if (region.isBeingWritten() && region.getLoadState() == 2) {
                                    region.requestRefresh(mapProcessor);
                                } else if (region.getLoadState() == 0 || region.getLoadState() == 4) {
                                    mapProcessor.getMapSaveLoad().requestLoad(region, "Minimap");
                                    mapProcessor.getMapSaveLoad().setNextToLoadByViewing(region);
                                }
                            }
                        }
                        if (!mapProcessor.isUploadingPaused()) {
                            List regions = mapProcessor.getMapWorld().getCurrentDimension().getMapRegionsList();
                            regions.remove(region);
                            regions.add(region);
                        }
                        if (i < minViewX || i > maxViewX || j < minViewZ || j > maxViewZ || (chunk = region.getChunk(i & 7, j & 7)) == null || chunk.getGlColorTexture() == -1) continue;
                        GuiMap.bindMapTextureWithLighting((float)brightness, (MapTileChunk)chunk, (int)(zooming ? 9729 : 9728), (int)0);
                        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
                        int drawX = 64 * (chunk.getX() - chunkX) - 16 * tileX - insideX;
                        int drawZ = 64 * (chunk.getZ() - chunkZ) - 16 * tileZ - insideZ;
                        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                        GuiMap.renderTexturedModalRectWithLighting((float)drawX, (float)drawZ, (int)0, (int)0, (float)64.0f, (float)64.0f);
                        int r = 0;
                        int g = 0;
                        int b = 0;
                        if (this.modMain.getSettings().chunkGrid > -1) {
                            int grid = ModSettings.COLORS[this.modMain.getSettings().chunkGrid];
                            r = grid >> 16 & 0xFF;
                            g = grid >> 8 & 0xFF;
                            b = grid & 0xFF;
                        }
                        Long seed = this.modMain.getSettings().getSlimeChunksSeed(minimapSession.getWaypointsManager().getCurrentContainerAndWorldID());
                        Long savedSeed = seedsUsed.get(chunk);
                        boolean bl = newSeed = seed == null && savedSeed != null || seed != null && !seed.equals(savedSeed);
                        if (newSeed) {
                            seedsUsed.put(chunk, seed);
                        }
                        GuiMap.restoreTextureStates();
                        for (int t = 0; t < 16; ++t) {
                            if (newSeed || (chunk.getTileGridsCache()[t % 4][t / 4] & 1) == 0) {
                                chunk.getTileGridsCache()[t % 4][t / 4] = (byte)(1 | (MinimapTile.isSlimeChunk(this.modMain.getSettings(), chunk.getX() * 4 + t % 4, chunk.getZ() * 4 + t / 4, seed) ? 2 : 0));
                            }
                            if (!this.modMain.getSettings().getSlimeChunks(minimapSession.getWaypointsManager()) || (chunk.getTileGridsCache()[t % 4][t / 4] & 2) == 0) continue;
                            int slimeDrawX = drawX + 16 * (t % 4);
                            int slimeDrawZ = drawZ + 16 * (t / 4);
                            class_332.fill((int)slimeDrawX, (int)slimeDrawZ, (int)(slimeDrawX + 16), (int)(slimeDrawZ + 16), (int)-2142047936);
                        }
                        if (this.modMain.getSettings().chunkGrid > -1) {
                            float top;
                            GlStateManager.disableTexture();
                            GlStateManager.enableBlend();
                            GlStateManager.pushMatrix();
                            GlStateManager.translatef((float)(drawX + 64), (float)(drawZ + 64), (float)0.0f);
                            GlStateManager.scaled((double)(1.0 / zoom), (double)(1.0 / zoom), (double)1.0);
                            GlStateManager.color4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)0.5f);
                            float left = top = (float)(-64.0 * zoom);
                            helper.drawMyColoredRect(left, -1.0f, 0.0f, 0.0f);
                            helper.drawMyColoredRect(left, (float)(-16.0 * zoom) - 1.0f, 0.0f, (float)(-16.0 * zoom));
                            helper.drawMyColoredRect(left, (float)(-32.0 * zoom) - 1.0f, 0.0f, (float)(-32.0 * zoom));
                            helper.drawMyColoredRect(left, (float)(-48.0 * zoom) - 1.0f, 0.0f, (float)(-48.0 * zoom));
                            helper.drawMyColoredRect(-1.0f, top, 0.0f, 0.0f);
                            helper.drawMyColoredRect((float)(-16.0 * zoom) - 1.0f, top, (float)(-16.0 * zoom), 0.0f);
                            helper.drawMyColoredRect((float)(-32.0 * zoom) - 1.0f, top, (float)(-32.0 * zoom), 0.0f);
                            helper.drawMyColoredRect((float)(-48.0 * zoom) - 1.0f, top, (float)(-48.0 * zoom), 0.0f);
                            GlStateManager.popMatrix();
                            GlStateManager.disableBlend();
                            GlStateManager.enableTexture();
                        }
                        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GlStateManager.enableBlend();
                    }
                }
                GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                GlStateManager.disableBlend();
            }
        }
    }

    public boolean getWorldMapWaypoints() {
        return WorldMap.settings.waypoints;
    }

    public int getWorldMapColours() {
        return WorldMap.settings.colours;
    }

    public boolean getWorldMapFlowers() {
        return WorldMap.settings.flowers;
    }

    public boolean getWorldMapLighting() {
        return WorldMap.settings.lighting;
    }

    public boolean getWorldMapTerrainDepth() {
        return WorldMap.settings.terrainDepth;
    }

    public int getWorldMapTerrainSlopes() {
        return WorldMap.settings.terrainSlopes;
    }

    public boolean getWorldMapBiomeColorsVanillaMode() {
        return WorldMap.settings.biomeColorsVanillaMode;
    }

    public boolean getWorldMapIgnoreHeightmaps() {
        return WorldMap.settings.ignoreHeightmaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMultiworldId(int dimId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            MapDimension mapDim = !mapProcessor.isMapWorldUsable() ? null : mapProcessor.getMapWorld().getDimension(dimId);
            return mapDim == null || !mapDim.currentMultiworldWritable ? null : mapDim.getCurrentMultiworld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPotentialMultiworldIds(int dimId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            MapDimension mapDim = mapProcessor.getMapWorld().createDimensionUnsynced(dimId);
            return mapDim == null || mapDim.currentMultiworldWritable ? null : mapDim.getMultiworldIdsCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMultiworldName(int dimId, String multiworldId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            MapDimension mapDim = !mapProcessor.isMapWorldUsable() ? null : mapProcessor.getMapWorld().createDimensionUnsynced(dimId);
            return mapDim == null ? null : mapDim.getMultiworldName(multiworldId);
        }
    }

    public void openSettings() {
        class_310.method_1551().method_1507((class_437)new GuiWorldMapSettings(class_310.method_1551().field_1755));
    }
}

