/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import xerca.xercamod.client.CarvingStationScreen;
import xerca.xercamod.client.DonerTileEntityRenderer;
import xerca.xercamod.client.GuiFunctionalBookcase;
import xerca.xercamod.client.HookSound;
import xerca.xercamod.client.RenderConfettiBallFactory;
import xerca.xercamod.client.RenderCushionFactory;
import xerca.xercamod.client.RenderHookFactory;
import xerca.xercamod.client.RenderTomatoFactory;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.HookReturningEvent;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.block.Blocks;
import xerca.xercamod.common.entity.Entities;
import xerca.xercamod.common.entity.EntityHook;
import xerca.xercamod.common.item.ItemGrabHook;
import xerca.xercamod.common.item.ItemScythe;
import xerca.xercamod.common.item.ItemWarhammer;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.tile_entity.XercaTileEntities;

public class ClientStuff {
    private static final ResourceLocation blackTexture = new ResourceLocation("xercamod", "textures/misc/black.png");
    private static Minecraft mc;

    @Mod.EventBusSubscriber(modid="xercamod", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    static class ForgeBusSubscriber {
        ForgeBusSubscriber() {
        }

        @SubscribeEvent
        public static void hookReturningEvent(HookReturningEvent ev) {
            EntityHook ent = (EntityHook)ev.getEntity();
            if (ent.f_19853_.f_46443_) {
                mc.m_91106_().m_120367_((SoundInstance)new HookSound(ent, true));
            }
        }

        @SubscribeEvent
        public static void entityConstEvent(EntityEvent.EntityConstructing ev) {
            Entity ent = ev.getEntity();
            if (ent instanceof EntityHook) {
                EntityHook hook = (EntityHook)ent;
                if (ent.f_19853_.f_46443_) {
                    mc.m_91106_().m_120367_((SoundInstance)new HookSound(hook, false));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
            XercaMod.LOGGER.debug("ClientLoggedOut Event");
            Config.bakeConfig();
        }

        @SubscribeEvent
        public static void inputUpdateEvent(InputUpdateEvent updateEvent) {
            ItemStack activeItem = updateEvent.getPlayer().m_21211_();
            if (activeItem.m_41720_() instanceof ItemWarhammer && updateEvent.getPlayer().m_6117_()) {
                int legerityLevel = EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_QUICK, (ItemStack)activeItem);
                if (legerityLevel > 4) {
                    legerityLevel = 4;
                }
                float bonus = 3.0f + 0.5f * (float)legerityLevel;
                updateEvent.getMovementInput().f_108566_ *= bonus;
                updateEvent.getMovementInput().f_108567_ *= bonus;
            }
        }
    }

    @Mod.EventBusSubscriber(modid="xercamod", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    static class ModBusSubscriber {
        ModBusSubscriber() {
        }

        @SubscribeEvent
        public static void clientSetupHandler(FMLClientSetupEvent event) {
            MenuScreens.m_96206_(XercaTileEntities.CONTAINER_FUNCTIONAL_BOOKCASE, GuiFunctionalBookcase::new);
            MenuScreens.m_96206_(XercaTileEntities.CONTAINER_CARVING_STATION, CarvingStationScreen::new);
            ItemBlockRenderTypes.setRenderLayer((Block)Blocks.BLOCK_TEA_PLANT, (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)Blocks.BLOCK_TOMATO_PLANT, (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)Blocks.BLOCK_RICE_PLANT, (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)Blocks.CARVED_ACACIA_1, (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)Blocks.CARVED_ACACIA_2, (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)Blocks.CARVED_ACACIA_3, (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)Blocks.CARVED_ACACIA_4, (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)Blocks.CARVED_ACACIA_5, (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)Blocks.CARVED_ACACIA_6, (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)Blocks.CARVED_ACACIA_7, (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)Blocks.CARVED_ACACIA_8, (RenderType)RenderType.m_110457_());
            ModBusSubscriber.registerItemModelsProperties();
            mc = Minecraft.m_91087_();
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(Entities.TOMATO, (EntityRendererProvider)new RenderTomatoFactory());
            event.registerEntityRenderer(Entities.CONFETTI_BALL, (EntityRendererProvider)new RenderConfettiBallFactory());
            event.registerEntityRenderer(Entities.HOOK, (EntityRendererProvider)new RenderHookFactory());
            event.registerEntityRenderer(Entities.CUSHION, (EntityRendererProvider)new RenderCushionFactory());
            event.registerBlockEntityRenderer(XercaTileEntities.DONER, DonerTileEntityRenderer::new);
        }

        private static void registerItemModelsProperties() {
            ItemPropertyFunction warhammerPull = (stack, worldIn, entityIn, i) -> {
                if (entityIn == null) {
                    return 0.0f;
                }
                return entityIn.m_21211_().m_41720_() instanceof ItemWarhammer ? (float)(stack.m_41779_() - entityIn.m_21212_()) / 20.0f : 0.0f;
            };
            ItemPropertyFunction grabHookPull = (stack, worldIn, entityIn, i) -> {
                if (entityIn == null) {
                    return 0.0f;
                }
                return entityIn.m_21211_().m_41720_() instanceof ItemGrabHook ? (float)(stack.m_41779_() - entityIn.m_21212_()) / 20.0f : 0.0f;
            };
            ItemPropertyFunction scythePull = (stack, worldIn, entityIn, i) -> {
                if (entityIn == null) {
                    return 0.0f;
                }
                return entityIn.m_21211_().m_41720_() instanceof ItemScythe ? (float)(stack.m_41779_() - entityIn.m_21212_()) / 20.0f : 0.0f;
            };
            ItemPropertyFunction pulling = (stack, worldIn, entityIn, i) -> entityIn != null && entityIn.m_6117_() && entityIn.m_21211_() == stack ? 1.0f : 0.0f;
            ItemProperties.register((Item)Items.STONE_SCYTHE, (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)scythePull);
            ItemProperties.register((Item)Items.STONE_SCYTHE, (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)pulling);
            ItemProperties.register((Item)Items.WOODEN_SCYTHE, (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)scythePull);
            ItemProperties.register((Item)Items.WOODEN_SCYTHE, (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)pulling);
            ItemProperties.register((Item)Items.IRON_SCYTHE, (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)scythePull);
            ItemProperties.register((Item)Items.IRON_SCYTHE, (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)pulling);
            ItemProperties.register((Item)Items.GOLDEN_SCYTHE, (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)scythePull);
            ItemProperties.register((Item)Items.GOLDEN_SCYTHE, (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)pulling);
            ItemProperties.register((Item)Items.DIAMOND_SCYTHE, (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)scythePull);
            ItemProperties.register((Item)Items.DIAMOND_SCYTHE, (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)pulling);
            ItemProperties.register((Item)Items.NETHERITE_SCYTHE, (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)scythePull);
            ItemProperties.register((Item)Items.NETHERITE_SCYTHE, (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)pulling);
            ItemProperties.register((Item)Items.ITEM_GRAB_HOOK, (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)grabHookPull);
            ItemProperties.register((Item)Items.ITEM_GRAB_HOOK, (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)pulling);
            ItemProperties.register((Item)Items.ITEM_GRAB_HOOK, (ResourceLocation)new ResourceLocation("cast"), (stack, worldIn, entityIn, i) -> {
                if (!stack.m_41782_()) {
                    return 0.0f;
                }
                CompoundTag tag = stack.m_41783_();
                if (!tag.m_128441_("cast")) {
                    return 0.0f;
                }
                return tag.m_128471_("cast") ? 1.0f : 0.0f;
            });
            ItemProperties.register((Item)Items.ITEM_STONE_WARHAMMER, (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)warhammerPull);
            ItemProperties.register((Item)Items.ITEM_STONE_WARHAMMER, (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)pulling);
            ItemProperties.register((Item)Items.ITEM_IRON_WARHAMMER, (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)warhammerPull);
            ItemProperties.register((Item)Items.ITEM_IRON_WARHAMMER, (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)pulling);
            ItemProperties.register((Item)Items.ITEM_GOLD_WARHAMMER, (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)warhammerPull);
            ItemProperties.register((Item)Items.ITEM_GOLD_WARHAMMER, (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)pulling);
            ItemProperties.register((Item)Items.ITEM_DIAMOND_WARHAMMER, (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)warhammerPull);
            ItemProperties.register((Item)Items.ITEM_DIAMOND_WARHAMMER, (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)pulling);
            ItemProperties.register((Item)Items.ITEM_NETHERITE_WARHAMMER, (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)warhammerPull);
            ItemProperties.register((Item)Items.ITEM_NETHERITE_WARHAMMER, (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)pulling);
        }

        @SubscribeEvent
        public static void handleItemColors(ColorHandlerEvent.Item event) {
            if (Items.FLASK != null) {
                event.getItemColors().m_92689_((itemStack, colorIndex) -> colorIndex > 0 ? -1 : PotionUtils.m_43575_((ItemStack)itemStack), new ItemLike[]{Items.FLASK});
            }
            if (Items.ENDER_BOW != null) {
                event.getItemColors().m_92689_((itemStack, colorIndex) -> colorIndex > 0 ? -1 : PotionUtils.m_43575_((ItemStack)itemStack), new ItemLike[]{Items.ENDER_BOW});
            }
        }
    }
}

