/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import xerca.xercamod.common.Config;

public class ConfigPredicate {
    private final Supplier<Boolean> condition;
    private final String configName;

    public ConfigPredicate(Supplier<Boolean> supplier, String name) {
        this.condition = supplier;
        this.configName = name;
    }

    public boolean test() {
        if (this.condition == null) {
            return false;
        }
        return this.condition.get();
    }

    public static ConfigPredicate deserialize(@Nullable JsonElement element) {
        String configName;
        if (element != null && !element.isJsonNull() && Config.conditionMap.containsKey(configName = element.getAsJsonObject().get("config").getAsString())) {
            return new ConfigPredicate(Config.conditionMap.get(configName), configName);
        }
        return null;
    }

    public JsonElement serialize() {
        JsonObject jsonobject = new JsonObject();
        if (this.condition != null) {
            jsonobject.addProperty("config", this.configName);
        }
        return jsonobject;
    }
}

