/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xerca.xercamod.common.block.Blocks;
import xerca.xercamod.common.crafting.RecipeCarvingStation;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.tile_entity.XercaTileEntities;

@ParametersAreNonnullByDefault
public class ContainerCarvingStation
extends AbstractContainerMenu {
    private final ContainerLevelAccess worldPosCallable;
    private final DataSlot selectedRecipe = DataSlot.m_39401_();
    private final Level world;
    private List<RecipeCarvingStation> recipes = Lists.newArrayList();
    private ItemStack itemStackInput = ItemStack.f_41583_;
    private long lastOnTake;
    final Slot inputInventorySlot;
    final Slot outputInventorySlot;
    private Runnable inventoryUpdateListener = () -> {};
    public final Container inputInventory = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            ContainerCarvingStation.this.m_6199_((Container)this);
            ContainerCarvingStation.this.inventoryUpdateListener.run();
        }
    };
    private final ResultContainer inventory = new ResultContainer();

    public ContainerCarvingStation(int windowIdIn, Inventory playerInventoryIn, FriendlyByteBuf extraData) {
        this(windowIdIn, playerInventoryIn, ContainerLevelAccess.f_39287_);
    }

    public ContainerCarvingStation(int windowIdIn, Inventory playerInventoryIn, final ContainerLevelAccess worldPosCallableIn) {
        super(XercaTileEntities.CONTAINER_CARVING_STATION, windowIdIn);
        this.worldPosCallable = worldPosCallableIn;
        this.world = playerInventoryIn.f_35978_.f_19853_;
        this.inputInventorySlot = this.m_38897_(new Slot(this.inputInventory, 0, 20, 33));
        this.outputInventorySlot = this.m_38897_(new Slot((Container)this.inventory, 1, 143, 33){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player thePlayer, ItemStack stack) {
                ItemStack itemstack = ContainerCarvingStation.this.inputInventorySlot.m_6201_(1);
                if (!itemstack.m_41619_()) {
                    ContainerCarvingStation.this.updateRecipeResultSlot();
                }
                stack.m_41720_().m_7836_(stack, thePlayer.f_19853_, thePlayer);
                worldPosCallableIn.m_39292_((world, blockPos) -> {
                    long l = world.m_46467_();
                    if (ContainerCarvingStation.this.lastOnTake != l) {
                        world.m_5594_(null, blockPos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        ContainerCarvingStation.this.lastOnTake = l;
                    }
                });
                super.m_142406_(thePlayer, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventoryIn, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventoryIn, k, 8 + k * 18, 142));
        }
        this.m_38895_(this.selectedRecipe);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSelectedRecipe() {
        return this.selectedRecipe.m_6501_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<RecipeCarvingStation> getRecipeList() {
        return this.recipes;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getRecipeListSize() {
        return this.recipes.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasItemsinInputSlot() {
        return this.inputInventorySlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(Player playerIn) {
        return ContainerCarvingStation.m_38889_((ContainerLevelAccess)this.worldPosCallable, (Player)playerIn, (Block)Blocks.CARVING_STATION);
    }

    public boolean m_6366_(Player playerIn, int id) {
        if (id >= 0 && id < this.recipes.size()) {
            this.selectedRecipe.m_6422_(id);
            this.updateRecipeResultSlot();
        }
        return true;
    }

    public void m_6199_(Container inventoryIn) {
        ItemStack itemstack = this.inputInventorySlot.m_7993_();
        if (itemstack.m_41720_() != this.itemStackInput.m_41720_()) {
            this.itemStackInput = itemstack.m_41777_();
            this.updateAvailableRecipes(inventoryIn, itemstack);
        }
    }

    private void updateAvailableRecipes(Container inventoryIn, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipe.m_6422_(-1);
        this.outputInventorySlot.m_5852_(ItemStack.f_41583_);
        if (!stack.m_41619_()) {
            this.recipes = this.world.m_7465_().m_44056_(Items.CARVING_STATION_TYPE, inventoryIn, this.world);
        }
    }

    private void updateRecipeResultSlot() {
        if (!this.recipes.isEmpty()) {
            RecipeCarvingStation RecipeCarvingStation2 = this.recipes.get(this.selectedRecipe.m_6501_());
            this.outputInventorySlot.m_5852_(RecipeCarvingStation2.m_5874_(this.inputInventory));
        } else {
            this.outputInventorySlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public MenuType<?> m_6772_() {
        return XercaTileEntities.CONTAINER_CARVING_STATION;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn.f_40218_ != this.inventory && super.m_5882_(stack, slotIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            Item item = itemstack1.m_41720_();
            itemstack = itemstack1.m_41777_();
            if (index == 1) {
                item.m_7836_(itemstack1, playerIn.f_19853_, playerIn);
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index == 0 ? !this.m_38903_(itemstack1, 2, 38, false) : (this.world.m_7465_().m_44015_(Items.CARVING_STATION_TYPE, (Container)new SimpleContainer(new ItemStack[]{itemstack1}), this.world).isPresent() ? !this.m_38903_(itemstack1, 0, 1, false) : (index >= 2 && index < 29 ? !this.m_38903_(itemstack1, 29, 38, false) : index >= 29 && index < 38 && !this.m_38903_(itemstack1, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
            this.m_38946_();
        }
        return itemstack;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.inventory.m_8016_(1);
        this.worldPosCallable.m_39292_((p_217079_2_, p_217079_3_) -> this.m_150411_(playerIn, this.inputInventory));
    }
}

