/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.tile_entity.TileEntityFunctionalBookcase;
import xerca.xercamod.common.tile_entity.XercaTileEntities;

public class ContainerFunctionalBookcase
extends AbstractContainerMenu {
    public static List<ResourceLocation> acceptedItems = new ArrayList<ResourceLocation>();
    private TileEntityFunctionalBookcase tileEntity;

    public ContainerFunctionalBookcase(int windowId, Inventory inv, FriendlyByteBuf extraData) {
        this(windowId, inv, inv.f_35978_.f_19853_.m_7702_(extraData.m_130135_()));
    }

    public ContainerFunctionalBookcase(int windowId, Inventory invPlayer, BlockEntity tileEntityInventoryBookcase) {
        super(XercaTileEntities.CONTAINER_FUNCTIONAL_BOOKCASE, windowId);
        if (!(tileEntityInventoryBookcase instanceof TileEntityFunctionalBookcase)) {
            XercaMod.LOGGER.error("TileEntity not an instance of TileEntityFunctionalBookcase!");
            return;
        }
        this.tileEntity = (TileEntityFunctionalBookcase)tileEntityInventoryBookcase;
        IItemHandler bookcaseInventory = (IItemHandler)tileEntityInventoryBookcase.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(NullPointerException::new);
        int SLOT_X_SPACING = 18;
        int SLOT_Y_SPACING = 18;
        int TE_INVENTORY_SLOT_COUNT = 6;
        if (6 != bookcaseInventory.getSlots()) {
            XercaMod.LOGGER.error("Mismatched slot count in ContainerFunctionalBookcase(6) and TileEntityFunctionalBookcase (" + bookcaseInventory.getSlots() + ")");
        }
        int TILE_INVENTORY_XPOS = 61;
        int TILE_INVENTORY_YPOS = 17;
        int TILE_SLOT_Y_SPACING = 32;
        int TILE_ROW_COUNT = 2;
        int TILE_COLUMN_COUNT = 3;
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 3; ++x) {
                int slotNumber = y * 3 + x;
                int xpos = 61 + x * 18;
                int ypos = 17 + y * 32;
                this.m_38897_((Slot)new SlotBook(bookcaseInventory, slotNumber, xpos, ypos));
            }
        }
        int HOTBAR_XPOS = 8;
        int HOTBAR_YPOS = 142;
        int HOTBAR_SLOT_COUNT = 9;
        for (int x = 0; x < HOTBAR_SLOT_COUNT; ++x) {
            this.m_38897_(new Slot((Container)invPlayer, x, 8 + 18 * x, 142));
        }
        int PLAYER_INVENTORY_XPOS = 8;
        int PLAYER_INVENTORY_YPOS = 84;
        int PLAYER_INVENTORY_ROW_COUNT = 3;
        int PLAYER_INVENTORY_COLUMN_COUNT = 9;
        for (int y = 0; y < PLAYER_INVENTORY_ROW_COUNT; ++y) {
            for (int x = 0; x < PLAYER_INVENTORY_COLUMN_COUNT; ++x) {
                int slotNumber = HOTBAR_SLOT_COUNT + y * PLAYER_INVENTORY_COLUMN_COUNT + x;
                int xpos = 8 + x * 18;
                int ypos = 84 + y * 18;
                this.m_38897_(new Slot((Container)invPlayer, slotNumber, xpos, ypos));
            }
        }
    }

    public boolean m_6875_(@Nonnull Player player) {
        return this.tileEntity.isUsableByPlayer(player);
    }

    @Nonnull
    public ItemStack m_7648_(Player player, int sourceSlotIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(sourceSlotIndex);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            int containerSlots = this.f_38839_.size() - player.m_150109_().f_35974_.size();
            if (sourceSlotIndex < containerSlots ? !this.m_38903_(itemstack1, containerSlots, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, containerSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.tileEntity.closeInventory(playerIn);
    }

    class SlotBook
    extends SlotItemHandler {
        SlotBook(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            Item it = stack.m_41720_();
            return it == Items.f_42517_ || it == Items.f_42614_ || it == Items.f_42615_ || it == Items.f_42690_ || acceptedItems.contains(it.getRegistryName());
        }

        public void m_6654_() {
            ContainerFunctionalBookcase.this.tileEntity.m_6596_();
        }
    }
}

