/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.EnchantedItemTrade;
import xerca.xercamod.common.Triggers;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.block.Blocks;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.ConfigSyncPacket;

@Mod.EventBusSubscriber(modid="xercamod")
class EventHandler {
    EventHandler() {
    }

    @SubscribeEvent
    public static void villagerTradesEvent(VillagerTradesEvent ev) {
        if (Config.isFoodEnabled() && ev.getType().equals(VillagerProfession.f_35590_)) {
            ((List)ev.getTrades().get(1)).add(new BasicTrade(new ItemStack((ItemLike)Items.ITEM_RICE_SEEDS, 24), new ItemStack((ItemLike)net.minecraft.world.item.Items.f_42616_), 16, 2, 0.05f));
            ((List)ev.getTrades().get(1)).add(new BasicTrade(new ItemStack((ItemLike)Items.ITEM_TOMATO, 22), new ItemStack((ItemLike)net.minecraft.world.item.Items.f_42616_), 16, 2, 0.05f));
            ((List)ev.getTrades().get(1)).add(new BasicTrade(new ItemStack((ItemLike)Items.ITEM_TEA_LEAF, 18), new ItemStack((ItemLike)net.minecraft.world.item.Items.f_42616_), 16, 2, 0.05f));
        }
        if (Config.isScytheEnabled() && ev.getType().equals(VillagerProfession.f_35598_)) {
            ((List)ev.getTrades().get(1)).add(new BasicTrade(1, new ItemStack((ItemLike)Items.STONE_SCYTHE), 12, 1, 0.2f));
            ((List)ev.getTrades().get(3)).add(new EnchantedItemTrade((Item)Items.IRON_SCYTHE, 2, 3, 10, 0.2f));
            ((List)ev.getTrades().get(4)).add(new EnchantedItemTrade((Item)Items.DIAMOND_SCYTHE, 5, 3, 15, 0.2f));
        }
        if (Config.isWarhammerEnabled() && ev.getType().equals(VillagerProfession.f_35599_)) {
            ((List)ev.getTrades().get(3)).add(new EnchantedItemTrade(Items.ITEM_IRON_WARHAMMER, 3, 3, 20, 0.2f));
            ((List)ev.getTrades().get(5)).add(new EnchantedItemTrade(Items.ITEM_DIAMOND_WARHAMMER, 10, 3, 30, 0.2f));
        }
    }

    @SubscribeEvent
    public static void craftEvent(PlayerEvent.ItemCraftedEvent ev) {
        Item result = ev.getCrafting().m_41720_();
        if (result == Items.ITEM_GRAB_HOOK || result == Items.ITEM_KNIFE || result == Items.CARVING_STATION) {
            for (int i = 0; i < ev.getInventory().m_6643_(); ++i) {
                ItemStack item = ev.getInventory().m_8020_(i);
                if (item.m_41720_() != Items.ITEM_KNIFE) continue;
                ev.getInventory().m_6836_(i, ItemStack.f_41583_);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        XercaMod.LOGGER.debug("PlayerLoggedIn Event: Syncing config");
        ServerPlayer serverPlayer = (ServerPlayer)event.getPlayer();
        ConfigSyncPacket pack = Config.makePacket();
        XercaMod.NETWORK_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)pack);
        Triggers.CONFIG_CHECK.test(serverPlayer);
        ArrayList<Recipe> recipesToRemove = new ArrayList<Recipe>();
        for (Recipe r : serverPlayer.f_8924_.m_129894_().m_44051_()) {
            if (!r.m_6423_().m_135827_().equals("xercamod")) continue;
            String path = r.m_6423_().m_135815_();
            for (String conditionName : Config.conditionMap.keySet()) {
                int slash;
                if (Config.conditionMap.get(conditionName).get().booleanValue() || (slash = path.indexOf("/")) <= 0 || !conditionName.equals(path.substring(0, slash)) || !serverPlayer.m_8952_().m_12709_(r)) continue;
                XercaMod.LOGGER.warn("Removing Recipe " + path);
                recipesToRemove.add(r);
            }
        }
        if (!recipesToRemove.isEmpty()) {
            serverPlayer.m_8952_().m_12806_(recipesToRemove, serverPlayer);
            for (Recipe r : recipesToRemove) {
                Advancement advancement = serverPlayer.f_8924_.m_129889_().m_136041_(new ResourceLocation("xercamod", "recipes/" + r.m_6423_().m_135815_()));
                if (advancement == null) continue;
                serverPlayer.m_8960_().m_135998_(advancement, "config");
                serverPlayer.m_8960_().m_135998_(advancement, "has_item");
                serverPlayer.m_8960_().m_135998_(advancement, "has_the_recipe");
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClickedBlock(PlayerInteractEvent.RightClickBlock event) {
        Level world = event.getWorld();
        ItemStack heldItem = event.getPlayer().m_21120_(event.getHand());
        if (world.m_8055_(event.getPos()).m_60734_() == net.minecraft.world.level.block.Blocks.f_50183_ && heldItem.m_41720_() == net.minecraft.world.item.Items.f_42658_) {
            world.m_46597_(event.getPos(), Blocks.BLOCK_DONER.m_49966_());
            heldItem.m_41774_(1);
            world.m_5594_(null, event.getPos(), SoundEvents.f_12392_, SoundSource.BLOCKS, 0.8f, 0.9f + world.f_46441_.nextFloat() * 0.1f);
        }
    }
}

