/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import xerca.xercamod.common.Config;

public class SeedLootModifier
extends LootModifier {
    private final Item itemSeed;
    private final boolean isFood;

    protected SeedLootModifier(LootItemCondition[] conditionsIn, Item itemSeed, boolean isFood) {
        super(conditionsIn);
        this.itemSeed = itemSeed;
        this.isFood = isFood;
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (this.isFood && !Config.isFoodEnabled() || !this.isFood && !Config.isTeaEnabled()) {
            return generatedLoot;
        }
        generatedLoot.add(new ItemStack((ItemLike)this.itemSeed));
        return generatedLoot;
    }

    static class Serializer
    extends GlobalLootModifierSerializer<SeedLootModifier> {
        Serializer() {
        }

        public SeedLootModifier read(ResourceLocation name, JsonObject object, LootItemCondition[] conditionsIn) {
            Item seed = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"seedItem")));
            boolean isFood = GsonHelper.m_13912_((JsonObject)object, (String)"isFood");
            return new SeedLootModifier(conditionsIn, seed, isFood);
        }

        public JsonObject write(SeedLootModifier instance) {
            JsonObject json = new JsonObject();
            ResourceLocation itemRL = Registry.f_122827_.m_7981_((Object)instance.itemSeed);
            json.addProperty("seedItem", itemRL.toString());
            json.addProperty("isFood", Boolean.valueOf(instance.isFood));
            return json;
        }
    }
}

