/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import net.minecraftforge.fmllegacy.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xerca.xercamod.common.ConfettiDispenseItemBehavior;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.ContainerFunctionalBookcase;
import xerca.xercamod.common.DecoCreativeTab;
import xerca.xercamod.common.SeedLootModifier;
import xerca.xercamod.common.Triggers;
import xerca.xercamod.common.entity.EntityConfettiBall;
import xerca.xercamod.common.entity.EntityTomato;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.BeheadParticlePacket;
import xerca.xercamod.common.packets.BeheadParticlePacketHandler;
import xerca.xercamod.common.packets.ConfettiParticlePacket;
import xerca.xercamod.common.packets.ConfettiParticlePacketHandler;
import xerca.xercamod.common.packets.ConfigSyncPacket;
import xerca.xercamod.common.packets.ConfigSyncPacketHandler;
import xerca.xercamod.common.packets.HammerAttackPacket;
import xerca.xercamod.common.packets.HammerAttackPacketHandler;
import xerca.xercamod.common.packets.HammerQuakePacket;
import xerca.xercamod.common.packets.HammerQuakePacketHandler;
import xerca.xercamod.common.packets.KnifeAttackPacket;
import xerca.xercamod.common.packets.KnifeAttackPacketHandler;
import xerca.xercamod.common.packets.QuakeParticlePacket;
import xerca.xercamod.common.packets.QuakeParticlePacketHandler;
import xerca.xercamod.common.packets.ScytheAttackPacket;
import xerca.xercamod.common.packets.ScytheAttackPacketHandler;

@Mod(value="xercamod")
public class XercaMod {
    public static final String MODID = "xercamod";
    public static final String NAME = "Xerca Mod";
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    public static final SimpleChannel NETWORK_HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("xercamod", "main_channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    public static final Logger LOGGER = LogManager.getLogger();

    public XercaMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG);
        Config.loadConfig(Config.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("xercamod-common.toml"));
    }

    private void networkRegistry() {
        int msg_id = 0;
        NETWORK_HANDLER.registerMessage(msg_id++, HammerAttackPacket.class, HammerAttackPacket::encode, HammerAttackPacket::decode, HammerAttackPacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, KnifeAttackPacket.class, KnifeAttackPacket::encode, KnifeAttackPacket::decode, KnifeAttackPacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, HammerQuakePacket.class, HammerQuakePacket::encode, HammerQuakePacket::decode, HammerQuakePacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, ConfettiParticlePacket.class, ConfettiParticlePacket::encode, ConfettiParticlePacket::decode, ConfettiParticlePacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, QuakeParticlePacket.class, QuakeParticlePacket::encode, QuakeParticlePacket::decode, QuakeParticlePacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, ConfigSyncPacket.class, ConfigSyncPacket::encode, ConfigSyncPacket::decode, ConfigSyncPacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, ScytheAttackPacket.class, ScytheAttackPacket::encode, ScytheAttackPacket::decode, ScytheAttackPacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id, BeheadParticlePacket.class, BeheadParticlePacket::encode, BeheadParticlePacket::decode, BeheadParticlePacketHandler::handle);
    }

    private void setup(FMLCommonSetupEvent event) {
        this.networkRegistry();
        this.registerTriggers();
        DispenserBlock.m_52672_((ItemLike)Items.ITEM_CONFETTI_BALL, (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            @Nonnull
            protected Projectile m_6895_(@Nonnull Level worldIn, @Nonnull Position position, @Nonnull ItemStack stackIn) {
                return new EntityConfettiBall(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_());
            }
        });
        DispenserBlock.m_52672_((ItemLike)Items.ITEM_TOMATO, (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            @Nonnull
            protected Projectile m_6895_(@Nonnull Level worldIn, @Nonnull Position position, @Nonnull ItemStack stackIn) {
                return new EntityTomato(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_());
            }
        });
        DispenserBlock.m_52672_((ItemLike)Items.ITEM_CONFETTI, (DispenseItemBehavior)new ConfettiDispenseItemBehavior());
        Items.registerCompostables();
        DecoCreativeTab.initItemList();
    }

    private void registerTriggers() {
        for (int i = 0; i < Triggers.TRIGGER_ARRAY.length; ++i) {
            CriteriaTriggers.m_10595_((CriterionTrigger)Triggers.TRIGGER_ARRAY[i]);
        }
        CriteriaTriggers.m_10595_((CriterionTrigger)Triggers.CONFIG_CHECK);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
        List list = event.getIMCStream().collect(Collectors.toList());
        LOGGER.debug("Got IMC {}", list);
        for (InterModComms.IMCMessage msg : list) {
            if (!msg.getMethod().equals("send_note")) continue;
            Object result = msg.getMessageSupplier().get();
            if (result instanceof ResourceLocation) {
                ResourceLocation itemNoteResourceLocation = (ResourceLocation)result;
                ContainerFunctionalBookcase.acceptedItems.add(itemNoteResourceLocation);
                continue;
            }
            LOGGER.error("send_note from XercaMusic failed to sent a ResourceLocation");
        }
    }

    @Mod.EventBusSubscriber(modid="xercamod", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerLootModifiers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)new SeedLootModifier.Serializer().setRegistryName(new ResourceLocation(XercaMod.MODID, "rice_seeds")));
            event.getRegistry().register((IForgeRegistryEntry)new SeedLootModifier.Serializer().setRegistryName(new ResourceLocation(XercaMod.MODID, "tomato_seeds")));
            event.getRegistry().register((IForgeRegistryEntry)new SeedLootModifier.Serializer().setRegistryName(new ResourceLocation(XercaMod.MODID, "tea_seeds")));
        }
    }
}

