/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import xerca.xercamod.common.tile_entity.TileEntityFunctionalBookcase;

public class BlockFunctionalBookcase
extends Block
implements EntityBlock {
    public static final IntegerProperty BOOK_AMOUNT = IntegerProperty.m_61631_((String)"books", (int)0, (int)6);

    public BlockFunctionalBookcase() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BOOK_AMOUNT, (Comparable)Integer.valueOf(0)));
        this.setRegistryName("block_bookcase");
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            TileEntityFunctionalBookcase tileEntity = (TileEntityFunctionalBookcase)worldIn.m_7702_(pos);
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)tileEntity, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tent = worldIn.m_7702_(pos);
            IItemHandler inventory = (IItemHandler)tent.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(NullPointerException::new);
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (inventory.getStackInSlot(i).m_41619_()) continue;
                ItemEntity item = new ItemEntity(worldIn, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, inventory.getStackInSlot(i));
                float multiplier = 0.1f;
                float motionX = worldIn.f_46441_.nextFloat() - 0.5f;
                float motionY = worldIn.f_46441_.nextFloat() - 0.5f;
                float motionZ = worldIn.f_46441_.nextFloat() - 0.5f;
                item.m_20334_((double)(motionX * multiplier), (double)(motionY * multiplier), (double)(motionZ * multiplier));
                worldIn.m_7967_((Entity)item);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BOOK_AMOUNT});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return BlockFunctionalBookcase.calcRedstoneFromTE(worldIn.m_7702_(pos));
    }

    public static int calcRedstoneFromTE(BlockEntity te) {
        if (!(te instanceof TileEntityFunctionalBookcase)) {
            return 0;
        }
        Optional optInv = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve();
        if (!optInv.isPresent()) {
            return 0;
        }
        IItemHandler inv = (IItemHandler)optInv.get();
        int i = 0;
        for (int j = 0; j < inv.getSlots(); ++j) {
            ItemStack itemstack = inv.getStackInSlot(j);
            if (itemstack.m_41619_()) continue;
            ++i;
        }
        return i;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new TileEntityFunctionalBookcase(blockPos, blockState);
    }
}

