/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.block;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xerca.xercamod.common.SoundEvents;
import xerca.xercamod.common.item.ItemTeapot;
import xerca.xercamod.common.item.Items;

public class BlockTeapot
extends Block {
    public static final IntegerProperty TEA_AMOUNT = IntegerProperty.m_61631_((String)"tea", (int)0, (int)7);
    private static final VoxelShape centerShape = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape topShape = Block.m_49796_((double)7.0, (double)10.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0);
    private static final VoxelShape handleShape = Block.m_49796_((double)7.0, (double)3.0, (double)12.0, (double)9.0, (double)9.0, (double)14.0);
    private static final VoxelShape tipShape = Block.m_49796_((double)7.0, (double)8.0, (double)3.0, (double)9.0, (double)9.0, (double)4.0);
    private static final VoxelShape shape = Shapes.m_83110_((VoxelShape)Shapes.m_83110_((VoxelShape)Shapes.m_83110_((VoxelShape)centerShape, (VoxelShape)topShape), (VoxelShape)handleShape), (VoxelShape)tipShape);

    public BlockTeapot() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76313_).m_60913_(0.0f, 1.0f).m_60918_(SoundType.f_56742_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TEA_AMOUNT, (Comparable)Integer.valueOf(0)));
        this.setRegistryName("block_teapot");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random r) {
        int teaAmount = (Integer)stateIn.m_61143_((Property)TEA_AMOUNT);
        if (teaAmount > 0 && r.nextDouble() * 5.0 < (double)teaAmount * 0.5) {
            for (int i = 0; i < r.nextInt(1) + 1; ++i) {
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.6 + r.nextDouble() * 0.5, (double)pos.m_123343_() + 0.25, 0.0, 0.025, 0.0);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer && player.m_21205_().m_41720_() == Items.ITEM_TEACUP && (Integer)state.m_61143_((Property)TEA_AMOUNT) > 0) {
            worldIn.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.TEA_POUR, SoundSource.PLAYERS, 1.0f, worldIn.f_46441_.nextFloat() * 0.1f + 0.9f);
            player.m_21205_().m_41774_(1);
            player.m_36356_(new ItemStack((ItemLike)Items.ITEM_FULL_TEACUP_0));
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)TEA_AMOUNT, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)TEA_AMOUNT) - 1)));
        }
        return InteractionResult.SUCCESS;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        int teaAmount = (Integer)state.m_61143_((Property)TEA_AMOUNT);
        ItemStack teapotStack = teaAmount == 0 ? new ItemStack((ItemLike)Items.ITEM_TEAPOT) : new ItemStack((ItemLike)this.getItemHotTeapot(teaAmount));
        return Collections.singletonList(teapotStack);
    }

    public boolean m_7898_(BlockState blockState, LevelReader worldReader, BlockPos blockPos) {
        return worldReader.m_8055_(blockPos.m_7495_()).m_60767_().m_76333_();
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor world, BlockPos blockPos, BlockPos blockPos1) {
        return direction == Direction.DOWN && !state.m_60710_((LevelReader)world, blockPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, state1, world, blockPos, blockPos1);
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return shape;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TEA_AMOUNT});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public ItemTeapot getItemHotTeapot(int teaAmount) {
        switch (teaAmount) {
            case 1: {
                return Items.ITEM_HOT_TEAPOT_1;
            }
            case 2: {
                return Items.ITEM_HOT_TEAPOT_2;
            }
            case 3: {
                return Items.ITEM_HOT_TEAPOT_3;
            }
            case 4: {
                return Items.ITEM_HOT_TEAPOT_4;
            }
            case 5: {
                return Items.ITEM_HOT_TEAPOT_5;
            }
            case 6: {
                return Items.ITEM_HOT_TEAPOT_6;
            }
            case 7: {
                return Items.ITEM_HOT_TEAPOT_7;
            }
        }
        return Items.ITEM_HOT_TEAPOT_1;
    }
}

