/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.crafting;

import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeConditionShaped
extends ShapedRecipe {
    private final Supplier<Boolean> condition;
    private RecipeSerializer serializer;

    public RecipeConditionShaped(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn, Supplier<Boolean> condition) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
        this.condition = condition;
    }

    public RecipeConditionShaped(ShapedRecipe shapedRecipe, Supplier<Boolean> condition, RecipeSerializer serializer) {
        super(shapedRecipe.m_6423_(), shapedRecipe.m_6076_(), shapedRecipe.getRecipeWidth(), shapedRecipe.getRecipeHeight(), shapedRecipe.m_7527_(), shapedRecipe.m_8043_());
        this.condition = condition;
        this.serializer = serializer;
    }

    public boolean m_5818_(CraftingContainer inv, Level worldIn) {
        if (!this.condition.get().booleanValue()) {
            return false;
        }
        return super.m_5818_(inv, worldIn);
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        if (!this.condition.get().booleanValue()) {
            return ItemStack.f_41583_;
        }
        return super.m_5874_(inv);
    }

    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }

    public void setSerializer(RecipeSerializer<?> serializer) {
        this.serializer = serializer;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<RecipeConditionShaped> {
        private static final ShapedRecipe.Serializer shapedSerializer = new ShapedRecipe.Serializer();
        private final Supplier<Boolean> condition;

        public Serializer(Supplier<Boolean> condition) {
            this.condition = condition;
        }

        public RecipeConditionShaped fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe shapedRecipe = shapedSerializer.m_6729_(recipeId, json);
            return new RecipeConditionShaped(shapedRecipe, this.condition, this);
        }

        public RecipeConditionShaped fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapedRecipe shapedRecipe = shapedSerializer.m_8005_(recipeId, buffer);
            return new RecipeConditionShaped(shapedRecipe, this.condition, this);
        }

        public void toNetwork(FriendlyByteBuf buffer, RecipeConditionShaped recipe) {
            shapedSerializer.m_6178_(buffer, (ShapedRecipe)recipe);
        }
    }
}

