/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.crafting;

import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeConditionShapeless
extends ShapelessRecipe {
    private final Supplier<Boolean> condition;
    private RecipeSerializer serializer;

    public RecipeConditionShapeless(ResourceLocation idIn, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn, Supplier<Boolean> condition) {
        super(idIn, groupIn, recipeOutputIn, recipeItemsIn);
        this.condition = condition;
    }

    public RecipeConditionShapeless(ShapelessRecipe shapedRecipe, Supplier<Boolean> condition, RecipeSerializer serializer) {
        super(shapedRecipe.m_6423_(), shapedRecipe.m_6076_(), shapedRecipe.m_8043_(), shapedRecipe.m_7527_());
        this.condition = condition;
        this.serializer = serializer;
    }

    public boolean m_5818_(CraftingContainer inv, Level worldIn) {
        if (!this.condition.get().booleanValue()) {
            return false;
        }
        return super.m_5818_(inv, worldIn);
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        if (!this.condition.get().booleanValue()) {
            return ItemStack.f_41583_;
        }
        return super.m_5874_(inv);
    }

    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }

    public void setSerializer(RecipeSerializer<?> serializer) {
        this.serializer = serializer;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<RecipeConditionShapeless> {
        private static final ShapelessRecipe.Serializer shapelessSerializer = new ShapelessRecipe.Serializer();
        private final Supplier<Boolean> condition;

        public Serializer(Supplier<Boolean> condition) {
            this.condition = condition;
        }

        public RecipeConditionShapeless fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapelessRecipe shapelessRecipe = shapelessSerializer.m_6729_(recipeId, json);
            return new RecipeConditionShapeless(shapelessRecipe, this.condition, this);
        }

        public RecipeConditionShapeless fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapelessRecipe shapelessRecipe = shapelessSerializer.m_8005_(recipeId, buffer);
            return new RecipeConditionShapeless(shapelessRecipe, this.condition, this);
        }

        public void toNetwork(FriendlyByteBuf buffer, RecipeConditionShapeless recipe) {
            shapelessSerializer.m_6178_(buffer, (ShapelessRecipe)recipe);
        }
    }
}

