/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.crafting;

import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeConditionSmelting
extends SmeltingRecipe {
    private final Supplier<Boolean> condition;
    private RecipeSerializer serializer;

    public RecipeConditionSmelting(ResourceLocation idIn, String groupIn, Ingredient ingredientIn, ItemStack resultIn, float experienceIn, int cookTimeIn, Supplier<Boolean> condition) {
        super(idIn, groupIn, ingredientIn, resultIn, experienceIn, cookTimeIn);
        this.condition = condition;
    }

    public RecipeConditionSmelting(SmeltingRecipe furnaceRecipe, Supplier<Boolean> condition, RecipeSerializer serializer) {
        super(furnaceRecipe.m_6423_(), furnaceRecipe.m_6076_(), (Ingredient)furnaceRecipe.m_7527_().get(0), furnaceRecipe.m_8043_(), furnaceRecipe.m_43750_(), furnaceRecipe.m_43753_());
        this.condition = condition;
        this.serializer = serializer;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        if (!this.condition.get().booleanValue()) {
            return false;
        }
        return super.m_5818_(inv, worldIn);
    }

    public ItemStack m_5874_(Container inv) {
        if (!this.condition.get().booleanValue()) {
            return ItemStack.f_41583_;
        }
        return super.m_5874_(inv);
    }

    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }

    public void setSerializer(RecipeSerializer<?> serializer) {
        this.serializer = serializer;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<RecipeConditionSmelting> {
        private static final SimpleCookingSerializer<SmeltingRecipe> furnaceSerializer = RecipeSerializer.f_44091_;
        private final Supplier<Boolean> condition;

        public Serializer(Supplier<Boolean> condition) {
            this.condition = condition;
        }

        public RecipeConditionSmelting fromJson(ResourceLocation recipeId, JsonObject json) {
            SmeltingRecipe furnaceRecipe = (SmeltingRecipe)furnaceSerializer.m_6729_(recipeId, json);
            return new RecipeConditionSmelting(furnaceRecipe, this.condition, this);
        }

        public RecipeConditionSmelting fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            SmeltingRecipe furnaceRecipe = (SmeltingRecipe)furnaceSerializer.m_8005_(recipeId, buffer);
            return new RecipeConditionSmelting(furnaceRecipe, this.condition, this);
        }

        public void toNetwork(FriendlyByteBuf buffer, RecipeConditionSmelting recipe) {
            furnaceSerializer.m_6178_(buffer, (AbstractCookingRecipe)recipe);
        }
    }
}

