/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.crafting;

import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.item.ItemFlask;

public class RecipeFlaskFilling
extends CustomRecipe {
    public RecipeFlaskFilling(ResourceLocation resourceLocation) {
        super(resourceLocation);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        if (!Config.isEnderFlaskEnabled()) {
            return false;
        }
        int i = 0;
        Potion potionType = Potions.f_43598_;
        ItemStack flaskStack = ItemStack.f_41583_;
        Potion currentFlaskPotion = Potions.f_43598_;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            if (itemstack.m_41720_() == xerca.xercamod.common.item.Items.FLASK) {
                if (!flaskStack.m_41619_()) {
                    return false;
                }
                flaskStack = itemstack;
                currentFlaskPotion = PotionUtils.m_43579_((ItemStack)flaskStack);
                if (potionType == Potions.f_43598_ || currentFlaskPotion.equals(Potions.f_43598_) || currentFlaskPotion.equals(potionType)) continue;
                return false;
            }
            if (!(itemstack.m_41720_() instanceof PotionItem)) {
                return false;
            }
            if (potionType.equals(Potions.f_43598_)) {
                potionType = PotionUtils.m_43579_((ItemStack)itemstack);
            } else if (!PotionUtils.m_43579_((ItemStack)itemstack).equals(potionType)) {
                return false;
            }
            if (!currentFlaskPotion.equals(Potions.f_43598_) && !currentFlaskPotion.equals(potionType)) {
                return false;
            }
            ++i;
        }
        return !flaskStack.m_41619_() && i > 0 && !potionType.equals(Potions.f_43598_) && ItemFlask.getCharges(flaskStack) + i <= ItemFlask.getMaxCharges(flaskStack);
    }

    public ItemStack assemble(CraftingContainer inv) {
        if (!Config.isEnderFlaskEnabled()) {
            return ItemStack.f_41583_;
        }
        int i = 0;
        Potion potionType = Potions.f_43598_;
        ItemStack flaskStack = ItemStack.f_41583_;
        Potion currentFlaskPotion = Potions.f_43598_;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            if (itemstack.m_41720_() == xerca.xercamod.common.item.Items.FLASK) {
                if (!flaskStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                flaskStack = itemstack;
                currentFlaskPotion = PotionUtils.m_43579_((ItemStack)flaskStack);
                if (potionType == Potions.f_43598_ || currentFlaskPotion.equals(Potions.f_43598_) || currentFlaskPotion.equals(potionType)) continue;
                return ItemStack.f_41583_;
            }
            if (!(itemstack.m_41720_() instanceof PotionItem)) {
                return ItemStack.f_41583_;
            }
            if (potionType.equals(Potions.f_43598_)) {
                potionType = PotionUtils.m_43579_((ItemStack)itemstack);
            } else if (!PotionUtils.m_43579_((ItemStack)itemstack).equals(potionType)) {
                return ItemStack.f_41583_;
            }
            if (!currentFlaskPotion.equals(Potions.f_43598_) && !currentFlaskPotion.equals(potionType)) {
                return ItemStack.f_41583_;
            }
            ++i;
        }
        int oldCharges = ItemFlask.getCharges(flaskStack);
        if (!flaskStack.m_41619_() && i > 0 && !potionType.equals(Potions.f_43598_) && oldCharges + i <= ItemFlask.getMaxCharges(flaskStack)) {
            ItemStack resultStack = new ItemStack((ItemLike)xerca.xercamod.common.item.Items.FLASK);
            resultStack.m_41751_(flaskStack.m_41784_().m_6426_());
            PotionUtils.m_43549_((ItemStack)resultStack, (Potion)potionType);
            ItemFlask.setCharges(resultStack, oldCharges + i);
            return resultStack;
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            if (itemstack.hasContainerItem()) {
                nonnulllist.set(i, (Object)itemstack.getContainerItem());
                continue;
            }
            if (!(itemstack.m_41720_() instanceof PotionItem)) continue;
            ItemStack bottle = new ItemStack((ItemLike)Items.f_42590_);
            nonnulllist.set(i, (Object)bottle);
        }
        return nonnulllist;
    }

    public RecipeSerializer<?> m_7707_() {
        return xerca.xercamod.common.item.Items.CRAFTING_SPECIAL_FLASK_FILLING;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 3 && height >= 3;
    }
}

