/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.crafting;

import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.item.ItemTeapot;
import xerca.xercamod.common.item.Items;

public class RecipeTeaPouring
extends CustomRecipe {
    public RecipeTeaPouring(ResourceLocation p_i48170_1_) {
        super(p_i48170_1_);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        if (!Config.isTeaEnabled()) {
            return false;
        }
        int i = 0;
        ItemStack teapotStack = ItemStack.f_41583_;
        ItemTeapot teapot = null;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            if (itemstack.m_41720_() instanceof ItemTeapot) {
                if (!teapotStack.m_41619_()) {
                    return false;
                }
                teapotStack = itemstack;
                teapot = (ItemTeapot)itemstack.m_41720_();
                if (teapot.isHot()) continue;
                return false;
            }
            if (itemstack.m_41720_() != Items.ITEM_TEACUP || i > 6) {
                return false;
            }
            ++i;
        }
        return !teapotStack.m_41619_() && teapot != null && i > 0 && teapot.isHot() && teapot.getTeaAmount() - i >= 0;
    }

    public ItemStack assemble(CraftingContainer inv) {
        if (!Config.isTeaEnabled()) {
            return ItemStack.f_41583_;
        }
        int i = 0;
        ItemStack teapotStack = ItemStack.f_41583_;
        ItemTeapot teapot = null;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            if (itemstack.m_41720_() instanceof ItemTeapot) {
                if (!teapotStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                teapotStack = itemstack;
                teapot = (ItemTeapot)itemstack.m_41720_();
                if (teapot.isHot()) continue;
                return ItemStack.f_41583_;
            }
            if (itemstack.m_41720_() != Items.ITEM_TEACUP || i > 6) {
                return ItemStack.f_41583_;
            }
            ++i;
        }
        if (!teapotStack.m_41619_() && i >= 1 && teapot != null && teapot.getTeaAmount() - i >= 0) {
            return new ItemStack((ItemLike)Items.ITEM_FULL_TEACUP_0, i);
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        ItemStack itemstack;
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        int teacupCount = 0;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_() || itemstack.m_41720_() != Items.ITEM_TEACUP || teacupCount > 6) continue;
            ++teacupCount;
        }
        for (int i = 0; i < nonnulllist.size(); ++i) {
            itemstack = inv.m_8020_(i);
            if (itemstack.hasContainerItem()) {
                nonnulllist.set(i, (Object)itemstack.getContainerItem());
                continue;
            }
            if (!(itemstack.m_41720_() instanceof ItemTeapot)) continue;
            ItemTeapot oldTeapot = (ItemTeapot)itemstack.m_41720_();
            if (oldTeapot.getTeaAmount() > teacupCount) {
                Object str = oldTeapot.getRegistryName().toString();
                ItemStack remainingStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)(str = ((String)str).substring(0, ((String)str).length() - 1) + (oldTeapot.getTeaAmount() - teacupCount)))));
                if (remainingStack.m_41619_()) break;
                nonnulllist.set(i, (Object)remainingStack);
                break;
            }
            nonnulllist.set(i, (Object)new ItemStack((ItemLike)Items.ITEM_TEAPOT));
            break;
        }
        return nonnulllist;
    }

    public RecipeSerializer<?> m_7707_() {
        return Items.CRAFTING_SPECIAL_TEA_POURING;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 3 && height >= 3;
    }
}

