/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.entity;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fmllegacy.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fmllegacy.network.FMLPlayMessages;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import xerca.xercamod.common.block.BlockCushion;
import xerca.xercamod.common.entity.Entities;
import xerca.xercamod.common.item.ItemCushion;

public class EntityCushion
extends Entity
implements IEntityAdditionalSpawnData {
    private ItemCushion item;
    public BlockCushion block;
    private int cushionIndex;
    static BlockCushion[] blockCushions;
    static ItemCushion[] itemCushions;

    public EntityCushion(EntityType<? extends EntityCushion> type, Level world) {
        super(type, world);
    }

    public EntityCushion(Level worldIn) {
        super(Entities.CUSHION, worldIn);
        this.m_20242_(false);
    }

    public EntityCushion(Level worldIn, double x, double y, double z, ItemCushion item) {
        this(worldIn);
        this.m_6034_(x, y, z);
        this.item = item;
        this.block = item.getBlock();
        this.cushionIndex = this.block.cushionIndex;
    }

    public EntityCushion(FMLPlayMessages.SpawnEntity spawnEntity, Level world) {
        this(world);
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_6478_(MoverType.SELF, new Vec3(0.0, -0.16, 0.0));
        this.m_20011_(new AABB(this.m_20185_() - 0.5, this.m_20186_(), this.m_20189_() - 0.5, this.m_20185_() + 0.5, this.m_20186_() + (double)this.m_20206_(), this.m_20189_() + 0.5));
    }

    public boolean m_7313_(Entity entityIn) {
        return entityIn instanceof Player && this.m_6469_(DamageSource.m_19344_((Player)((Player)entityIn)), 0.0f);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.m_146910_() && !this.f_19853_.f_46443_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            this.m_5834_();
            this.onBroken(source.m_7639_());
        }
        return true;
    }

    public void onBroken(@Nullable Entity brokenEntity) {
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_5496_(SoundEvents.f_12639_, 1.0f, 1.0f);
            if (brokenEntity instanceof Player) {
                Player entityplayer = (Player)brokenEntity;
                if (entityplayer.m_150110_().f_35937_) {
                    return;
                }
            }
            this.m_19998_((ItemLike)this.item);
        }
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_7378_(CompoundTag compound) {
        this.cushionIndex = compound.m_128451_("cushion");
        this.block = blockCushions[this.cushionIndex];
        this.item = itemCushions[this.cushionIndex];
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("cushion", this.cushionIndex);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.cushionIndex);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.cushionIndex = buffer.readInt();
        this.block = blockCushions[this.cushionIndex];
        this.item = itemCushions[this.cushionIndex];
    }

    public double m_6048_() {
        return -0.125;
    }

    public boolean m_6087_() {
        return true;
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (!this.f_19853_.f_46443_) {
            player.m_20329_((Entity)this);
        }
        return InteractionResult.SUCCESS;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_20161_()) {
            return InteractionResult.PASS;
        }
        if (!this.f_19853_.f_46443_ && !this.m_20160_()) {
            player.m_20329_((Entity)this);
        }
        return InteractionResult.SUCCESS;
    }
}

