/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fmllegacy.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fmllegacy.network.FMLPlayMessages;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import xerca.xercamod.common.HookReturningEvent;
import xerca.xercamod.common.SoundEvents;
import xerca.xercamod.common.entity.Entities;
import xerca.xercamod.common.item.Items;

public class EntityHook
extends Entity
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Integer> cau_ent = SynchedEntityData.m_135353_(EntityHook.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final double DEFAULT_SPEED = 1.5;
    private int xTile;
    private int yTile;
    private int zTile;
    private int age = 0;
    private boolean inGround;
    private Player angler;
    private int ticksInAir;
    public Entity caughtEntity;
    public boolean isReturning;
    public boolean hasGrappling = false;
    public int turboLevel = 0;
    public boolean hasGentle = false;
    private double speed;
    private ItemStack rod = ItemStack.f_41583_;

    public EntityHook(EntityType<? extends EntityHook> type, Level world) {
        super(type, world);
    }

    public EntityHook(Level worldIn) {
        super(Entities.HOOK, worldIn);
        this.xTile = -1;
        this.yTile = -1;
        this.zTile = -1;
        this.f_19811_ = true;
        this.isReturning = false;
    }

    public EntityHook(Level worldIn, Player hooker, ItemStack rod, float pullAmount) {
        this(worldIn);
        this.isReturning = false;
        this.angler = hooker;
        if (rod.m_41720_() == Items.ITEM_GRAB_HOOK) {
            this.rod = rod;
            this.rod.m_41784_().m_128379_("cast", true);
            this.hasGrappling = EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_GRAPPLING, (ItemStack)this.rod) > 0;
            this.hasGentle = EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_GENTLE_GRAB, (ItemStack)this.rod) > 0;
            this.turboLevel = EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_TURBO_GRAB, (ItemStack)this.rod);
        }
        double speedMultiplier = (double)this.turboLevel * 0.25 + 1.0;
        this.speed = 1.5 * speedMultiplier * (double)pullAmount;
        float pitch = this.angler.m_146909_();
        float yaw = this.angler.m_146908_();
        float f2 = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-pitch * ((float)Math.PI / 180)));
        double x = this.angler.m_20185_();
        double y = this.angler.m_20186_() + (double)this.angler.m_20192_();
        double z = this.angler.m_20189_();
        this.m_7678_(x, y, z, yaw, pitch);
        Vec3 vec3d = new Vec3((double)(-f3), (double)(-(f5 / f4)), (double)(-f2));
        double length = vec3d.m_82553_();
        vec3d = vec3d.m_82490_(this.speed / length);
        this.m_20256_(vec3d);
        this.m_146922_((float)(Mth.m_14136_((double)vec3d.f_82479_, (double)vec3d.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3d.f_82480_, (double)Mth.m_14116_((float)((float)this.m_20238_(vec3d)))) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public EntityHook(FMLPlayMessages.SpawnEntity spawnEntity, Level world) {
        this(world);
    }

    public Player getAngler() {
        return this.angler;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        int i;
        if (cau_ent.equals(key) && (i = ((Integer)this.m_20088_().m_135370_(cau_ent)).intValue()) > 0 && this.caughtEntity != null) {
            this.caughtEntity = null;
        }
        super.m_7350_(key);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double d0 = this.m_142469_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    private boolean checkCollision() {
        HitResult raytraceresult = ProjectileUtil.m_37294_((Entity)this, entity -> !(entity.m_5833_() || !entity.m_6087_() && !(entity instanceof ItemEntity) || entity == this.angler && this.ticksInAir < 5));
        if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
            if (raytraceresult.m_6662_() == HitResult.Type.ENTITY) {
                Entity caught = ((EntityHitResult)raytraceresult).m_82443_();
                if (!(caught instanceof LivingEntity) || caught.equals((Object)this.angler)) {
                    return false;
                }
                this.caughtEntity = caught;
                this.m_20088_().m_135381_(cau_ent, (Object)(this.caughtEntity.m_142049_() + 1));
                this.caughtEntity = caught;
                if (!this.hasGentle) {
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.HOOK_IMPACT, SoundSource.PLAYERS, 1.0f, this.f_19853_.f_46441_.nextFloat() * 0.2f + 0.9f);
                    this.caughtEntity.m_6469_(DamageSource.m_19361_((Entity)this, (Entity)this.angler), 3.0f);
                    if (!this.caughtEntity.m_6084_()) {
                        this.remove();
                        return true;
                    }
                } else {
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.HOOK_IMPACT, SoundSource.PLAYERS, 0.6f, this.f_19853_.f_46441_.nextFloat() * 0.2f + 1.5f);
                }
                this.caughtEntity.f_19794_ = true;
                this.caughtEntity.m_8127_();
                return true;
            }
            if (raytraceresult.m_6662_() == HitResult.Type.BLOCK) {
                this.inGround = true;
                if (this.hasGrappling) {
                    this.m_20334_(0.0, 0.0, 0.0);
                    this.angler.f_19794_ = true;
                    this.angler.m_8127_();
                }
                return true;
            }
        }
        return false;
    }

    private void pullEntity() {
        if (this.caughtEntity.m_6084_()) {
            Vec3 v2;
            Vec3 v1 = this.angler.m_20182_();
            Vec3 v = v1.m_82546_(v2 = this.caughtEntity.m_20182_());
            if (!(v.m_82553_() > 2.0)) {
                this.remove();
                return;
            }
            v = v.m_82541_().m_82490_(this.speed);
            this.caughtEntity.m_20256_(v);
            this.caughtEntity.f_19864_ = true;
            this.caughtEntity.f_19812_ = true;
            double height = (double)this.caughtEntity.m_20206_() + 0.5;
            this.m_6034_(this.caughtEntity.m_20185_(), this.caughtEntity.m_142469_().f_82289_ + height * 0.8, this.caughtEntity.m_20189_());
            return;
        }
        this.caughtEntity = null;
    }

    private void pullUser() {
        Vec3 v1 = this.angler.m_20182_();
        Vec3 v2 = this.m_20182_();
        Vec3 v = v2.m_82546_(v1);
        if (v.m_82553_() > 2.0) {
            v = v.m_82541_().m_82490_(this.speed);
            this.angler.m_20256_(v);
            this.angler.f_19794_ = true;
            this.angler.f_19812_ = true;
            this.angler.f_19864_ = true;
        } else {
            this.remove();
        }
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(cau_ent, (Object)0);
    }

    public void m_8119_() {
        if (!this.f_19853_.f_46443_) {
            if (this.angler == null) {
                this.remove();
                return;
            }
            this.m_20115_(6, this.m_142038_());
        }
        this.m_6075_();
        ++this.age;
        if (this.f_19853_.f_46443_) {
            int i = (Integer)this.m_20088_().m_135370_(cau_ent);
            if (i > 0 && this.caughtEntity == null) {
                this.caughtEntity = this.f_19853_.m_6815_(i - 1);
                MinecraftForge.EVENT_BUS.post((Event)new HookReturningEvent(this));
            }
        } else {
            ItemStack itemstack = this.angler.m_21205_();
            if (this.age > 80 || !this.angler.m_6084_() || itemstack.m_41720_() != Items.ITEM_GRAB_HOOK || this.m_20280_((Entity)this.angler) > 4096.0) {
                this.remove();
                this.angler.f_36083_ = null;
                return;
            }
        }
        if (this.caughtEntity != null && this.angler != null) {
            this.pullEntity();
            return;
        }
        if (this.inGround) {
            if (this.hasGrappling && this.angler != null) {
                this.pullUser();
            } else {
                this.remove();
            }
            return;
        }
        ++this.ticksInAir;
        if (this.ticksInAir == 20) {
            this.setReturning();
        }
        if (!this.f_19853_.f_46443_) {
            boolean caughtSomething = this.checkCollision();
            if (caughtSomething) {
                return;
            }
            if (this.isReturning) {
                Vec3 target = this.angler.m_20182_().m_82520_(0.0, (double)this.angler.m_20192_(), 0.0);
                Vec3 v = target.m_82546_(this.m_20182_());
                if (v.m_82553_() < 3.0) {
                    this.remove();
                    return;
                }
                v = v.m_82541_().m_82490_(this.speed).m_82492_(0.0, 0.1, 0.0);
                this.m_20256_(v);
            }
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    private void setReturning() {
        this.isReturning = true;
        MinecraftForge.EVENT_BUS.post((Event)new HookReturningEvent(this));
    }

    public void m_7380_(CompoundTag tagCompound) {
        tagCompound.m_128405_("xTile", this.xTile);
        tagCompound.m_128405_("yTile", this.yTile);
        tagCompound.m_128405_("zTile", this.zTile);
        tagCompound.m_128344_("inGround", (byte)(this.inGround ? 1 : 0));
    }

    public void m_7378_(CompoundTag tagCompund) {
        this.xTile = tagCompund.m_128451_("xTile");
        this.yTile = tagCompund.m_128451_("yTile");
        this.zTile = tagCompund.m_128451_("zTile");
        this.inGround = tagCompund.m_128445_("inGround") == 1;
    }

    public void remove() {
        super.m_142687_(Entity.RemovalReason.DISCARDED);
        if (this.caughtEntity != null) {
            this.caughtEntity.f_19794_ = false;
        }
        if (this.angler != null) {
            this.angler.f_36083_ = null;
            this.angler.f_19794_ = false;
        }
        if (this.rod.m_41720_() == Items.ITEM_GRAB_HOOK) {
            this.rod.m_41784_().m_128379_("cast", false);
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.angler != null ? this.angler.m_142049_() : -1);
        buffer.writeDouble(this.speed);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        int id = additionalData.readInt();
        Entity ent = this.f_19853_.m_6815_(id);
        if (ent instanceof Player) {
            this.angler = (Player)ent;
        }
        this.speed = additionalData.readDouble();
    }
}

