/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.item.Items;

public class ItemEnderBow
extends Item {
    public ItemEnderBow() {
        super(new Item.Properties().m_41491_(CreativeModeTab.f_40758_).m_41487_(1).m_41503_(160));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (ItemEnderBow.getCharges(stack) > 0) {
            float range = EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_RANGE, (ItemStack)stack) + 1;
            if (range > 1.0f) {
                range *= 0.8f;
            }
            worldIn.m_6263_(playerIn, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!worldIn.f_46443_) {
                ThrownPotion potionentity = new ThrownPotion(worldIn, (LivingEntity)playerIn);
                ItemStack potionStack = new ItemStack((ItemLike)(ItemEnderBow.isLingering(stack) ? net.minecraft.world.item.Items.f_42739_ : net.minecraft.world.item.Items.f_42736_));
                PotionUtils.m_43549_((ItemStack)potionStack, (Potion)PotionUtils.m_43579_((ItemStack)stack));
                potionentity.m_37446_(potionStack);
                potionentity.m_37251_((Entity)playerIn, playerIn.m_146909_(), playerIn.m_146908_(), -10.0f, 0.5f * range, 1.0f / range);
                worldIn.m_7967_((Entity)potionentity);
                this.decrementCharges(stack);
                stack.m_41622_(1, (LivingEntity)playerIn, playerEntity -> playerEntity.m_21190_(handIn));
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    public static boolean isLingering(ItemStack itemstack) {
        CompoundTag tag;
        if (itemstack.m_41782_() && (tag = itemstack.m_41783_()).m_128441_("isLinger")) {
            return tag.m_128471_("isLinger");
        }
        return false;
    }

    public static int getCharges(ItemStack itemstack) {
        CompoundTag tag;
        if (itemstack.m_41782_() && (tag = itemstack.m_41783_()).m_128441_("charges")) {
            return tag.m_128451_("charges");
        }
        return 0;
    }

    private boolean decrementCharges(ItemStack itemstack) {
        int oldCharges;
        CompoundTag tag = itemstack.m_41784_();
        if (tag.m_128441_("charges") && (oldCharges = tag.m_128451_("charges")) > 0) {
            if (oldCharges == 1) {
                tag.m_128473_("Potion");
            }
            tag.m_128405_("charges", oldCharges - 1);
            return true;
        }
        return false;
    }

    public String m_5671_(ItemStack stack) {
        return PotionUtils.m_43579_((ItemStack)stack).m_43492_(this.m_5524_() + ".effect.");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        TranslatableComponent text = new TranslatableComponent("xercamod.ender_bow_tooltip");
        tooltip.add((Component)text.m_130940_(ChatFormatting.BLUE));
        PotionUtils.m_43555_((ItemStack)stack, tooltip, (float)1.0f);
        tooltip.add((Component)new TextComponent(ItemEnderBow.getCharges(stack) + " charges").m_130940_(ChatFormatting.YELLOW));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return super.m_5812_(stack);
    }

    @ParametersAreNonnullByDefault
    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!Config.isEnderFlaskEnabled()) {
            return;
        }
        super.m_6787_(group, items);
    }

    public int m_6473_() {
        return 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment ench) {
        return ench.f_44672_ == EnchantmentCategory.BREAKABLE || ench == Items.ENCHANTMENT_RANGE || ench == Items.ENCHANTMENT_CAPACITY;
    }
}

