/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.item.Items;

public class ItemFlask
extends Item {
    private static final int baseMaxCharges = 16;
    private boolean hasMilk;

    public ItemFlask(Item.Properties properties, String registryName, boolean hasMilk) {
        super(properties);
        this.setRegistryName(registryName);
        this.hasMilk = hasMilk;
    }

    public int m_8105_(ItemStack stack) {
        int chug = EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_CHUG, (ItemStack)stack);
        switch (chug) {
            case 2: {
                return 10;
            }
            case 1: {
                return 21;
            }
        }
        return 32;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (ItemFlask.getCharges(itemstack) > 0) {
            playerIn.m_6672_(handIn);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
    }

    public ItemStack m_5922_(@Nonnull ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        int charges = ItemFlask.getCharges(stack);
        if (charges > 0 && entityLiving instanceof Player) {
            Player entityplayer = (Player)entityLiving;
            if (!worldIn.f_46443_) {
                if (this.hasMilk) {
                    entityplayer.curePotionEffects(new ItemStack((ItemLike)net.minecraft.world.item.Items.f_42455_));
                } else {
                    for (MobEffectInstance potioneffect : PotionUtils.m_43547_((ItemStack)stack)) {
                        if (potioneffect.m_19544_().m_8093_()) {
                            potioneffect.m_19544_().m_19461_((Entity)entityplayer, (Entity)entityplayer, entityLiving, potioneffect.m_19564_(), 1.0);
                            continue;
                        }
                        entityLiving.m_7292_(new MobEffectInstance(potioneffect));
                    }
                }
            }
            this.decrementCharges(stack);
            stack.m_41622_(1, (LivingEntity)entityplayer, playerEntity -> playerEntity.m_21190_(playerEntity.m_7655_()));
        }
        if (this.hasMilk && ItemFlask.getCharges(stack) <= 0) {
            CompoundTag tag = stack.m_41783_();
            stack = new ItemStack((ItemLike)Items.FLASK);
            stack.m_41751_(tag);
        }
        return stack;
    }

    public static int getCharges(ItemStack itemstack) {
        CompoundTag tag;
        if (itemstack.m_41782_() && (tag = itemstack.m_41783_()).m_128441_("charges")) {
            return tag.m_128451_("charges");
        }
        return 0;
    }

    public static int getMaxCharges(ItemStack itemstack) {
        int cap = EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_CAPACITY, (ItemStack)itemstack);
        return 16 * (cap + 1);
    }

    public static void setCharges(ItemStack itemstack, int charges) {
        if (charges >= 0 && charges <= ItemFlask.getMaxCharges(itemstack)) {
            CompoundTag tag = itemstack.m_41784_();
            tag.m_128405_("charges", charges);
        }
    }

    private boolean decrementCharges(ItemStack itemstack) {
        int oldCharges;
        CompoundTag tag = itemstack.m_41784_();
        if (tag.m_128441_("charges") && (oldCharges = tag.m_128451_("charges")) > 0) {
            if (oldCharges == 1) {
                tag.m_128473_("Potion");
            }
            tag.m_128405_("charges", oldCharges - 1);
            return true;
        }
        return false;
    }

    public String m_5671_(ItemStack stack) {
        if (this.hasMilk) {
            return this.m_5524_();
        }
        return PotionUtils.m_43579_((ItemStack)stack).m_43492_(this.m_5524_() + ".effect.");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        TranslatableComponent text = new TranslatableComponent("xercamod.ender_flask_tooltip");
        tooltip.add((Component)text.m_130940_(ChatFormatting.BLUE));
        if (this.hasMilk) {
            tooltip.add((Component)new TextComponent("Calcium for your bones").m_130940_(ChatFormatting.YELLOW));
        } else {
            PotionUtils.m_43555_((ItemStack)stack, tooltip, (float)1.0f);
        }
        tooltip.add((Component)new TextComponent(ItemFlask.getCharges(stack) + " charges").m_130940_(ChatFormatting.YELLOW));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return super.m_5812_(stack);
    }

    @ParametersAreNonnullByDefault
    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!Config.isEnderFlaskEnabled()) {
            return;
        }
        super.m_6787_(group, items);
    }

    public int m_6473_() {
        return 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment ench) {
        return ench.f_44672_ == EnchantmentCategory.BREAKABLE || ench == Items.ENCHANTMENT_CAPACITY || ench == Items.ENCHANTMENT_CHUG;
    }
}

