/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.entity.EntityHook;
import xerca.xercamod.common.item.Items;

public class ItemGrabHook
extends FishingRodItem {
    public ItemGrabHook() {
        super(new Item.Properties().m_41491_(CreativeModeTab.f_40757_).m_41499_(210));
        this.setRegistryName("item_grab_hook");
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand hand) {
        ItemStack heldItem = playerIn.m_21120_(hand);
        playerIn.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldItem);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        float useSeconds = (float)(this.m_8105_(stack) - timeLeft) / 20.0f;
        if (useSeconds > 1.0f) {
            useSeconds = 1.0f;
        }
        if (useSeconds > 0.1f && entityLiving instanceof Player) {
            InteractionHand hand;
            Player playerIn = (Player)entityLiving;
            if (playerIn.m_21205_().m_41720_() instanceof ItemGrabHook) {
                hand = InteractionHand.MAIN_HAND;
            } else if (playerIn.m_21206_().m_41720_() instanceof ItemGrabHook) {
                hand = InteractionHand.OFF_HAND;
            } else {
                return;
            }
            ItemStack heldItem = playerIn.m_21120_(hand);
            playerIn.m_36335_().m_41524_((Item)this, 40);
            heldItem.m_41622_(1, (LivingEntity)playerIn, p -> p.m_21190_(hand));
            if (!worldIn.f_46443_) {
                worldIn.m_7967_((Entity)new EntityHook(worldIn, playerIn, heldItem, useSeconds));
            }
            playerIn.m_6674_(hand);
        }
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ == EnchantmentCategory.BREAKABLE || enchantment == Items.ENCHANTMENT_GRAPPLING;
    }

    @ParametersAreNonnullByDefault
    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!Config.isGrabHookEnabled()) {
            return;
        }
        super.m_6787_(group, items);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        TranslatableComponent text = new TranslatableComponent("xercamod.grap_hook_tooltip");
        tooltip.add((Component)text.m_130940_(ChatFormatting.BLUE));
        if (EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_GRAPPLING, (ItemStack)stack) > 0) {
            TranslatableComponent textGrappling = new TranslatableComponent("xercamod.grappling_tooltip");
            tooltip.add((Component)textGrappling.m_130940_(ChatFormatting.YELLOW));
        }
    }
}

