/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import xerca.xercamod.common.SoundEvents;
import xerca.xercamod.common.Triggers;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.KnifeAttackPacket;

public class ItemKnife
extends Item {
    private static final float defaultBonus = 8.0f;
    private static final float weaponDamage = 2.0f;
    private static final int maxDamage = 240;
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    ItemKnife() {
        super(new Item.Properties().m_41491_(CreativeModeTab.f_40756_).m_41487_(1).m_41499_(240));
        this.setRegistryName("item_knife");
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 2.0, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int poison;
        float damage = 0.0f;
        if (attacker.m_20161_() && Mth.m_14154_((float)(Mth.m_14177_((float)target.m_146908_()) - Mth.m_14177_((float)attacker.m_146908_()))) < 65.0f) {
            if (!target.f_19853_.f_46443_) {
                ClientboundAnimatePacket packetOut = new ClientboundAnimatePacket((Entity)target, 4);
                ((ServerLevel)target.f_19853_).m_7726_().m_8394_((Entity)attacker, (Packet)packetOut);
            }
            attacker.f_19853_.m_6263_(null, target.m_20185_(), target.m_20186_() + 0.5, target.m_20189_(), SoundEvents.SNEAK_HIT, SoundSource.PLAYERS, 1.0f, attacker.f_19853_.f_46441_.nextFloat() * 0.2f + 0.8f);
            float bonus = 8.0f;
            if (stack.m_41793_()) {
                bonus += (float)(EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_STEALTH, (ItemStack)stack) * 2);
            }
            Player player = (Player)attacker;
            DamageSource damagesource = DamageSource.m_19344_((Player)player);
            target.m_6469_(damagesource, damage += bonus);
            if (target.m_21223_() <= 0.0f) {
                Triggers.ASSASSINATE.trigger((ServerPlayer)player);
            }
        }
        stack.m_41622_(1, attacker, p -> p.m_21190_(InteractionHand.MAIN_HAND));
        if (stack.m_41793_() && (poison = EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_POISON, (ItemStack)stack)) > 0) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 30 + 30 * poison, poison - 1));
        }
        return true;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand hand) {
        ItemStack heldItem = playerIn.m_21120_(hand);
        if (hand == InteractionHand.OFF_HAND) {
            playerIn.m_6674_(hand);
            if (worldIn.f_46443_) {
                Minecraft mine = Minecraft.m_91087_();
                if (mine.f_91077_ != null && mine.f_91077_.m_6662_() == HitResult.Type.ENTITY) {
                    Entity target = ((EntityHitResult)mine.f_91077_).m_82443_();
                    KnifeAttackPacket pack = new KnifeAttackPacket(false, target.m_142049_());
                    XercaMod.NETWORK_HANDLER.sendToServer((Object)pack);
                }
            }
            playerIn.m_36335_().m_41524_((Item)this, 15);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldItem);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)heldItem);
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlot slot, ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND ? this.attributeModifiers : super.m_7167_(slot);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.m_41720_() == this;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        ItemStack ret = new ItemStack((ItemLike)this);
        ret.m_41751_(itemStack.m_41783_());
        ret.m_41721_(itemStack.m_41773_() + 1);
        if (ret.m_41773_() >= ret.m_41776_()) {
            return ItemStack.f_41583_;
        }
        return ret;
    }

    public int m_6473_() {
        return Tiers.IRON.m_6601_();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ == EnchantmentCategory.BREAKABLE || enchantment == Items.ENCHANTMENT_POISON || enchantment == Items.ENCHANTMENT_STEALTH || enchantment == Enchantments.f_44977_ || enchantment == Enchantments.f_44982_;
    }
}

