/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.item;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.ScytheAttackPacket;

@ParametersAreNonnullByDefault
public class ItemScythe
extends DiggerItem {
    private static final Tag<Block> EFFECTIVE_ON = Tag.m_13300_((Set)ImmutableSet.of());

    public ItemScythe(Tier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super((float)attackDamageIn, attackSpeedIn, tier, EFFECTIVE_ON, builder.addToolType(ToolType.PICKAXE, tier.m_6604_()));
    }

    public float m_8102_(ItemStack stack, BlockState blockState) {
        if (blockState.m_60734_() instanceof CropBlock) {
            if (((CropBlock)blockState.m_60734_()).m_52307_(blockState)) {
                return 1.0f;
            }
            return 0.0f;
        }
        return 1.0f;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        int sweeping = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44983_, (ItemStack)itemstack);
        if (sweeping > 0) {
            Level world = player.f_19853_;
            BlockState southBS = world.m_8055_(pos.m_142128_());
            BlockState northBS = world.m_8055_(pos.m_142127_());
            BlockState westBS = world.m_8055_(pos.m_142125_());
            BlockState eastBS = world.m_8055_(pos.m_142126_());
            if (this.isMaxCrop(southBS)) {
                this.breakBlock(pos.m_142128_(), world, player);
            }
            if (this.isMaxCrop(northBS)) {
                this.breakBlock(pos.m_142127_(), world, player);
            }
            if (this.isMaxCrop(westBS)) {
                this.breakBlock(pos.m_142125_(), world, player);
            }
            if (this.isMaxCrop(eastBS)) {
                this.breakBlock(pos.m_142126_(), world, player);
            }
            if (sweeping > 1) {
                BlockState seBS = world.m_8055_(pos.m_142128_().m_142126_());
                BlockState swBS = world.m_8055_(pos.m_142128_().m_142125_());
                BlockState neBS = world.m_8055_(pos.m_142127_().m_142125_());
                BlockState nwBS = world.m_8055_(pos.m_142127_().m_142126_());
                if (this.isMaxCrop(seBS)) {
                    this.breakBlock(pos.m_142128_().m_142126_(), world, player);
                }
                if (this.isMaxCrop(swBS)) {
                    this.breakBlock(pos.m_142128_().m_142125_(), world, player);
                }
                if (this.isMaxCrop(neBS)) {
                    this.breakBlock(pos.m_142127_().m_142125_(), world, player);
                }
                if (this.isMaxCrop(nwBS)) {
                    this.breakBlock(pos.m_142127_().m_142126_(), world, player);
                }
            }
        }
        return false;
    }

    private void breakBlock(BlockPos pos, Level world, Player player) {
        world.m_46953_(pos, true, (Entity)player);
    }

    private boolean isMaxCrop(BlockState bs) {
        return bs.m_60734_() instanceof TallGrassBlock || bs.m_60734_() instanceof CropBlock && ((CropBlock)bs.m_60734_()).m_52307_(bs);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment ench) {
        return ench.f_44672_ == EnchantmentCategory.BREAKABLE || ench == Enchantments.f_44987_ || ench == Items.ENCHANTMENT_GUILLOTINE || ench == Enchantments.f_44977_ || ench == Enchantments.f_44978_ || ench == Enchantments.f_44983_ || ench == Enchantments.f_44979_ || ench == Enchantments.f_44982_;
    }

    public static CompoundTag getSkullNBT(List<Integer> id, String texture) {
        CompoundTag skullNBT = new CompoundTag();
        CompoundTag propertiesNBT = new CompoundTag();
        ListTag texturesNBT = new ListTag();
        CompoundTag tNBT = new CompoundTag();
        tNBT.m_128359_("Value", texture);
        texturesNBT.add((Object)tNBT);
        propertiesNBT.m_128365_("textures", (net.minecraft.nbt.Tag)texturesNBT);
        skullNBT.m_128365_("Properties", (net.minecraft.nbt.Tag)propertiesNBT);
        skullNBT.m_128408_("Id", id);
        return skullNBT;
    }

    public static void spawnHead(LivingEntity target) {
        if (target instanceof Player) {
            ItemScythe.spawnHead((Player)target, target.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_());
        } else if (target.m_6095_() == EntityType.f_20557_) {
            ItemScythe.spawnHead(Arrays.asList(-2094654955, 1289635317, -2072061254, -1389687975), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDBlNGU2ZmJmNWYzZGNmOTQ0MjJhMWYzMTk0NDhmMTUyMzY5ZDE3OWRiZmJjZGYwMGU1YmZlODQ5NWZhOTc3In19fQ==", target.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), "xercamod.head.cow");
        } else if (target.m_6095_() == EntityType.f_20460_) {
            ItemScythe.spawnHead(Arrays.asList(-417497690, -2115092234, -1652637095, -1368159706), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWM2Y2Q3MjAyYzM0ZTc4ZjMwNzMwOTAzNDlmN2Q5NzNiMjg4YWY1ZTViNzMzNGRkMjQ5MDEwYjNmMjcwNzhmOSJ9fX0=", target.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), "xercamod.head.iron_golem");
        } else if (target.m_6095_() == EntityType.f_20505_) {
            ItemScythe.spawnHead(Arrays.asList(26786972, -1196471604, -1857097459, -1977271489), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTE4YjZiNzk3ODMzNjhkZmUwMDQyOTg1MTEwZGEzNjZmOWM3ODhiNDUwOTdhM2VhNmQwZDlhNzUzZTlmNDJjNiJ9fX0=", target.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), "xercamod.head.ocelot");
        } else if (target.m_6095_() == EntityType.f_20551_) {
            ItemScythe.spawnHead(Arrays.asList(-1988261685, -188068212, -1178146933, -1658240924), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDA2ZTM0MmY5MGVjNTM4YWFhMTU1MmIyMjRmMjY0YTA0MDg0MDkwMmUxMjZkOTFlY2U2MTM5YWE1YjNjN2NjMyJ9fX0=", target.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), "xercamod.head.blaze");
        } else if (target.m_6095_() == EntityType.f_20510_) {
            ItemScythe.spawnHead(Arrays.asList(1003849902, -32486937, -1481465560, 1732265), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTU2MmEzN2I4NzFmOTY0YmZjM2UxMzExZWE2NzJhYWEwMzk4NGE1ZGM0NzIxNTRhMzRkYzI1YWYxNTdlMzgyYiJ9fX0=", target.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), "xercamod.head.pig");
        } else if (target.m_6095_() == EntityType.f_20526_) {
            ItemScythe.spawnHead(Arrays.asList(-1039916148, -57717813, -1391423156, -248573967), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODZjMjdiMDEzZjFiZjMzNDQ4NjllODFlNWM2MTAwMjdiYzQ1ZWM1Yjc5NTE0ZmRjOTZlMDFkZjFiN2UzYTM4NyJ9fX0=", target.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), "xercamod.head.slime");
        } else if (target.m_6095_() == EntityType.f_20492_) {
            ItemScythe.spawnHead(Arrays.asList(-579522334, -80917881, -1713988716, 921668381), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjRiZDgzMjgxM2FjMzhlNjg2NDg5MzhkN2EzMmY2YmEyOTgwMWFhZjMxNzQwNDM2N2YyMTRiNzhiNGQ0NzU0YyJ9fX0=", target.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), "xercamod.head.villager");
        } else if (target.m_6095_() == EntityType.f_20554_) {
            ItemScythe.spawnHead(Arrays.asList(202094529, 1049906219, -1603801553, 1961515467), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNzdiMDcwNjNhNjg3NGZhM2UyMjU0OGUwMjA2MmJkNzMzYzI1ODg1OTI5ODA5NjI0MTgwYWViYjg1MTU1N2Y2YSJ9fX0=", target.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), "xercamod.head.cave_spider");
        } else if (target.m_6095_() == EntityType.f_20566_) {
            ItemScythe.spawnHead(Arrays.asList(-620677106, -2030549868, -1207093980, 1829338684), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWIwOWEzNzUyNTEwZTkxNGIwYmRjOTA5NmIzOTJiYjM1OWY3YThlOGE5NTY2YTAyZTdmNjZmYWZmOGQ2Zjg5ZSJ9fX0=", target.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), "xercamod.head.enderman");
        } else if (target.m_6095_() == EntityType.f_20468_) {
            ItemScythe.spawnHead(Arrays.asList(-1846771288, 385960253, -1088350611, -1439946228), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDkwZDYxZThjZTk1MTFhMGEyYjVlYTI3NDJjYjFlZjM2MTMxMzgwZWQ0MTI5ZTFiMTYzY2U4ZmYwMDBkZThlYSJ9fX0=", target.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), "xercamod.head.magma_cube");
        } else if (target.m_6095_() == EntityType.f_20531_) {
            ItemScythe.spawnHead(Arrays.asList(-174221110, 851921639, -1251029810, -1727624143), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTE2ZDE2N2M1NzQ0ZWQxNGViYzAyZjQ0N2YzMjYxNDA1OTM2MmI3ZDJlY2I4MDhmZjA2MTY1ZDJjMzQzYmVmMiJ9fX0=", target.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), "xercamod.head.zombie_pigman");
        } else if (target.m_6095_() == EntityType.f_20479_) {
            ItemScythe.spawnHead(Arrays.asList(848845569, -89043442, -1563667252, 1307407919), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjYxYTQ5NTQxYTgzNmFhOGY0Zjc2ZTBkNGNiMmZmMDQ4ODhjNjJmOTQxMWVhMTBjYmFjZjFmMmE1NDQyNDI0MCJ9fX0=", target.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), "xercamod.head.spider");
        } else if (target.m_6095_() == EntityType.f_20555_) {
            ItemScythe.spawnHead(Arrays.asList(1799972324, 1156335733, -1788030142, 1902426427), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTE2YjhlOTgzODljNTQxYmIzNjQ1Mzg1MGJjYmQxZjdiYzVhNTdkYTYyZGNjNTA1MDYwNDA5NzM3ZWM1YjcyYSJ9fX0=", target.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), "xercamod.head.chicken");
        } else if (target.m_6095_() == EntityType.f_20453_) {
            ItemScythe.spawnHead(Arrays.asList(1340996983, -1860222137, -1353501742, -1474776410), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGE0ZTQyZWIxNWEwODgxM2E2YTZmNjFmMTBhYTI4ODAxOWZhMGZhZTEwNmEyOTUzZGRiNDZmNzdlZTJkNzdmIn19fQ==", target.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), "xercamod.head.ghast");
        } else if (target.m_6095_() == EntityType.f_20504_) {
            ItemScythe.spawnHead(Arrays.asList(-1612461734, 989744374, -1157404361, 1657691129), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTIzY2ZjNTU4MjQ1NGZjZjk5MDZmODQxZmRhMmNjNmFlODk2Y2Y0NTU4MjFjNGFkYTE5OThkZTcwODc3Y2M4NiJ9fX0=", target.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), "xercamod.head.mooshroom");
        } else if (target.m_6095_() == EntityType.f_20520_) {
            ItemScythe.spawnHead(Arrays.asList(262421674, -1762178383, -1870145564, 1689656607), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvN2NhMzhjY2Y0MTdlOTljYTlkNDdlZWIxNWE4YTMwZWRiMTUwN2FhNTJiNjc4YzIyMGM3MTdjNDc0YWE2ZmUzZSJ9fX0=", target.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), "xercamod.head.sheep");
        } else if (target.m_6095_() == EntityType.f_20480_) {
            ItemScythe.spawnHead(Arrays.asList(-1940995388, 882658030, -1188418964, 246238058), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWU4OTEwMWQ1Y2M3NGFhNDU4MDIxYTA2MGY2Mjg5YTUxYTM1YTdkMzRkOGNhZGRmYzNjZGYzYjJjOWEwNzFhIn19fQ==", target.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), "xercamod.head.squid");
        }
    }

    private static void spawnHead(net.minecraft.nbt.Tag skullOwner, Level world, double x, double y, double z, @Nullable String nameTransKey) {
        ItemStack playerHead = new ItemStack((ItemLike)net.minecraft.world.item.Items.f_42680_, 1);
        CompoundTag headNBT = playerHead.m_41784_();
        headNBT.m_128365_("SkullOwner", skullOwner);
        if (nameTransKey != null) {
            playerHead.m_41714_((Component)new TranslatableComponent(nameTransKey));
        }
        Containers.m_18992_((Level)world, (double)x, (double)y, (double)z, (ItemStack)playerHead);
    }

    private static void spawnHead(List<Integer> id, String texture, Level world, double x, double y, double z, @Nullable String nameTransKey) {
        ItemScythe.spawnHead((net.minecraft.nbt.Tag)ItemScythe.getSkullNBT(id, texture), world, x, y, z, nameTransKey);
    }

    private static void spawnHead(Player player, Level world, double x, double y, double z) {
        ItemScythe.spawnHead((net.minecraft.nbt.Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)player.m_36316_()), world, x, y, z, null);
    }

    @ParametersAreNonnullByDefault
    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!Config.isScytheEnabled()) {
            return;
        }
        super.m_6787_(group, items);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44983_, (ItemStack)stack) > 0) {
            boolean sweep;
            float damage = (float)player.m_21051_(Attributes.f_22281_).m_22135_();
            float bonusDamage = entity instanceof LivingEntity ? EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)((LivingEntity)entity).m_6336_()) : EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
            float cooldownStrength = player.m_36403_(0.5f);
            damage *= 0.2f + cooldownStrength * cooldownStrength * 0.8f;
            damage += (bonusDamage *= cooldownStrength);
            boolean cooledAttack = cooldownStrength > 0.9f;
            boolean cooledSprintAttack = player.m_20142_() && cooledAttack;
            boolean critical = cooledAttack && player.f_19789_ > 0.0f && !player.m_20096_() && !player.m_6147_() && !player.m_20069_() && !player.m_21023_(MobEffects.f_19610_) && !player.m_20159_() && entity instanceof LivingEntity && !player.m_20142_();
            double d0 = player.f_19787_ - player.f_19867_;
            boolean bl = sweep = cooledAttack && !critical && !cooledSprintAttack && player.m_20096_() && d0 < (double)player.m_6113_();
            if (sweep) {
                float sweepDamage = 1.0f + EnchantmentHelper.m_44821_((LivingEntity)player) * damage;
                for (LivingEntity livingentity : player.f_19853_.m_45976_(LivingEntity.class, entity.m_142469_().m_82377_(1.0, 0.25, 1.0))) {
                    if (livingentity == player || livingentity == entity || player.m_7307_((Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !(player.m_20280_((Entity)livingentity) < 9.0)) continue;
                    livingentity.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
                    livingentity.m_6469_(DamageSource.m_19344_((Player)player), sweepDamage);
                }
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
                player.m_36346_();
            }
        }
        return false;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand hand) {
        ItemStack heldItem = playerIn.m_21120_(hand);
        if (EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_GUILLOTINE, (ItemStack)heldItem) > 0) {
            playerIn.m_6672_(hand);
            return InteractionResultHolder.m_19090_((Object)heldItem);
        }
        return InteractionResultHolder.m_19098_((Object)heldItem);
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack stack) {
        if (EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_GUILLOTINE, (ItemStack)stack) > 0) {
            return UseAnim.BOW;
        }
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        if (EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_GUILLOTINE, (ItemStack)stack) > 0) {
            return 72000;
        }
        return 0;
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof Player)) {
            return;
        }
        if (EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_GUILLOTINE, (ItemStack)stack) <= 0) {
            return;
        }
        Player player = (Player)entityLiving;
        float f = (float)(this.m_8105_(stack) - timeLeft) / 20.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        if ((double)f >= 0.9) {
            player.m_6674_(InteractionHand.MAIN_HAND);
            if (worldIn.f_46443_) {
                Minecraft mine = Minecraft.m_91087_();
                if (mine.f_91077_ != null && mine.f_91077_.m_6662_() == HitResult.Type.ENTITY) {
                    Entity target = ((EntityHitResult)mine.f_91077_).m_82443_();
                    ScytheAttackPacket pack = new ScytheAttackPacket(f, target.m_142049_());
                    XercaMod.NETWORK_HANDLER.sendToServer((Object)pack);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        TranslatableComponent text = new TranslatableComponent("xercamod.scythe_tooltip");
        tooltip.add((Component)text.m_130940_(ChatFormatting.BLUE));
        if (EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_GUILLOTINE, (ItemStack)stack) > 0) {
            TranslatableComponent textGuillotine = new TranslatableComponent("xercamod.guillotine_tooltip");
            tooltip.add((Component)textGuillotine.m_130940_(ChatFormatting.YELLOW));
        }
    }
}

