/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.item;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.block.BlockTeapot;
import xerca.xercamod.common.item.Items;

public class ItemTeapot
extends BlockItem {
    public static final int maxTea = 7;
    private final int teaAmount;
    private final boolean isHot;

    public ItemTeapot(BlockTeapot blockTeapot, int teaAmount, boolean isHot) {
        super((Block)blockTeapot, (teaAmount == 7 ? new Item.Properties().m_41491_((CreativeModeTab)Items.teaTab) : new Item.Properties()).m_41499_(7));
        this.teaAmount = teaAmount;
        this.isHot = isHot;
        String baseName = isHot ? "item_hot_teapot_" : "item_full_teapot_";
        this.setRegistryName(baseName + teaAmount);
    }

    public int getTeaAmount() {
        return this.teaAmount;
    }

    public boolean isHot() {
        return this.isHot;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TextComponent(this.isHot ? "Hot" : "Cold"));
        tooltip.add((Component)new TextComponent("Tea amount: " + this.teaAmount));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!Config.isTeaEnabled()) {
            return;
        }
        if (this.m_41389_(group)) {
            items.add((Object)new ItemStack((ItemLike)this));
        }
    }

    @Nullable
    protected BlockState m_5965_(BlockPlaceContext context) {
        Object blockstate = context.m_43722_().m_41720_() instanceof ItemTeapot ? (!((ItemTeapot)context.m_43722_().m_41720_()).isHot ? null : (BlockState)this.m_40614_().m_5573_(context).m_61124_((Property)BlockTeapot.TEA_AMOUNT, (Comparable)Integer.valueOf(((ItemTeapot)context.m_43722_().m_41720_()).teaAmount))) : this.m_40614_().m_5573_(context);
        return blockstate != null && this.m_40610_(context, (BlockState)blockstate) ? blockstate : null;
    }
}

