/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.HammerAttackPacket;
import xerca.xercamod.common.packets.HammerQuakePacket;

public class ItemWarhammer
extends Item {
    private final float weaponDamage;
    private final float pushAmount;
    private final Tiers material;
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public ItemWarhammer(String name, Tiers mat) {
        super(mat.equals((Object)Tiers.NETHERITE) ? new Item.Properties().m_41491_(CreativeModeTab.f_40757_).m_41487_(1).m_41499_(mat.m_6609_()).m_41486_() : new Item.Properties().m_41491_(CreativeModeTab.f_40757_).m_41487_(1).m_41499_(mat.m_6609_()));
        this.setRegistryName(name);
        this.material = mat;
        this.weaponDamage = 1.0f + mat.m_6631_();
        this.pushAmount = this.getPushFromMaterial(mat);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.weaponDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -3.0, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    private float getPushFromMaterial(Tiers mat) {
        float push = mat == Tiers.STONE ? 0.15f : (mat == Tiers.IRON ? 0.3f : (mat == Tiers.DIAMOND ? 0.4f : 0.5f));
        return push;
    }

    public int m_6473_() {
        return this.material.m_6601_();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ == EnchantmentCategory.BREAKABLE || enchantment == Items.ENCHANTMENT_HEAVY || enchantment == Items.ENCHANTMENT_QUAKE || enchantment == Items.ENCHANTMENT_MAIM || enchantment == Items.ENCHANTMENT_QUICK || enchantment == Items.ENCHANTMENT_UPPERCUT || enchantment == Enchantments.f_44978_ || enchantment == Enchantments.f_44979_ || enchantment == Enchantments.f_44982_;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, p -> p.m_21190_(InteractionHand.MAIN_HAND));
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState blockIn, BlockPos pos, LivingEntity entityLiving) {
        if ((double)blockIn.m_60800_((BlockGetter)worldIn, pos) != 0.0) {
            stack.m_41622_(1, entityLiving, p -> p.m_21190_(InteractionHand.MAIN_HAND));
        }
        return true;
    }

    public boolean m_8096_(BlockState blockIn) {
        return blockIn.m_60734_() == Blocks.f_50069_;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        Ingredient ingr = this.material.m_6282_();
        if (ingr.test(repair)) {
            return true;
        }
        return super.m_6832_(toRepair, repair);
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlot equipmentSlot, ItemStack stack) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(equipmentSlot);
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public float getFullUseSeconds(ItemStack stack) {
        float seconds = 1.0f;
        if (stack.m_41793_()) {
            int heavyLevel = EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_HEAVY, (ItemStack)stack);
            if (heavyLevel > 0) {
                float multiplier = 0.1f * (float)heavyLevel;
                seconds += seconds * multiplier;
            } else {
                int quickLevel = EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_QUICK, (ItemStack)stack);
                float multiplier = 0.12f * (float)quickLevel;
                seconds -= seconds * multiplier;
            }
        }
        return seconds;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand hand) {
        ItemStack heldItem = playerIn.m_21120_(hand);
        playerIn.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldItem);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof Player)) {
            return;
        }
        Player player = (Player)entityLiving;
        float useSeconds = (float)(this.m_8105_(stack) - timeLeft) / 20.0f;
        float f = useSeconds / this.getFullUseSeconds(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        if ((double)f >= 0.1) {
            player.m_6674_(InteractionHand.MAIN_HAND);
            if (worldIn.f_46443_) {
                Minecraft mine = Minecraft.m_91087_();
                if (mine.f_91077_ != null) {
                    if (mine.f_91077_.m_6662_() == HitResult.Type.ENTITY) {
                        Entity target = ((EntityHitResult)mine.f_91077_).m_82443_();
                        HammerAttackPacket pack = new HammerAttackPacket(f, target.m_142049_());
                        XercaMod.NETWORK_HANDLER.sendToServer((Object)pack);
                    } else if (mine.f_91077_.m_6662_() == HitResult.Type.BLOCK && EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_QUAKE, (ItemStack)stack) > 0) {
                        HammerQuakePacket pack = new HammerQuakePacket(mine.f_91077_.m_82450_(), f);
                        XercaMod.NETWORK_HANDLER.sendToServer((Object)pack);
                    }
                }
            }
        }
    }

    public float getPushAmount() {
        return this.pushAmount;
    }

    @ParametersAreNonnullByDefault
    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!Config.isWarhammerEnabled()) {
            return;
        }
        super.m_6787_(group, items);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        TranslatableComponent text = new TranslatableComponent("xercamod.warhammer_tooltip");
        tooltip.add((Component)text.m_130940_(ChatFormatting.BLUE));
    }
}

