/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import xerca.xercamod.common.packets.BeheadParticlePacket;

public class BeheadParticlePacketHandler {
    public static void handle(BeheadParticlePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ctx.get().enqueueWork(() -> BeheadParticlePacketHandler.processMessage(message));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void processMessage(BeheadParticlePacket pkt) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        for (int j = 0; j < pkt.getCount(); ++j) {
            double velX = ((double)world.f_46441_.nextFloat() - 0.5) * 0.25;
            double velY = 0.4 + (double)world.f_46441_.nextFloat() * 0.3;
            double velZ = ((double)world.f_46441_.nextFloat() - 0.5) * 0.25;
            world.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42259_)), pkt.getPosX(), pkt.getPosY(), pkt.getPosZ(), velX, velY, velZ);
        }
    }
}

