/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.packets;

import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import xerca.xercamod.common.packets.ParticlePacket;

public class ConfettiParticlePacket
extends ParticlePacket {
    private Vec3i direction;

    public ConfettiParticlePacket(int count, double posX, double posY, double posZ) {
        this(count, posX, posY, posZ, Vec3i.f_123288_);
    }

    public ConfettiParticlePacket(int count, double posX, double posY, double posZ, Vec3i direction) {
        super(count, posX, posY, posZ);
        this.direction = direction;
    }

    public ConfettiParticlePacket() {
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        super.read(buf);
        this.direction = new Vec3i(buf.readInt(), buf.readInt(), buf.readInt());
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        super.write(buf);
        buf.writeInt(this.direction.m_123341_());
        buf.writeInt(this.direction.m_123342_());
        buf.writeInt(this.direction.m_123343_());
    }

    public static ConfettiParticlePacket decode(FriendlyByteBuf buf) {
        ConfettiParticlePacket result = new ConfettiParticlePacket();
        try {
            result.read(buf);
        }
        catch (IndexOutOfBoundsException ioe) {
            System.err.println("Exception while reading ConfettiParticlePacket: " + ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    public static void encode(ConfettiParticlePacket pkt, FriendlyByteBuf buf) {
        pkt.write(buf);
    }

    public Vec3i getDirection() {
        return this.direction;
    }
}

