/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.ConfettiParticlePacket;

public class ConfettiParticlePacketHandler {
    public static void handle(ConfettiParticlePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ctx.get().enqueueWork(() -> ConfettiParticlePacketHandler.processMessage(message));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void processMessage(ConfettiParticlePacket pkt) {
        Vec3i dir = pkt.getDirection();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        for (int j = 0; j < pkt.getCount(); ++j) {
            double velX = ((double)world.f_46441_.nextFloat() + (double)dir.m_123341_() - 0.5) * 0.3;
            double velY = ((double)world.f_46441_.nextFloat() + (double)dir.m_123342_() * 0.5) * 0.5;
            double velZ = ((double)world.f_46441_.nextFloat() + (double)dir.m_123343_() - 0.5) * 0.3;
            world.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.ITEM_CONFETTI)), pkt.getPosX(), pkt.getPosY(), pkt.getPosZ(), velX, velY, velZ);
        }
    }
}

