/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.packets;

import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import xerca.xercamod.common.SoundEvents;
import xerca.xercamod.common.item.ItemWarhammer;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.HammerAttackPacket;

public class HammerAttackPacketHandler {
    public static void handle(HammerAttackPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayer sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when HammerAttackPacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> HammerAttackPacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    static float damageBonusMult(float pullDuration) {
        if (pullDuration >= 0.95f) {
            return 1.75f;
        }
        if (pullDuration >= 0.7f) {
            return 1.0f;
        }
        if (pullDuration >= 0.4f) {
            return 0.75f;
        }
        return 0.5f;
    }

    private static void processMessage(HammerAttackPacket msg, ServerPlayer pl) {
        Entity target = pl.f_19853_.m_6815_(msg.getTargetId());
        ItemStack st = pl.m_21205_();
        Item item = st.m_41720_();
        if (item instanceof ItemWarhammer) {
            float pull = msg.getPullDuration();
            float mult = HammerAttackPacketHandler.damageBonusMult(pull);
            int heavyLevel = EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_HEAVY, (ItemStack)st);
            float damage = ((float)pl.m_21051_(Attributes.f_22281_).m_22135_() + (float)heavyLevel * 0.5f) * mult;
            float push = (((ItemWarhammer)item).getPushAmount() + (float)heavyLevel * 0.15f) * 2.0f * mult;
            int uppercutLevel = EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_UPPERCUT, (ItemStack)st);
            double bonusVelY = (double)uppercutLevel * 0.25 * (double)pull;
            float pitch = 2.0f / (damage + (float)heavyLevel);
            pl.f_19853_.m_6263_(null, target.m_20185_(), target.m_20186_() + 0.5, target.m_20189_(), SoundEvents.HAMMER, SoundSource.PLAYERS, 1.0f, pl.f_19853_.f_46441_.nextFloat() * 0.1f + 0.4f + pitch);
            st.m_41622_(1, (LivingEntity)pl, p -> p.m_21190_(InteractionHand.MAIN_HAND));
            if (target instanceof LivingEntity) {
                LivingEntity targetLiving = (LivingEntity)target;
                float enchantBonus = EnchantmentHelper.m_44833_((ItemStack)st, (MobType)targetLiving.m_6336_());
                boolean cooledAttack = pull > 0.9f;
                boolean critical = cooledAttack && pl.f_19789_ > 0.0f && !pl.m_20096_() && !pl.m_6147_() && !pl.m_20069_() && !pl.m_21023_(MobEffects.f_19610_) && !pl.m_20159_() && !pl.m_20142_();
                CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)pl, (Entity)target, (boolean)critical, (float)(critical ? 1.5f : 1.0f));
                boolean bl = critical = hitResult != null;
                if (critical) {
                    damage *= hitResult.getDamageModifier();
                    pl.f_19853_.m_6263_(null, pl.m_20185_(), pl.m_20186_(), pl.m_20189_(), net.minecraft.sounds.SoundEvents.f_12313_, pl.m_5720_(), 1.0f, 1.0f);
                    pl.m_5704_(target);
                }
                targetLiving.m_6469_(DamageSource.m_19344_((Player)pl), damage += enchantBonus);
                int maimLevel = EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_MAIM, (ItemStack)st);
                if (maimLevel > 0) {
                    targetLiving.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100 + 40 * maimLevel, maimLevel - 1));
                }
            }
            Vec3 knockVector = target.m_20182_().m_82546_(pl.m_20182_()).m_82541_().m_82490_((double)push);
            target.m_5997_(knockVector.f_82479_, knockVector.f_82480_ + bonusVelY, knockVector.f_82481_);
            target.f_19864_ = true;
        } else {
            System.out.println("No warhammer at hand!");
        }
    }
}

