/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.packets;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import xerca.xercamod.common.SoundEvents;
import xerca.xercamod.common.Triggers;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.item.ItemWarhammer;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.HammerAttackPacketHandler;
import xerca.xercamod.common.packets.HammerQuakePacket;
import xerca.xercamod.common.packets.QuakeParticlePacket;

public class HammerQuakePacketHandler {
    public static void handle(HammerQuakePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayer sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when HammerQuakePacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> HammerQuakePacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    private static double rangeForQuake(int quakeLevel) {
        switch (quakeLevel) {
            case 1: {
                return 9.0;
            }
            case 2: {
                return 16.0;
            }
            case 3: {
                return 25.0;
            }
        }
        return 0.0;
    }

    private static void processMessage(HammerQuakePacket msg, ServerPlayer pl) {
        ItemStack st = pl.m_21205_();
        Item item = st.m_41720_();
        if (item instanceof ItemWarhammer) {
            int quakeLevel = EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_QUAKE, (ItemStack)st);
            if (quakeLevel > 0) {
                double range = HammerQuakePacketHandler.rangeForQuake(quakeLevel);
                List targets = pl.f_19853_.m_6443_(LivingEntity.class, new AABB(pl.m_20182_().m_82492_(5.0, 5.0, 5.0), pl.m_20182_().m_82520_(5.0, 5.0, 5.0)), entity -> !entity.m_7306_((Entity)pl) && entity.m_20182_().m_82557_(msg.getPosition()) < range);
                if (targets.size() >= 6) {
                    Triggers.QUAKE.trigger(pl);
                }
                float pull = msg.getPullDuration();
                float mult = HammerAttackPacketHandler.damageBonusMult(pull);
                int heavyLevel = EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_HEAVY, (ItemStack)st);
                float damage = ((float)pl.m_21051_(Attributes.f_22281_).m_22135_() + (float)heavyLevel * 0.5f) * mult * 0.5f;
                float push = (((ItemWarhammer)item).getPushAmount() + (float)heavyLevel * 0.15f) * mult;
                float pitch = 2.0f / (damage + (float)heavyLevel);
                double volume = Math.log10(10.0 * (double)pull + 1.0);
                if (volume > 1.0) {
                    volume = 1.0;
                }
                Vec3 pos = msg.getPosition();
                for (LivingEntity target : targets) {
                    Vec3 knockvec = target.m_20182_().m_82546_(pos).m_82541_().m_82490_((double)push);
                    target.m_5997_(knockvec.f_82479_, knockvec.f_82480_, knockvec.f_82481_);
                    target.m_6469_(DamageSource.m_19344_((Player)pl), damage);
                }
                st.m_41622_(1, (LivingEntity)pl, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                pl.f_19853_.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.STOMP, SoundSource.PLAYERS, (float)volume, pl.f_19853_.f_46441_.nextFloat() * 0.1f + 0.4f + pitch);
                int particleCount = (int)(volume * 64.0);
                QuakeParticlePacket pack = new QuakeParticlePacket(particleCount, pos.f_82479_, pos.f_82480_, pos.f_82481_);
                XercaMod.NETWORK_HANDLER.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(pos.f_82479_, pos.f_82480_, pos.f_82481_, 64.0, pl.m_9236_().m_46472_())), (Object)pack);
            } else {
                System.out.println("No quake found in warhammer!");
            }
        } else {
            System.out.println("No warhammer found in hand!");
        }
    }
}

