/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.packets;

import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.KnifeAttackPacket;

public class KnifeAttackPacketHandler {
    public static void handle(KnifeAttackPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayer sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when KnifeAttackPacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> KnifeAttackPacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(KnifeAttackPacket msg, ServerPlayer pl) {
        Entity target = pl.f_19853_.m_6815_(msg.getTargetId());
        ItemStack st = pl.m_21206_();
        if (st.m_41720_() != Items.ITEM_KNIFE) {
            XercaMod.LOGGER.warn("No knife at offhand!");
            return;
        }
        if (target instanceof LivingEntity) {
            st.m_41720_().m_7579_(st, (LivingEntity)target, (LivingEntity)pl);
            float enchantBonus = EnchantmentHelper.m_44833_((ItemStack)st, (MobType)((LivingEntity)target).m_6336_());
            target.m_6469_(DamageSource.m_19344_((Player)pl), 3.0f + enchantBonus);
            if (enchantBonus > 0.0f) {
                pl.m_5700_(target);
                pl.f_19853_.m_6263_(null, pl.m_20185_(), pl.m_20186_(), pl.m_20189_(), SoundEvents.f_12316_, pl.m_5720_(), 1.0f, 1.0f);
            } else {
                pl.f_19853_.m_6263_(null, pl.m_20185_(), pl.m_20186_(), pl.m_20189_(), SoundEvents.f_12318_, pl.m_5720_(), 1.0f, 1.0f);
            }
        }
    }
}

