/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import xerca.xercamod.common.packets.QuakeParticlePacket;

public class QuakeParticlePacketHandler {
    public static void handle(QuakeParticlePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ctx.get().enqueueWork(() -> QuakeParticlePacketHandler.processMessage(message));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void processMessage(QuakeParticlePacket pkt) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        Vec3 centerPos = new Vec3(pkt.getPosX(), pkt.getPosY(), pkt.getPosZ());
        for (int j = 0; j < pkt.getCount(); ++j) {
            double posX = centerPos.f_82479_ + world.f_46441_.nextGaussian();
            double posY = centerPos.f_82480_;
            double posZ = centerPos.f_82481_ + world.f_46441_.nextGaussian();
            Vec3 particlePos = new Vec3(posX, posY, posZ);
            Vec3 particleVel = particlePos.m_82546_(centerPos).m_82541_().m_82490_(0.15);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, posX, posY, posZ, particleVel.f_82479_, 0.01, particleVel.f_82481_);
        }
    }
}

