/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.packets;

import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import xerca.xercamod.common.SoundEvents;
import xerca.xercamod.common.Triggers;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.item.ItemScythe;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.BeheadParticlePacket;
import xerca.xercamod.common.packets.ScytheAttackPacket;

public class ScytheAttackPacketHandler {
    public static void handle(ScytheAttackPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayer sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when ScytheAttackPacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> ScytheAttackPacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(ScytheAttackPacket msg, ServerPlayer pl) {
        ItemStack st = pl.m_21205_();
        Item item = st.m_41720_();
        if (item instanceof ItemScythe && EnchantmentHelper.m_44843_((Enchantment)Items.ENCHANTMENT_GUILLOTINE, (ItemStack)st) > 0) {
            float pull = msg.getPullDuration();
            if (pull < 0.9f) {
                XercaMod.LOGGER.warn("Pull duration too short");
                return;
            }
            Entity target = pl.f_19853_.m_6815_(msg.getTargetId());
            float damage = (float)pl.m_21051_(Attributes.f_22281_).m_22135_() * 1.3f;
            st.m_41622_(1, (LivingEntity)pl, p -> p.m_21190_(InteractionHand.MAIN_HAND));
            if (target instanceof LivingEntity) {
                LivingEntity targetLiving = (LivingEntity)target;
                float enchantBonus = EnchantmentHelper.m_44833_((ItemStack)st, (MobType)targetLiving.m_6336_());
                targetLiving.m_6469_(DamageSource.m_19344_((Player)pl), damage += enchantBonus);
                if (targetLiving.m_21223_() <= 0.0f) {
                    pl.f_19853_.m_6263_(null, target.m_20185_(), target.m_20186_() + 0.5, target.m_20189_(), SoundEvents.BEHEAD, SoundSource.PLAYERS, 1.0f, pl.f_19853_.f_46441_.nextFloat() * 0.2f + 0.9f);
                    BeheadParticlePacket pack = new BeheadParticlePacket(96, targetLiving.m_20185_(), targetLiving.m_20186_(), targetLiving.m_20189_());
                    XercaMod.NETWORK_HANDLER.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(targetLiving.m_20185_(), targetLiving.m_20186_(), targetLiving.m_20189_(), 64.0, pl.m_9236_().m_46472_())), (Object)pack);
                    ItemScythe.spawnHead(targetLiving);
                    Triggers.BEHEAD.trigger(pl);
                } else {
                    pl.f_19853_.m_6263_(null, target.m_20185_(), target.m_20186_() + 0.5, target.m_20189_(), net.minecraft.sounds.SoundEvents.f_12316_, SoundSource.PLAYERS, 1.0f, pl.f_19853_.f_46441_.nextFloat() * 0.2f + 0.9f);
                }
            }
        } else {
            XercaMod.LOGGER.warn("No Scythe at hand or doesn't have guillotine!");
        }
    }
}

