/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.tile_entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import xerca.xercamod.common.ContainerFunctionalBookcase;
import xerca.xercamod.common.block.BlockFunctionalBookcase;
import xerca.xercamod.common.block.Blocks;
import xerca.xercamod.common.tile_entity.XercaTileEntities;

public class TileEntityFunctionalBookcase
extends BlockEntity
implements MenuProvider {
    private static final int NUMBER_OF_SLOTS = 6;
    private final ItemStackHandler inventory = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            TileEntityFunctionalBookcase.this.m_6596_();
        }
    };
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public TileEntityFunctionalBookcase(BlockPos blockPos, BlockState blockState) {
        super(XercaTileEntities.FUNCTIONAL_BOOKCASE, blockPos, blockState);
    }

    public int getSizeInventory() {
        return 6;
    }

    public boolean isUsableByPlayer(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        double X_CENTRE_OFFSET = 0.5;
        double Y_CENTRE_OFFSET = 0.5;
        double Z_CENTRE_OFFSET = 0.5;
        double MAXIMUM_DISTANCE_SQ = 64.0;
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) < 64.0;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Nonnull
    public CompoundTag m_6945_(CompoundTag parentNBTTagCompound) {
        super.m_6945_(parentNBTTagCompound);
        CompoundTag inventoryTagCompound = this.inventory.serializeNBT();
        parentNBTTagCompound.m_128365_("inventory", (Tag)inventoryTagCompound);
        return parentNBTTagCompound;
    }

    public void m_142466_(CompoundTag parentNBTTagCompound) {
        super.m_142466_(parentNBTTagCompound);
        CompoundTag inventoryTagCompound = parentNBTTagCompound.m_128469_("inventory");
        this.inventory.deserializeNBT(inventoryTagCompound);
    }

    public void closeInventory(Player player) {
        int i = this.getBookAmount();
        BlockState st = (BlockState)Blocks.BLOCK_BOOKCASE.m_49966_().m_61124_((Property)BlockFunctionalBookcase.BOOK_AMOUNT, (Comparable)Integer.valueOf(i));
        this.f_58857_.m_46597_(this.f_58858_, st);
        this.f_58857_.m_46717_(this.f_58858_, st.m_60734_());
        this.m_6596_();
    }

    private int getBookAmount() {
        int total = 0;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            ++total;
        }
        return total;
    }

    public void m_6596_() {
        super.m_6596_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.m_58899_(), 0, this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public void handleUpdateTag(CompoundTag nbt) {
        this.m_142466_(nbt);
    }

    public Component m_5446_() {
        return new TranslatableComponent(Blocks.BLOCK_BOOKCASE.m_7705_() + ".name");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new ContainerFunctionalBookcase(windowId, playerInventory, this);
    }
}

