/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths;

import chumbanotz.abyssaldepths.ADConfig;
import chumbanotz.abyssaldepths.entity.ADEntityType;
import chumbanotz.abyssaldepths.entity.MultipartMobEntity;
import chumbanotz.abyssaldepths.entity.SeaSerpentEntity;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="abyssaldepths")
public class EventHandler {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof CreatureEntity) {
            CreatureEntity creature = (CreatureEntity)event.getEntity();
            if (creature instanceof AbstractFishEntity && !(creature instanceof IMob)) {
                creature.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal(creature, MultipartMobEntity.class, 8.0f, 1.6, 1.4));
            }
            if (creature.func_200600_R() == EntityType.field_205137_n) {
                creature.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal(creature, SeaSerpentEntity.class, 8.0f, 1.0, 1.0));
            }
            if (creature.func_200600_R() == EntityType.field_203099_aq) {
                creature.field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal(creature, SeaSerpentEntity.class, 8.0f, 1.0, 1.2));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity directEntity = event.getSource().func_76346_g();
        LivingEntity killedEntity = event.getEntityLiving();
        if (directEntity == event.getSource().func_76364_f() && directEntity instanceof MultipartMobEntity && ((MultipartMobEntity)directEntity).canConsume((Entity)killedEntity)) {
            killedEntity.func_70106_y();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void addBiomeSpawn(BiomeLoadingEvent event) {
        List waterCreatureSpawners;
        List biomeWhitelist = (List)ADConfig.biomeWhitelist.get();
        if (biomeWhitelist.isEmpty() || !biomeWhitelist.contains(event.getName().func_110624_b())) {
            return;
        }
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)event.getName());
        List waterAmbientSpawners = event.getSpawns().getSpawner(EntityClassification.WATER_AMBIENT);
        if (!waterAmbientSpawners.isEmpty()) {
            if (BiomeDictionary.hasType((RegistryKey)key, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
                EventHandler.addSpawn(waterAmbientSpawners, ADEntityType.FISH, ADConfig.fishWeight, 3, 5);
            }
            if (BiomeDictionary.hasType((RegistryKey)key, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
                EventHandler.addSpawn(waterAmbientSpawners, ADEntityType.BLACKCAP_BASSLET, ADConfig.blackcapBassletWeight, 1, 4);
                EventHandler.addSpawn(waterAmbientSpawners, ADEntityType.BUTTERFLYFISH, ADConfig.butterflyfishWeight, 2, 5);
                EventHandler.addSpawn(waterAmbientSpawners, ADEntityType.CLOWNFISH, ADConfig.clownfishWeight, 2, 3);
                EventHandler.addSpawn(waterAmbientSpawners, ADEntityType.FISH, ADConfig.fishWeight, 3, 5);
                EventHandler.addSpawn(waterAmbientSpawners, ADEntityType.FAIRY_BASSLET, ADConfig.fairyBassletWeight, 1, 4);
                EventHandler.addSpawn(waterAmbientSpawners, ADEntityType.MASKED_BUTTERFLYFISH, ADConfig.maskedButterflyfishWeight, 2, 5);
                EventHandler.addSpawn(waterAmbientSpawners, ADEntityType.RACCOON_BUTTERFLYFISH, ADConfig.raccoonButterflyfishWeight, 3, 5);
            }
        }
        if (!(waterCreatureSpawners = event.getSpawns().getSpawner(EntityClassification.WATER_CREATURE)).isEmpty() && BiomeDictionary.hasType((RegistryKey)key, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            EventHandler.addSpawn(waterCreatureSpawners, ADEntityType.SAILFISH, ADConfig.sailfishWeight, 1, 5);
            EventHandler.addSpawn(waterCreatureSpawners, ADEntityType.SEA_SERPENT, ADConfig.seaSerpentWeight, 1, 1);
            EventHandler.addSpawn(waterCreatureSpawners, ADEntityType.SEAHORSE, ADConfig.seahorseWeight, 1, 3);
            EventHandler.addSpawn(waterCreatureSpawners, ADEntityType.SWORDFISH, ADConfig.swordfishWeight, 1, 4);
        }
    }

    private static void addSpawn(List<MobSpawnInfo.Spawners> spawners, EntityType<? extends MobEntity> entityType, ForgeConfigSpec.IntValue configWeight, int min, int max) {
        if ((Integer)configWeight.get() > 0) {
            spawners.add(new MobSpawnInfo.Spawners(entityType, ((Integer)configWeight.get()).intValue(), min, max));
        }
    }
}

