/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths;

import chumbanotz.abyssaldepths.AbyssalDepths;
import chumbanotz.abyssaldepths.entity.ADEntityType;
import chumbanotz.abyssaldepths.entity.BodyPartEntity;
import chumbanotz.abyssaldepths.entity.SeaSerpentEntity;
import chumbanotz.abyssaldepths.entity.SeahorseEntity;
import chumbanotz.abyssaldepths.entity.billfish.SailfishEntity;
import chumbanotz.abyssaldepths.entity.billfish.SwordfishEntity;
import chumbanotz.abyssaldepths.entity.fish.BassletEntity;
import chumbanotz.abyssaldepths.entity.fish.ButterflyfishEntity;
import chumbanotz.abyssaldepths.entity.fish.ClownfishEntity;
import chumbanotz.abyssaldepths.entity.fish.FishEntity;
import chumbanotz.abyssaldepths.item.ADFoods;
import chumbanotz.abyssaldepths.item.ADItems;
import chumbanotz.abyssaldepths.item.CustomFishBucketItem;
import chumbanotz.abyssaldepths.item.SpikeSword;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.Foods;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="abyssaldepths", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryHandler {
    private static Map<EntityType<?>, SpawnEggItem> spawnEggs = new HashMap();

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)RegistryHandler.setRegistryName("bannerfish_bucket", new CustomFishBucketItem(() -> ADEntityType.BANNERFISH)), (Item)RegistryHandler.setRegistryName("butterflyfish_bucket", new CustomFishBucketItem(() -> ADEntityType.BUTTERFLYFISH)), (Item)RegistryHandler.setRegistryName("clownfish_bucket", new CustomFishBucketItem(() -> ADEntityType.CLOWNFISH)), (Item)RegistryHandler.setRegistryName("fish_bucket", new CustomFishBucketItem(() -> ADEntityType.FISH)), (Item)RegistryHandler.setRegistryName("masked_butterflyfish_bucket", new CustomFishBucketItem(() -> ADEntityType.MASKED_BUTTERFLYFISH)), (Item)RegistryHandler.setRegistryName("raccoon_butterflyfish_bucket", new CustomFishBucketItem(() -> ADEntityType.RACCOON_BUTTERFLYFISH)), (Item)RegistryHandler.setRegistryName("spotfin_butterflyfish_bucket", new CustomFishBucketItem(() -> ADEntityType.SPOTFIN_BUTTERFLYFISH)), RegistryHandler.setRegistryName("bannerfish", new Item(RegistryHandler.defaultProperty().func_221540_a(ADFoods.BANNERFISH))), RegistryHandler.setRegistryName("butterflyfish", new Item(RegistryHandler.defaultProperty().func_221540_a(ADFoods.BUTTERFLYFISH))), RegistryHandler.setRegistryName("fish", new Item(RegistryHandler.defaultProperty().func_221540_a(Foods.field_221434_j))), RegistryHandler.setRegistryName("cooked_fish", new Item(RegistryHandler.defaultProperty().func_221540_a(Foods.field_221437_m))), RegistryHandler.setRegistryName("cooked_butterflyfish", new Item(RegistryHandler.defaultProperty().func_221540_a(ADFoods.COOKED_BUTTERFLYFISH))), RegistryHandler.setRegistryName("masked_butterflyfish", new Item(RegistryHandler.defaultProperty().func_221540_a(ADFoods.BUTTERFLYFISH))), RegistryHandler.setRegistryName("raccoon_butterflyfish", new Item(RegistryHandler.defaultProperty().func_221540_a(ADFoods.BUTTERFLYFISH))), RegistryHandler.setRegistryName("spotfin_butterflyfish", new Item(RegistryHandler.defaultProperty().func_221540_a(ADFoods.BUTTERFLYFISH))), RegistryHandler.setRegistryName("spike_sword", new SpikeSword(RegistryHandler.defaultProperty())), RegistryHandler.setRegistryName("short_billfish_spike", new Item(RegistryHandler.defaultProperty())), RegistryHandler.setRegistryName("long_billfish_spike", new Item(RegistryHandler.defaultProperty())), RegistryHandler.setRegistryName("seaweed", new Item(RegistryHandler.defaultProperty()))});
        RegistryHandler.build("bannerfish", EntityType.Builder.func_220322_a(ButterflyfishEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.7f, 0.6f).setTrackingRange(4), 16183797, 0x121212);
        RegistryHandler.build("blackcap_basslet", EntityType.Builder.func_220322_a(BassletEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.7f, 0.5f).setTrackingRange(4), 12599507, 0x121212);
        RegistryHandler.build("butterflyfish", EntityType.Builder.func_220322_a(ButterflyfishEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.7f, 0.6f).setTrackingRange(4), 8762546, 12307920);
        RegistryHandler.build("clownfish", EntityType.Builder.func_220322_a(ClownfishEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.7f, 0.5f).setTrackingRange(4), 13785366, 0xFFFFFF);
        RegistryHandler.build("fairy_basslet", EntityType.Builder.func_220322_a(BassletEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.7f, 0.5f).setTrackingRange(4), 12599507, 16693761);
        RegistryHandler.build("fish", EntityType.Builder.func_220322_a(FishEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.7f, 0.5f).setTrackingRange(4), 8762546, 12307920);
        RegistryHandler.build("masked_butterflyfish", EntityType.Builder.func_220322_a(ButterflyfishEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.7f, 0.6f).setTrackingRange(4), 16438016, 3817060);
        RegistryHandler.build("raccoon_butterflyfish", EntityType.Builder.func_220322_a(ButterflyfishEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.7f, 0.6f).setTrackingRange(4), 16297728, 1513499);
        RegistryHandler.build("sailfish", EntityType.Builder.func_220322_a(SailfishEntity::new, (EntityClassification)EntityClassification.WATER_CREATURE).func_220321_a(0.7f, 0.6f).setTrackingRange(8), 1060456, 0xE0E0E0);
        RegistryHandler.build("seahorse", EntityType.Builder.func_220322_a(SeahorseEntity::new, (EntityClassification)EntityClassification.WATER_CREATURE).func_220321_a(0.95f, 2.2f), 13818758, 0x778833);
        RegistryHandler.build("sea_serpent", EntityType.Builder.func_220322_a(SeaSerpentEntity::new, (EntityClassification)EntityClassification.WATER_CREATURE).func_220321_a(1.1f, 1.1f).setTrackingRange(10), 5938242, 9398119);
        RegistryHandler.build("spotfin_butterflyfish", EntityType.Builder.func_220322_a(ButterflyfishEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.7f, 0.6f).setTrackingRange(4), 16311296, 16121335);
        RegistryHandler.build("swordfish", EntityType.Builder.func_220322_a(SwordfishEntity::new, (EntityClassification)EntityClassification.WATER_CREATURE).func_220321_a(0.8f, 0.7f).setTrackingRange(8), 1060456, 0xE0E0E0);
        for (SpawnEggItem spawnEggItem : spawnEggs.values()) {
            event.getRegistry().register((IForgeRegistryEntry)spawnEggItem);
        }
    }

    @SubscribeEvent
    public static void registerEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
        for (EntityType<?> entityType : spawnEggs.keySet()) {
            event.getRegistry().register(entityType);
        }
        event.getRegistry().register(RegistryHandler.build("body_part", EntityType.Builder.func_220322_a(BodyPartEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(BodyPartEntity::new).func_200705_b().func_200706_c()));
    }

    @SubscribeEvent
    public static void remapBlocks(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            if (!mapping.key.toString().equals("abyssaldepths:seaweed")) continue;
            mapping.remap((IForgeRegistryEntry)Blocks.field_150355_j);
        }
    }

    @SubscribeEvent
    public static void remapItems(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            if (!mapping.key.toString().equals("abyssaldepths:goggles")) continue;
            mapping.ignore();
        }
    }

    public static void registerDispenserBehavior() {
        DefaultDispenseItemBehavior dispenseSpawnEggBehavior = new DefaultDispenseItemBehavior(){

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
                EntityType entitytype = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
                entitytype.func_220331_a(source.func_197524_h(), stack, null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
                stack.func_190918_g(1);
                return stack;
            }
        };
        for (SpawnEggItem spawnEggItem : spawnEggs.values()) {
            DispenserBlock.func_199774_a((IItemProvider)spawnEggItem, (IDispenseItemBehavior)dispenseSpawnEggBehavior);
        }
        DefaultDispenseItemBehavior dispenseFishBucketBehavior = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultBehaviour = new DefaultDispenseItemBehavior();

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                CustomFishBucketItem bucketitem = (CustomFishBucketItem)stack.func_77973_b();
                BlockPos blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
                ServerWorld world = source.func_197524_h();
                if (bucketitem.func_180616_a(null, (World)world, blockpos, null)) {
                    bucketitem.func_203792_a((World)world, stack, blockpos);
                    return new ItemStack((IItemProvider)Items.field_151133_ar);
                }
                return this.defaultBehaviour.dispense(source, stack);
            }
        };
        DispenserBlock.func_199774_a((IItemProvider)ADItems.BANNERFISH_BUCKET, (IDispenseItemBehavior)dispenseFishBucketBehavior);
        DispenserBlock.func_199774_a((IItemProvider)ADItems.BUTTERFLYFISH_BUCKET, (IDispenseItemBehavior)dispenseFishBucketBehavior);
        DispenserBlock.func_199774_a((IItemProvider)ADItems.CLOWNFISH_BUCKET, (IDispenseItemBehavior)dispenseFishBucketBehavior);
        DispenserBlock.func_199774_a((IItemProvider)ADItems.FISH_BUCKET, (IDispenseItemBehavior)dispenseFishBucketBehavior);
        DispenserBlock.func_199774_a((IItemProvider)ADItems.MASKED_BUTTERFLYFISH_BUCKET, (IDispenseItemBehavior)dispenseFishBucketBehavior);
        DispenserBlock.func_199774_a((IItemProvider)ADItems.RACCOON_BUTTERFLYFISH_BUCKET, (IDispenseItemBehavior)dispenseFishBucketBehavior);
        DispenserBlock.func_199774_a((IItemProvider)ADItems.SPOTFIN_BUTTERFLYFISH_BUCKET, (IDispenseItemBehavior)dispenseFishBucketBehavior);
        spawnEggs.clear();
        spawnEggs = null;
    }

    public static Item.Properties defaultProperty() {
        return new Item.Properties().func_200916_a(AbyssalDepths.ITEM_GROUP);
    }

    private static <T extends MobEntity> EntityType<T> build(String name, EntityType.Builder<T> builder, int eggPrimaryColor, int eggSecondaryColor) {
        EntityType<T> entityType = RegistryHandler.build(name, builder);
        SpawnEggItem spawnEgg = new SpawnEggItem(entityType, eggPrimaryColor, eggSecondaryColor, RegistryHandler.defaultProperty());
        spawnEgg.setRegistryName(AbyssalDepths.prefix(name + "_spawn_egg"));
        spawnEggs.put(entityType, spawnEgg);
        return entityType;
    }

    private static <T extends Entity> EntityType<T> build(String name, EntityType.Builder<T> builder) {
        ResourceLocation registryName = AbyssalDepths.prefix(name);
        EntityType entityType = builder.func_206830_a(registryName.toString());
        entityType.setRegistryName(registryName);
        return entityType;
    }

    public static <T extends IForgeRegistryEntry<T>> T setRegistryName(String name, T entry) {
        return (T)((IForgeRegistryEntry)entry.setRegistryName(AbyssalDepths.prefix(name)));
    }
}

