/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.client.renderer.entity;

import chumbanotz.abyssaldepths.AbyssalDepths;
import chumbanotz.abyssaldepths.client.renderer.entity.AquaticMobRenderer;
import chumbanotz.abyssaldepths.client.renderer.entity.model.BillfishModel;
import chumbanotz.abyssaldepths.entity.ADEntityType;
import chumbanotz.abyssaldepths.entity.billfish.AbstractBillfishEntity;
import chumbanotz.abyssaldepths.entity.billfish.SwordfishEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;

public class BillfishRenderer<T extends AbstractBillfishEntity>
extends AquaticMobRenderer<T, BillfishModel<T>> {
    private static final ResourceLocation SAILFISH_TEXTURE = AbyssalDepths.getEntityTexture("billfish/sailfish");
    private static final ResourceLocation SWORDFISH_TEXTURE = AbyssalDepths.getEntityTexture("billfish/swordfish");
    private static final ResourceLocation BLUE_SWORDFISH_TEXTURE = AbyssalDepths.getEntityTexture("billfish/blue_swordfish");

    public BillfishRenderer(EntityRendererManager rendermanagerIn) {
        super(rendermanagerIn, new BillfishModel(), 0.0f);
        this.func_177094_a(new MarkingsLayer(this));
    }

    protected void preRenderCallback(T livingEntity, MatrixStack matrixStackIn, float partialTickTime) {
        if (livingEntity.func_200600_R() == ADEntityType.SWORDFISH) {
            matrixStackIn.func_227862_a_(1.3f, 1.3f, 1.3f);
        }
    }

    public ResourceLocation getEntityTexture(T entity) {
        if (entity.func_200600_R() == ADEntityType.SWORDFISH) {
            return ((SwordfishEntity)((Object)entity)).isBlue() ? BLUE_SWORDFISH_TEXTURE : SWORDFISH_TEXTURE;
        }
        return SAILFISH_TEXTURE;
    }

    static class MarkingsLayer<T extends AbstractBillfishEntity>
    extends LayerRenderer<T, BillfishModel<T>> {
        private static final ResourceLocation BANNER_TEXTURE = AbyssalDepths.getEntityTexture("billfish/banner");
        private static final ResourceLocation STRIPES_TEXTURE = AbyssalDepths.getEntityTexture("billfish/stripes");

        public MarkingsLayer(IEntityRenderer<T, BillfishModel<T>> entityRenderer) {
            super(entityRenderer);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!livingEntity.func_82150_aj()) {
                if (((AbstractBillfishEntity)((Object)livingEntity)).hasBanner()) {
                    IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_230168_b_((ResourceLocation)BANNER_TEXTURE, (boolean)false));
                    ((BillfishModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, LivingRenderer.func_229117_c_(livingEntity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
                } else if (((AbstractBillfishEntity)((Object)livingEntity)).hasStripes()) {
                    IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_230168_b_((ResourceLocation)STRIPES_TEXTURE, (boolean)false));
                    ((BillfishModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, LivingRenderer.func_229117_c_(livingEntity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        }
    }
}

