/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.client.renderer.entity;

import chumbanotz.abyssaldepths.AbyssalDepths;
import chumbanotz.abyssaldepths.client.renderer.entity.AquaticMobRenderer;
import chumbanotz.abyssaldepths.client.renderer.entity.model.SeahorseModel;
import chumbanotz.abyssaldepths.entity.SeahorseEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;

public class SeahorseRenderer
extends AquaticMobRenderer<SeahorseEntity, SeahorseModel> {
    private static final ResourceLocation TEXTURE = AbyssalDepths.getEntityTexture("seahorse/seahorse");
    private static final ResourceLocation GRAYSCALE_TEXTURE = AbyssalDepths.getEntityTexture("seahorse/grayscale");

    public SeahorseRenderer(EntityRendererManager rendermanagerIn) {
        super(rendermanagerIn, new SeahorseModel(), 0.4f);
        this.func_177094_a(new EyesLayer((IEntityRenderer<SeahorseEntity, SeahorseModel>)this));
        this.func_177094_a(new MarkingsLayer((IEntityRenderer<SeahorseEntity, SeahorseModel>)this));
    }

    public void render(SeahorseEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (entityIn.isColorful()) {
            ((SeahorseModel)this.field_77045_g).func_228253_a_(entityIn.getRed(), entityIn.getGreen(), entityIn.getBlue());
        }
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        ((SeahorseModel)this.field_77045_g).func_228253_a_(1.0f, 1.0f, 1.0f);
    }

    public ResourceLocation getEntityTexture(SeahorseEntity entity) {
        return entity.isColorful() ? GRAYSCALE_TEXTURE : TEXTURE;
    }

    static class MarkingsLayer
    extends LayerRenderer<SeahorseEntity, SeahorseModel> {
        private static final ResourceLocation[] MARKINGS = new ResourceLocation[]{AbyssalDepths.getEntityTexture("seahorse/mark1"), AbyssalDepths.getEntityTexture("seahorse/mark2")};

        public MarkingsLayer(IEntityRenderer<SeahorseEntity, SeahorseModel> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, SeahorseEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entityIn.func_82150_aj() && entityIn.getMark() > 0) {
                IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)MARKINGS[entityIn.getMark() - 1]));
                ((SeahorseModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)entityIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    static class EyesLayer
    extends LayerRenderer<SeahorseEntity, SeahorseModel> {
        private static final ResourceLocation EYES_TEXTURE = AbyssalDepths.getEntityTexture("seahorse/eyes");
        private final SeahorseModel seahorseModel = new SeahorseModel(0.01f);

        public EyesLayer(IEntityRenderer<SeahorseEntity, SeahorseModel> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, SeahorseEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            EyesLayer.func_229140_a_((EntityModel)this.func_215332_c(), (EntityModel)this.seahorseModel, (ResourceLocation)EYES_TEXTURE, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, (LivingEntity)entityIn, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

