/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity;

import chumbanotz.abyssaldepths.util.ADGlobal;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class AquaticMobEntity
extends WaterMobEntity {
    private static final DataParameter<Integer> RANDOM_OFFSET = EntityDataManager.func_187226_a(AquaticMobEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected float prevCurrentYaw;
    protected float currentYaw;
    protected float prevCurrentPitch;
    protected float currentPitch;
    protected double netSpeed;
    protected double dPosX;
    protected double dPosY;
    protected double dPosZ;
    protected Vector3d targetVec;

    protected AquaticMobEntity(EntityType<? extends AquaticMobEntity> type, World world) {
        super(type, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RANDOM_OFFSET, (Object)this.field_70146_Z.nextInt(100));
    }

    public int getRandomOffset() {
        return (Integer)this.field_70180_af.func_187225_a(RANDOM_OFFSET);
    }

    public float getCurrentPitch(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevCurrentPitch, (float)this.currentPitch);
    }

    public boolean onLand() {
        return !this.func_70090_H() && this.field_70122_E;
    }

    public boolean isTamed() {
        return false;
    }

    public boolean getRotatePitch() {
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70761_aq = this.field_70759_as = MathHelper.func_76142_g((float)this.field_70759_as);
        this.field_70177_z = this.field_70759_as;
        if (this.dotProductPos() < 1.6000001778593287E-5) {
            this.field_70125_A = 0.0f;
        }
        this.currentYaw = ADGlobal.wrapAngleAround(this.currentYaw, this.field_70177_z);
        this.currentPitch = ADGlobal.wrapAngleAround(this.currentPitch, this.field_70125_A);
        this.prevCurrentYaw = this.currentYaw;
        this.prevCurrentPitch = this.currentPitch;
        this.prevCurrentYaw = ADGlobal.wrapAngleAround(this.prevCurrentYaw, this.currentYaw);
        this.prevCurrentPitch = ADGlobal.wrapAngleAround(this.prevCurrentPitch, this.currentPitch);
        this.currentYaw += (this.field_70177_z - this.currentYaw) * 0.6f;
    }

    protected abstract void func_70619_bc();

    protected double dotProductPos() {
        return this.dPosX * this.dPosX + this.dPosY * this.dPosY + this.dPosZ * this.dPosZ;
    }

    public boolean findNewPath() {
        return (this.field_70146_Z.nextInt(70) == 0 || this.onLand() && this.field_70146_Z.nextInt(10) == 0) && !this.func_110167_bD();
    }

    protected double addPathY() {
        return this.func_70047_e();
    }

    public boolean setRandomPath() {
        Vector3d Vector3d2 = this.func_213303_ch().func_72441_c((3.0 + (double)this.field_70146_Z.nextFloat() * 3.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), ((double)this.field_70146_Z.nextFloat() - 0.5) * 6.0 + this.addPathY(), (3.0 + (double)this.field_70146_Z.nextFloat() * 3.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
        if (this.onLand()) {
            Vector3d2 = new Vector3d(this.func_226277_ct_() + (2.0 + (double)this.field_70146_Z.nextFloat() * 8.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), Vector3d2.field_72448_b, this.func_226281_cx_() + (2.0 + (double)this.field_70146_Z.nextFloat() * 8.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
        }
        if (this.isClearPath(Vector3d2)) {
            this.targetVec = Vector3d2;
            return true;
        }
        return false;
    }

    public boolean isClearPath(Vector3d Vector3d2) {
        boolean water = this.field_70170_p.func_201671_F(new BlockPos((int)Vector3d2.field_72450_a, (int)Vector3d2.field_72448_b, (int)Vector3d2.field_72449_c));
        boolean seen = this.field_70170_p.func_217299_a(new RayTraceContext(this.func_174824_e(1.0f), Vector3d2, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() == RayTraceResult.Type.MISS;
        return water && seen;
    }

    public boolean isClearPathWaterBelow(Vector3d Vector3d2) {
        boolean water = this.field_70170_p.func_201671_F(new BlockPos((int)Vector3d2.field_72450_a, (int)Vector3d2.field_72448_b, (int)Vector3d2.field_72449_c));
        boolean waterBelow = this.field_70170_p.func_201671_F(new BlockPos((int)Vector3d2.field_72450_a, (int)Vector3d2.field_72448_b - 1, (int)Vector3d2.field_72449_c));
        boolean seen = this.field_70170_p.func_217299_a(new RayTraceContext(this.func_174824_e(1.0f), Vector3d2, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() == RayTraceResult.Type.MISS;
        return (water || waterBelow) && seen;
    }

    public boolean func_204231_K() {
        return this.func_70090_H();
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_204231_K()) {
            double posY = this.func_226278_cu_();
            this.func_213309_a(0.04f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.84));
            Vector3d motion = this.func_213322_ci();
            if (this.field_70123_F && this.func_70038_c(motion.field_72450_a, motion.field_72448_b + (double)0.6f - this.func_226278_cu_() + posY, motion.field_72449_c)) {
                this.func_213293_j(motion.field_72450_a, 0.3, motion.field_72449_c);
            }
        } else if (this.func_180799_ab()) {
            double posY = this.func_226278_cu_();
            this.func_213309_a(0.02f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_178786_a(0.0, 0.02, 0.0));
            }
            Vector3d motion = this.func_213322_ci();
            if (this.field_70123_F && this.func_70038_c(motion.field_72450_a, motion.field_72448_b + (double)0.6f - this.func_226278_cu_() + posY, motion.field_72449_c)) {
                this.func_213293_j(motion.field_72450_a, 0.3f, motion.field_72449_c);
            }
        } else {
            BlockPos blockpos = this.func_226270_aj_();
            float slipperiness = this.field_70170_p.func_180495_p(blockpos).getSlipperiness((IWorldReader)this.field_70170_p, blockpos, (Entity)this);
            float xzSpeed = (this.field_70122_E ? slipperiness * 0.91f : 0.91f) * 0.1f;
            Vector3d motion = this.func_233633_a_(travelVector, slipperiness);
            double yMotion = motion.field_72448_b;
            if (this.func_70644_a(Effects.field_188424_y)) {
                yMotion += (0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1) - motion.field_72448_b) * 0.2;
                this.field_70143_R = 0.0f;
            } else if (this.field_70170_p.field_72995_K && !this.field_70170_p.func_195588_v(blockpos)) {
                yMotion = this.func_226278_cu_() > 0.0 ? -0.1 : 0.0;
            } else if (!this.func_189652_ae()) {
                yMotion -= 0.08;
            }
            this.func_213293_j(motion.field_72450_a * (double)(xzSpeed *= 0.4f), yMotion * (double)0.98f, motion.field_72449_c * (double)xzSpeed);
        }
        this.func_233629_a_((LivingEntity)this, false);
    }

    public void func_233629_a_(LivingEntity livingEntity, boolean p_233629_2_) {
        float delta;
        float f6;
        this.field_184618_aE = this.field_70721_aZ;
        double x = this.func_226277_ct_() - this.field_70169_q;
        double y = this.func_226278_cu_() - this.field_70167_r;
        double z = this.func_226281_cx_() - this.field_70166_s;
        if (!this.field_70170_p.field_72995_K) {
            x = this.dPosX;
            y = this.dPosY;
            z = this.dPosZ;
        }
        if ((f6 = MathHelper.func_76133_a((double)(x * x + y * y + z * z)) * 4.0f) > 1.0f) {
            f6 = 1.0f;
        }
        this.field_70721_aZ = !this.func_70090_H() && !this.field_70122_E ? (this.field_70721_aZ *= 0.4f) : ((delta = f6 - this.field_70721_aZ) >= 0.0f ? (this.field_70721_aZ += delta * 0.4f) : (this.field_70721_aZ += delta * 0.1f));
        this.field_184619_aG += this.field_70721_aZ;
    }

    public void func_233627_a_(float strength, double ratioX, double ratioZ) {
        Vector3d motion = this.func_213322_ci();
        super.func_233627_a_(strength, ratioX, ratioZ);
        if (this.func_70090_H()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c((motion.field_72450_a - this.func_213322_ci().field_72450_a) * 0.5, (motion.field_72448_b - this.func_213322_ci().field_72448_b) * (double)0.8f, (motion.field_72449_c - this.func_213322_ci().field_72449_c) * 0.5));
        } else {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (motion.field_72448_b - this.func_213322_ci().field_72448_b) * (double)0.4f, 0.0));
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }

    public void func_213295_a(BlockState state, Vector3d motionMultiplierIn) {
    }

    public static boolean canSpawnBelow48(EntityType<? extends AquaticMobEntity> entityType, IWorld world, SpawnReason reason, BlockPos blockPos, Random random) {
        return blockPos.func_177956_o() <= 48;
    }

    public static boolean canSpawn(EntityType<? extends AquaticMobEntity> entityType, IWorld world, SpawnReason reason, BlockPos blockPos, Random random) {
        return true;
    }
}

