/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity;

import chumbanotz.abyssaldepths.entity.ADEntityType;
import chumbanotz.abyssaldepths.entity.MultipartMobEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class BodyPartEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(BodyPartEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private int ownerId;
    private int waterTick;
    private boolean wasInWater;

    public BodyPartEntity(EntityType<? extends BodyPartEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public BodyPartEntity(MultipartMobEntity creature, float scale) {
        this(ADEntityType.BODY_PART, creature.field_70170_p);
        this.field_70180_af.func_187227_b(SCALE, (Object)Float.valueOf(scale));
        this.ownerId = creature.func_145782_y();
    }

    public BodyPartEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        this(ADEntityType.BODY_PART, world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(0.0f));
    }

    public float getScale() {
        return ((Float)this.field_70180_af.func_187225_a(SCALE)).floatValue();
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (SCALE.equals(key)) {
            this.func_213323_x_();
            this.func_226264_Z_();
        }
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)this.getScale(), (float)this.getScale());
    }

    public Entity getOwner() {
        return this.field_70170_p.func_73045_a(this.ownerId);
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        Entity owner = this.getOwner();
        return owner != null ? owner.getPickedResult(target) : ItemStack.field_190927_a;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.collideWithNearbyEntities();
        this.func_145775_I();
        if (this.field_70171_ac) {
            this.waterTick = 20;
            if (!this.wasInWater) {
                for (int i = 0; i < 12; ++i) {
                    float x = (this.func_213311_cf() * 0.4f + this.field_70146_Z.nextFloat() * 0.6f) * (float)(this.field_70146_Z.nextBoolean() ? 1 : -1);
                    float z = (this.func_213311_cf() * 0.4f + this.field_70146_Z.nextFloat() * 0.6f) * (float)(this.field_70146_Z.nextBoolean() ? 1 : -1);
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() + (double)x, this.func_226278_cu_() + 0.5 + 0.5 * (double)this.func_213311_cf() * (double)this.field_70146_Z.nextFloat(), this.func_226281_cx_() + (double)z, (double)(x * 0.1f), (double)(0.1f + 0.3f * this.func_213311_cf() * this.field_70146_Z.nextFloat()), (double)(z * 0.1f));
                }
            }
        } else if (--this.waterTick > 0) {
            for (int i = 0; i < 4; ++i) {
                float x = this.func_213311_cf() * 1.2f * (this.field_70146_Z.nextFloat() - 0.5f);
                float y = this.func_213311_cf() * 0.4f * this.field_70146_Z.nextFloat();
                float z = this.func_213311_cf() * 1.2f * (this.field_70146_Z.nextFloat() - 0.5f);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() + (double)x, this.func_174813_aQ().field_72338_b + (double)y, this.func_226281_cx_() + (double)z, 0.0, 0.0, 0.0);
            }
        }
        this.wasInWater = this.field_70171_ac;
    }

    public void func_70108_f(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!this.func_184223_x(entityIn) && (d2 = MathHelper.func_76132_a((double)(d0 = entityIn.func_226277_ct_() - this.func_226277_ct_()), (double)(d1 = entityIn.func_226281_cx_() - this.func_226281_cx_()))) >= (double)0.01f) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            d0 *= (double)(1.0f - this.field_70144_Y);
            d1 *= (double)(1.0f - this.field_70144_Y);
            if (!entityIn.func_184207_aI()) {
                entityIn.func_70024_g(d0, 0.0, d1);
            }
        }
    }

    private void collideWithNearbyEntities() {
        Entity owner = this.getOwner();
        if (!(owner instanceof MultipartMobEntity) || !owner.isAddedToWorld()) {
            this.func_70106_y();
            return;
        }
        for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2))) {
            if (!entity.func_70067_L() || this.func_70028_i(entity)) continue;
            if (entity.func_70104_M()) {
                entity.func_70108_f((Entity)this);
            }
            ((MultipartMobEntity)owner).collideWithEntity(this, entity);
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        Entity owner = this.getOwner();
        return owner != null ? owner.func_184230_a(player, hand) : ActionResultType.PASS;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity owner = this.getOwner();
        return owner != null && owner.func_70097_a(source, amount);
    }

    public boolean func_70028_i(Entity entityIn) {
        Entity owner = this.getOwner();
        return super.func_70028_i(entityIn) || entityIn == owner || entityIn instanceof BodyPartEntity && ((BodyPartEntity)entityIn).getOwner() == owner;
    }

    protected ITextComponent func_225513_by_() {
        Entity owner = this.getOwner();
        return owner != null ? owner.func_200200_C_() : super.func_225513_by_();
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150787_b(this.ownerId);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.ownerId = additionalData.func_150792_a();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

