/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity;

import chumbanotz.abyssaldepths.entity.BodyPartEntity;
import chumbanotz.abyssaldepths.entity.MultipartMobEntity;
import chumbanotz.abyssaldepths.entity.ai.goal.NearestWaterTargetGoal;
import chumbanotz.abyssaldepths.util.Bone;
import chumbanotz.abyssaldepths.util.Euler;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class SeaSerpentEntity
extends MultipartMobEntity
implements IMob {
    private static final Predicate<LivingEntity> CAN_TARGET = target -> {
        if (target.func_70662_br() || target instanceof IMob || target instanceof GolemEntity) {
            return false;
        }
        return target.func_70090_H() || !target.func_233570_aj_();
    };
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(SeaSerpentEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> HUNGER = EntityDataManager.func_187226_a(SeaSerpentEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    public static final int[] PART_HEIGHT = new int[]{8, 14, 12, 10, 8, 6, 5, 4};
    public static final int[] PART_LENGTH = new int[]{18, 24, 24, 20, 14, 16, 18, 22};
    private final BodyPartEntity[] partList = new BodyPartEntity[8];
    private final Bone baseBone = new Bone();
    private final Bone[] boneList = new Bone[8];
    private final Euler[] targetAngles = new Euler[8];
    private int strikeTick;
    private boolean strikeStopped;
    private Vector3d oldVec;

    public SeaSerpentEntity(EntityType<? extends SeaSerpentEntity> type, World world) {
        super((EntityType<? extends MultipartMobEntity>)type, world);
        int i;
        this.baseBone.setLength(0.0f);
        this.boneList[0] = new Bone(this.baseBone);
        this.boneList[0].setLength((float)PART_LENGTH[0] / 16.0f);
        for (i = 1; i < this.boneList.length; ++i) {
            this.boneList[i] = new Bone(i == 1 ? this.baseBone : this.boneList[i - 1]);
            this.boneList[i].setLength((float)(-PART_LENGTH[i]) / 16.0f);
        }
        for (i = 0; i < this.partList.length; ++i) {
            this.targetAngles[i] = new Euler();
            this.partList[i] = new BodyPartEntity(this, (float)PART_LENGTH[i] / 16.0f);
        }
        this.updateParts();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
        this.field_70180_af.func_187214_a(HUNGER, (Object)((byte)this.field_70146_Z.nextInt(16)));
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, new NearestPreyGoal<PlayerEntity>(this, PlayerEntity.class));
        this.field_70715_bh.func_75776_a(2, new NearestPreyGoal<MobEntity>(this, MobEntity.class));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return SeaSerpentEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 90.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, 12.0).func_233815_a_(Attributes.field_233819_b_, 48.0);
    }

    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    private void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    public int getHunger() {
        return ((Byte)this.field_70180_af.func_187225_a(HUNGER)).byteValue();
    }

    private void setHunger(int hunger) {
        this.field_70180_af.func_187227_b(HUNGER, (Object)((byte)hunger));
    }

    public int func_70641_bl() {
        return 1;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 25;
    }

    protected void func_209207_l(int air) {
    }

    @Override
    public BodyPartEntity[] getPartList() {
        return this.partList;
    }

    @Override
    public Bone getBaseBone() {
        return this.baseBone;
    }

    @Override
    public Bone[] getBoneList() {
        return this.boneList;
    }

    @Override
    public void updatePitchRotations(float partialTick) {
        for (int i = this.boneList.length - 1; i > 1; --i) {
            if (partialTick == 1.0f) {
                this.targetAngles[i].x = this.targetAngles[i - 1].x;
                this.boneList[i].getRotation().x += this.targetAngles[i].x;
                continue;
            }
            this.boneList[i].getRotation().x += this.targetAngles[i].x + (this.targetAngles[i - 1].x - this.targetAngles[i].x) * partialTick;
        }
        this.targetAngles[1].x = -(this.currentPitch - this.prevCurrentPitch) * 2.4f;
        float moveScale = MathHelper.func_219799_g((float)partialTick, (float)this.field_184618_aE, (float)this.field_70721_aZ);
        float moveTick = this.field_184619_aG - this.field_70721_aZ * (1.0f - partialTick);
        if (moveScale > 1.0f) {
            moveScale = 1.0f;
        }
        for (int i = 0; i < this.boneList.length; ++i) {
            float breatheAnim = MathHelper.func_76126_a((float)(0.1f * ((float)this.field_70173_aa + partialTick - (float)i * 6.0f)));
            float moveAnim = MathHelper.func_76126_a((float)(0.2f * (moveTick - (float)i * 2.0f))) * moveScale;
            this.boneList[i].getRotation().x += breatheAnim * 1.1f;
            this.boneList[i].getRotation().x += moveAnim * 6.0f;
            if (i != 0 || partialTick != 1.0f) continue;
            Euler angle = new Euler(this.currentPitch + 90.0f, this.field_70177_z, 0.0f);
            Vector3d vec = angle.rotateVector(moveAnim * 0.03f);
            this.func_213317_d(this.func_213322_ci().func_178787_e(vec));
        }
    }

    @Override
    public void updateYawRotations(float partialTick) {
        for (int i = this.boneList.length - 1; i > 1; --i) {
            if (partialTick == 1.0f) {
                this.targetAngles[i].y = this.targetAngles[i - 1].y;
                this.boneList[i].getRotation().y += this.targetAngles[i].y;
                continue;
            }
            this.boneList[i].getRotation().y += this.targetAngles[i].y + (this.targetAngles[i - 1].y - this.targetAngles[i].y) * partialTick;
        }
        this.targetAngles[1].y = -(this.currentYaw - this.prevCurrentYaw) * 2.5f;
        this.targetAngles[0].y = (this.currentYaw - this.prevCurrentYaw) * 1.5f;
    }

    private double getStrikeRange() {
        return 6.0;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getHunger() <= 0) {
                if (this.field_70173_aa % 40 == 0) {
                    this.func_70691_i(1.0f);
                }
                if (this.field_70146_Z.nextInt(3600) == 0) {
                    this.setHunger(14 + this.field_70146_Z.nextInt(8));
                }
            }
            this.strikeTick = Math.max(0, this.strikeTick - this.field_70737_aN - 1);
        }
    }

    @Override
    public double moveByTarget(LivingEntity target) {
        double targetSpeed = this.getAdjustedMovementSpeed() * 1.06;
        double dSq = this.func_70068_e((Entity)target);
        double range = 32.0;
        double strikeRange = this.getStrikeRange();
        if (this.isAttacking()) {
            double dSq1;
            if (dSq < strikeRange * strikeRange) {
                if (this.targetVec == null) {
                    this.targetVec = target.func_213303_ch().func_178788_d(this.func_213303_ch());
                    this.targetVec = this.targetVec.func_72432_b();
                }
                if (this.oldVec == null) {
                    this.oldVec = this.func_213303_ch();
                }
                if (this.func_70090_H()) {
                    this.func_70671_ap().func_75651_a((Entity)target, 15.0f, 85.0f);
                    float scale = 9.0f;
                    Vector3d motion = this.func_213322_ci();
                    this.func_213317_d(this.func_213322_ci().func_72441_c((this.targetVec.field_72450_a * (targetSpeed *= (double)0.3f) * (double)scale - motion.field_72450_a) * 0.6, (this.targetVec.field_72448_b * targetSpeed * (double)scale - motion.field_72448_b) * 0.6, (this.targetVec.field_72449_c * targetSpeed * (double)scale - motion.field_72449_c) * 0.6));
                }
            } else if (!this.strikeStopped) {
                this.func_70671_ap().func_75651_a((Entity)target, 8.0f, 85.0f);
                this.targetVec = target.func_213303_ch().func_178788_d(this.func_213303_ch());
                this.targetVec = this.targetVec.func_72432_b();
                this.oldVec = this.func_213303_ch();
            }
            if ((dSq1 = this.func_70092_e(this.oldVec.field_72450_a, this.oldVec.field_72448_b, this.oldVec.field_72449_c)) > strikeRange * strikeRange || !this.func_70090_H() && !this.field_70122_E || this.strikeStopped) {
                this.setAttacking(false);
                this.strikeStopped = false;
                this.strikeTick = 60 + this.field_70146_Z.nextInt(20);
                this.targetVec = null;
                this.oldVec = null;
            }
        } else if (this.targetVec != null) {
            this.func_70671_ap().func_75650_a(this.targetVec.field_72450_a, this.targetVec.field_72448_b, this.targetVec.field_72449_c, 3.0f, 85.0f);
            Vector3d motion = this.func_213322_ci();
            if (this.field_70123_F && motion.field_72448_b < (double)0.2f) {
                this.func_213293_j(motion.field_72450_a, 0.2f, motion.field_72449_c);
            }
            if (dSq > range * range) {
                this.moveTick = 0;
                this.targetVec = null;
            } else if (this.strikeTick <= 0 && dSq > strikeRange * strikeRange && this.field_70146_Z.nextInt(70) == 0) {
                this.setAttacking(true);
                this.moveTick = 0;
                this.targetVec = null;
            }
        } else if (dSq > range * range) {
            this.func_70671_ap().func_75651_a((Entity)target, 10.0f, 85.0f);
        } else {
            targetSpeed = 0.0;
            this.setRandomPathAround(target);
        }
        if (this.targetVec != null && this.targetVec.func_72438_d(this.func_213303_ch()) < 3.0 || this.moveTick > 120) {
            this.moveTick = 0;
            this.setRandomPathAround(target);
        }
        return targetSpeed;
    }

    @Override
    public boolean findNewPath() {
        return this.field_70146_Z.nextInt(40) == 0 || this.onLand() && this.field_70146_Z.nextInt(4) == 0;
    }

    @Override
    public boolean setRandomPath() {
        Vector3d vector3d = this.func_213303_ch().func_72441_c((10.0 + (double)this.field_70146_Z.nextFloat() * 12.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), ((double)this.field_70146_Z.nextFloat() - 0.5) * 12.0, (10.0 + (double)this.field_70146_Z.nextFloat() * 12.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
        if (this.onLand()) {
            vector3d = new Vector3d(this.func_226277_ct_() + (4.0 + (double)this.field_70146_Z.nextFloat() * 16.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), vector3d.field_72448_b, this.func_226281_cx_() + (4.0 + (double)this.field_70146_Z.nextFloat() * 16.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
        }
        if (this.isClearPath(vector3d)) {
            this.targetVec = vector3d;
            return true;
        }
        return false;
    }

    private boolean setRandomPathAround(LivingEntity living) {
        Vector3d vector3d = new Vector3d(living.func_226277_ct_() + (4.0 + (double)this.field_70146_Z.nextFloat() * 5.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), living.func_174813_aQ().field_72338_b - 5.0 + ((double)this.field_70146_Z.nextFloat() - 0.5) * 20.0, living.func_226281_cx_() + (4.0 + (double)this.field_70146_Z.nextFloat() * 5.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
        if (this.onLand()) {
            vector3d = new Vector3d(this.func_226277_ct_() + (4.0 + (double)this.field_70146_Z.nextFloat() * 16.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), vector3d.field_72448_b, this.func_226281_cx_() + (4.0 + (double)this.field_70146_Z.nextFloat() * 16.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
        }
        if (this.isClearPathWaterBelow(vector3d)) {
            this.targetVec = vector3d;
            return true;
        }
        return false;
    }

    @Override
    public void collideWithEntity(BodyPartEntity part, Entity entity) {
        float scale;
        if (part == this.getPartList()[this.getPartList().length - 1] && this.dotProductPos() > 0.04000000000000001) {
            float attackDamage = (float)this.func_233637_b_(Attributes.field_233823_f_);
            if (entity.func_70097_a(DamageSource.func_188403_a((Entity)part, (LivingEntity)this), attackDamage * 0.6f)) {
                this.func_174815_a((LivingEntity)this, entity);
            }
            double x = entity.func_226277_ct_() - this.func_226277_ct_();
            double y = entity.func_226278_cu_() - this.func_226278_cu_();
            double z = entity.func_226281_cx_() - this.func_226281_cx_();
            double d0 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
            scale = 0.12f * attackDamage;
            entity.func_213293_j(x / d0 * (double)scale, y / d0 * (double)scale, z / d0 * (double)scale);
            entity.field_70133_I = true;
        }
        if (this.isAttacking() && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < this.getStrikeRange() * this.getStrikeRange()) {
            if (!this.field_70170_p.field_72995_K && entity == this.func_70638_az()) {
                this.strikeStopped = true;
            }
            if (part == this.getPartList()[0] || part == this.getPartList()[1]) {
                this.func_184609_a(Hand.MAIN_HAND);
                if (this.func_70652_k(entity) && !entity.func_70089_S() && (this.canConsume(entity) || entity.func_200600_R() == EntityType.field_200729_aH)) {
                    this.setHunger(this.getHunger() - 1);
                }
            }
            double x = entity.func_226277_ct_() - this.func_226277_ct_();
            double y = entity.func_226278_cu_() - this.func_226278_cu_();
            double z = entity.func_226281_cx_() - this.func_226281_cx_();
            double d0 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
            Vector3d motion = this.func_213322_ci();
            motion = motion.func_72432_b();
            scale = 0.8f;
            entity.func_213293_j((x / d0 + motion.field_72450_a) * (double)scale, (y / d0 + motion.field_72448_b) * (double)scale, (z / d0 + motion.field_72449_c) * (double)scale);
            entity.field_70133_I = true;
        }
    }

    @Override
    public boolean canConsume(Entity entity) {
        return super.canConsume(entity) && entity instanceof LivingEntity && !((LivingEntity)entity).func_70662_br() && !(entity instanceof GolemEntity);
    }

    @Override
    public void func_233627_a_(float strength, double ratioX, double ratioZ) {
        if (!this.func_70090_H()) {
            super.func_233627_a_(strength, ratioX, ratioZ);
        }
    }

    public void func_203002_i(boolean downwards) {
    }

    public void func_203004_j(boolean downwards) {
    }

    public AxisAlignedBB func_184177_bl() {
        return super.func_184177_bl().func_186662_g(6.0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("Hunger", (byte)this.getHunger());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHunger(compound.func_74771_c("Hunger"));
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    static class NearestPreyGoal<T extends LivingEntity>
    extends NearestWaterTargetGoal<T> {
        public NearestPreyGoal(SeaSerpentEntity creature, Class<T> classTarget) {
            super((MobEntity)creature, classTarget, 10, true, CAN_TARGET);
        }

        @Override
        public boolean func_75250_a() {
            return ((SeaSerpentEntity)this.field_75299_d).getHunger() > 0 && super.func_75250_a();
        }
    }
}

