/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity;

import chumbanotz.abyssaldepths.entity.School;
import chumbanotz.abyssaldepths.entity.SchoolingMobEntity;
import chumbanotz.abyssaldepths.util.ADGlobal;
import chumbanotz.abyssaldepths.util.Euler;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class SeahorseEntity
extends SchoolingMobEntity {
    private static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(SeahorseEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Byte> TAME_AMOUNT = EntityDataManager.func_187226_a(SeahorseEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> MARK = EntityDataManager.func_187226_a(SeahorseEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private float netRideSpeed;

    public SeahorseEntity(EntityType<? extends SeahorseEntity> type, World world) {
        super((EntityType<? extends SchoolingMobEntity>)type, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
        this.field_70180_af.func_187214_a(TAME_AMOUNT, (Object)((byte)(3 + this.field_70146_Z.nextInt(3))));
        this.field_70180_af.func_187214_a(MARK, (Object)0);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return SeahorseEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    @Override
    public School createSchool() {
        School school = new School(this);
        school.setMaxSize(6 + this.field_70146_Z.nextInt(2));
        school.setRadius((float)school.getMaxSize() * 1.2f);
        return school;
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    private void setOwnerId(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    @Nullable
    public PlayerEntity getOwner() {
        return this.getOwnerId() != null ? this.field_70170_p.func_217371_b(this.getOwnerId()) : null;
    }

    @Override
    public boolean isTamed() {
        return this.getTameAmount() <= 0;
    }

    public int getTameAmount() {
        return ((Byte)this.field_70180_af.func_187225_a(TAME_AMOUNT)).byteValue();
    }

    private void setTameAmount(int amount) {
        this.field_70180_af.func_187227_b(TAME_AMOUNT, (Object)((byte)amount));
    }

    public int getMark() {
        return ((Byte)this.field_70180_af.func_187225_a(MARK)).byteValue();
    }

    private void setMark(int mark) {
        this.field_70180_af.func_187227_b(MARK, (Object)((byte)mark));
    }

    @Override
    public boolean func_204231_K() {
        return this.field_205013_W && this.func_70090_H();
    }

    @Override
    public boolean getRotatePitch() {
        return false;
    }

    @Override
    public float getClosestPathDist() {
        return 2.0f;
    }

    @Override
    public boolean setRandomPath() {
        Vector3d Vector3d2 = this.func_213303_ch().func_72441_c((4.0 + (double)this.field_70146_Z.nextFloat() * 5.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), ((double)this.field_70146_Z.nextFloat() - 0.5) * 8.0 + this.addPathY(), (4.0 + (double)this.field_70146_Z.nextFloat() * 5.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
        if (this.onLand()) {
            Vector3d2 = new Vector3d(this.func_226277_ct_() + (2.0 + (double)this.field_70146_Z.nextFloat() * 8.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), Vector3d2.field_72448_b, this.func_226281_cx_() + (2.0 + (double)this.field_70146_Z.nextFloat() * 8.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
        }
        if (this.isClearPath(Vector3d2)) {
            this.targetVec = Vector3d2;
            return true;
        }
        return false;
    }

    @Override
    public void resetFleeDistance() {
        this.fleeDistance = 10.0 + (double)this.field_70146_Z.nextFloat() * 6.0;
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.fleeDistance = 24.0 + (double)this.field_70146_Z.nextFloat() * 8.0;
        }
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            Euler angle = new Euler(0.0f, this.field_70177_z, 0.0f);
            Vector3d vec = angle.rotateVector(-0.3f);
            passenger.func_70107_b(this.func_226277_ct_() + vec.field_72450_a, this.func_226278_cu_() + vec.field_72448_b + passenger.func_70033_W() + 1.4, this.func_226281_cx_() + vec.field_72449_c);
        }
    }

    public void func_70103_a(byte id) {
        if (id == 7) {
            this.playTameEffect(true);
        } else if (id == 6) {
            this.playTameEffect(false);
        } else {
            super.func_70103_a(id);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            if (!this.school.ridinSolo()) {
                this.school.removeCreature(this);
                this.school.setOpenToCombine(false);
            }
            if (this.field_70173_aa % 100 == 0) {
                this.func_70691_i(2.0f);
            }
        }
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.setColor(this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat());
        } else {
            this.setColor(0.79607844f, 0.8509804f, 0.43529412f);
        }
        this.setMark(this.field_70146_Z.nextInt(3));
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.func_184207_aI() && this.isTamed();
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_110167_bD();
    }

    public Entity func_184179_bs() {
        return !this.isTamed() || this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    @Override
    public void func_213352_e(Vector3d vector3d) {
        if (this.func_184207_aI()) {
            this.followEntity = null;
            if (!this.isTamed()) {
                Entity passenger = (Entity)this.func_184188_bt().get(0);
                if (!this.field_70170_p.field_72995_K) {
                    if (this.targetVec == null || this.field_70146_Z.nextInt(15) == 0) {
                        this.setRandomPath();
                    }
                    if (this.field_70146_Z.nextInt(50) == 0) {
                        this.setTameAmount(this.getTameAmount() - 1);
                        if (this.getTameAmount() <= 0 && passenger instanceof PlayerEntity) {
                            this.setOwnerId(passenger.func_110124_au());
                            this.fleeFromEntity = null;
                            this.fleeLookVec = null;
                            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        } else {
                            this.targetVec = null;
                            passenger.func_184210_p();
                            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                        }
                    }
                    super.func_213352_e(vector3d);
                }
            } else if (this.func_184186_bw()) {
                float f;
                this.targetVec = null;
                LivingEntity passenger = (LivingEntity)this.func_184179_bs();
                float target = ADGlobal.wrapAngleAround(passenger.field_70177_z, this.field_70177_z);
                if (Math.abs(target - (f = this.field_70177_z + (target - this.field_70177_z) * 0.2f)) > 30.0f || this.dotProductPos() > 1.6000001778593287E-5) {
                    this.field_70759_as = this.field_70761_aq = f;
                    this.field_70177_z = this.field_70761_aq;
                    this.field_70126_B = this.field_70761_aq;
                }
                double speed = this.getAdjustedMovementSpeed() * 1.8;
                float pitch = this.field_70125_A;
                this.field_70125_A = passenger.field_70125_A * 0.9f - 10.0f;
                this.field_70125_A = pitch;
                this.netRideSpeed = (float)((double)this.netRideSpeed + (speed * (double)passenger.field_191988_bg - (double)this.netRideSpeed) * (double)0.1f);
                if (this.func_70090_H()) {
                    this.func_213315_a(MoverType.SELF, passenger.func_70040_Z().func_186678_a((double)this.netRideSpeed));
                }
                super.func_213352_e(new Vector3d((double)passenger.field_70702_br, vector3d.field_72448_b, 0.0));
                this.func_233629_a_((LivingEntity)this, false);
            }
        } else {
            super.func_213352_e(vector3d);
        }
    }

    protected ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        if (!this.func_184207_aI()) {
            playerIn.field_70177_z = this.field_70759_as;
            if (!this.field_70170_p.field_72995_K) {
                playerIn.func_184220_m((Entity)this);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    private void playTameEffect(boolean tamed) {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)(tamed ? ParticleTypes.field_197633_z : ParticleTypes.field_197601_L), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
        }
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.isTamed();
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("Mark", (byte)this.getMark());
        compound.func_74774_a("TameAmount", (byte)this.getTameAmount());
        if (this.getOwnerId() != null) {
            compound.func_186854_a("Owner", this.getOwnerId());
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setMark(compound.func_74771_c("Mark"));
        this.setTameAmount(compound.func_74771_c("TameAmount"));
        if (compound.func_186855_b("OwnerUUID")) {
            this.setOwnerId(compound.func_186857_a("OwnerUUID"));
        } else if (compound.func_186855_b("Owner")) {
            this.setOwnerId(compound.func_186857_a("Owner"));
        }
    }
}

