/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity.billfish;

import chumbanotz.abyssaldepths.entity.BodyPartEntity;
import chumbanotz.abyssaldepths.entity.MultipartMobEntity;
import chumbanotz.abyssaldepths.entity.ai.goal.NearestWaterTargetGoal;
import chumbanotz.abyssaldepths.entity.fish.AbstractSchoolFishEntity;
import chumbanotz.abyssaldepths.util.ADGlobal;
import chumbanotz.abyssaldepths.util.Bone;
import chumbanotz.abyssaldepths.util.Euler;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.fish.AbstractGroupFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractBillfishEntity
extends MultipartMobEntity
implements IAngerable {
    private static final com.google.common.base.Predicate<LivingEntity> IS_PREY = target -> target.func_70090_H() && !(target instanceof IMob) && (target instanceof AbstractGroupFishEntity || target instanceof AbstractSchoolFishEntity);
    protected static final DataParameter<Byte> MARKINGS = EntityDataManager.func_187226_a(AbstractBillfishEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private int attackTime;
    private final BodyPartEntity[] partList = new BodyPartEntity[4];
    private final Bone baseBone = new Bone();
    private final Bone[] boneList = new Bone[4];
    private final Euler[] targetAngles = new Euler[4];
    private static final RangedInteger ANGER_TIME_RANGE = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    protected AbstractBillfishEntity(EntityType<? extends AbstractBillfishEntity> type, World world) {
        super((EntityType<? extends MultipartMobEntity>)type, world);
        int i;
        this.baseBone.setLength(0.0f);
        this.boneList[0] = new Bone(this.baseBone);
        this.boneList[0].setLength(this.getPartLength()[0] / 16.0f);
        for (i = 1; i < this.boneList.length; ++i) {
            this.boneList[i] = new Bone(i == 1 ? this.baseBone : this.boneList[i - 1]);
            this.boneList[i].setLength(-this.getPartLength()[i] / 16.0f);
        }
        for (i = 0; i < this.partList.length; ++i) {
            this.targetAngles[i] = new Euler();
            this.partList[i] = new BodyPartEntity(this, this.getPartLength()[i] / 16.0f);
        }
        this.updateParts();
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, new NearestWaterTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, 10, true, arg_0 -> ((AbstractBillfishEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(2, new NearestWaterTargetGoal<WaterMobEntity>((MobEntity)this, WaterMobEntity.class, 100, true, (Predicate<LivingEntity>)IS_PREY));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MARKINGS, (Object)0);
    }

    public boolean hasBanner() {
        return ((Byte)this.field_70180_af.func_187225_a(MARKINGS) & 1) != 0;
    }

    protected void setBanner(boolean banner) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(MARKINGS);
        this.field_70180_af.func_187227_b(MARKINGS, (Object)(banner ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean hasStripes() {
        return ((Byte)this.field_70180_af.func_187225_a(MARKINGS) & 2) != 0;
    }

    protected void setStripes(boolean stripes) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(MARKINGS);
        this.field_70180_af.func_187227_b(MARKINGS, (Object)(stripes ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    public int func_230256_F__() {
        return this.angerTime;
    }

    public void func_230260_a__(int time) {
        this.angerTime = time;
    }

    public UUID func_230257_G__() {
        return this.angerTarget;
    }

    public void func_230259_a_(UUID target) {
        this.angerTarget = target;
    }

    public void func_230258_H__() {
        this.func_230260_a__(ANGER_TIME_RANGE.func_233018_a_(this.field_70146_Z));
    }

    protected abstract float[] getPartLength();

    protected abstract double getStrikeRange();

    protected abstract float getAttackReach();

    protected abstract int getMaxAttackTime();

    @Override
    public BodyPartEntity[] getPartList() {
        return this.partList;
    }

    @Override
    public Bone getBaseBone() {
        return this.baseBone;
    }

    @Override
    public Bone[] getBoneList() {
        return this.boneList;
    }

    @Override
    public void updateYawRotations(float partialTick) {
        for (int i = this.boneList.length - 1; i > 1; --i) {
            if (partialTick == 1.0f) {
                this.targetAngles[i].y = this.targetAngles[i - 1].y;
                this.boneList[i].getRotation().y += this.targetAngles[i].y;
                continue;
            }
            this.boneList[i].getRotation().y += this.targetAngles[i].y + (this.targetAngles[i - 1].y - this.targetAngles[i].y) * partialTick;
        }
        this.targetAngles[1].y = -(this.currentYaw - this.prevCurrentYaw) * 1.4f;
        this.targetAngles[0].y = (this.currentYaw - this.prevCurrentYaw) * 1.4f;
        float moveScale = MathHelper.func_219799_g((float)partialTick, (float)this.field_184618_aE, (float)this.field_70721_aZ);
        float moveTick = this.field_184619_aG - this.field_70721_aZ * (1.0f - partialTick);
        if (moveScale > 1.0f) {
            moveScale = 1.0f;
        }
        for (int i = 0; i < this.boneList.length; ++i) {
            float breatheAnim = MathHelper.func_76126_a((float)(0.1f * ((float)this.field_70173_aa + partialTick - (float)i * 1.4f)));
            float moveAnim = MathHelper.func_76126_a((float)(0.7f * (moveTick - (float)i * 1.4f))) * moveScale;
            this.boneList[i].getRotation().y += breatheAnim * 1.1f;
            this.boneList[i].getRotation().y += moveAnim * 8.0f;
        }
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        if (this.attackTime > this.getMaxAttackTime()) {
            Entity owner;
            boolean attack;
            float dmg = (float)this.func_233637_b_(Attributes.field_233823_f_);
            Entity entity = ADGlobal.getPointedEntity((LivingEntity)this, this.getAttackReach());
            boolean bl = attack = entity != null && entity.func_200600_R() != this.func_200600_R();
            if (entity instanceof BodyPartEntity && (owner = ((BodyPartEntity)entity).getOwner()) != null && this.func_70638_az() != owner && owner.func_200600_R() == this.func_200600_R()) {
                attack &= this.field_70146_Z.nextInt(160) == 0;
            }
            if (entity != null && attack && entity.func_70097_a((DamageSource)new EntityDamageSource("trident", (Entity)this), dmg)) {
                if (!entity.func_70089_S() && this.canConsume(entity)) {
                    this.func_184609_a(Hand.MAIN_HAND);
                    this.func_70691_i(1.0f);
                }
                this.func_174815_a((LivingEntity)this, entity);
            }
        }
        --this.attackTime;
    }

    @Override
    public double moveByTarget(LivingEntity target) {
        if (this.attackTime > 0) {
            this.func_70671_ap().func_75651_a((Entity)target, this.attackTime > this.getMaxAttackTime() ? 15.0f : 0.0f, 85.0f);
        } else {
            this.func_70671_ap().func_75651_a((Entity)target, 8.0f, 85.0f);
        }
        double strikeRange = this.getStrikeRange();
        if (this.attackTime <= 0 && this.func_70068_e((Entity)target) < strikeRange * strikeRange && this.field_70146_Z.nextInt(4) == 0) {
            double x = target.func_226277_ct_() - this.func_226277_ct_();
            double y = target.func_226278_cu_() - this.func_226278_cu_();
            double z = target.func_226281_cx_() - this.func_226281_cx_();
            double d = Math.sqrt(x * x + y * y + z * z);
            double scale = this.getAdjustedMovementSpeed() / 0.8;
            this.func_213293_j(x / d * scale, y / d * scale, z / d * scale);
            this.attackTime = 16 + this.field_70146_Z.nextInt(5);
        }
        return this.attackTime > 0 ? 0.0 : this.getAdjustedMovementSpeed() * 1.2;
    }

    @Override
    public boolean findNewPath() {
        return this.field_70146_Z.nextInt(45) == 0 || this.onLand() && this.field_70146_Z.nextInt(4) == 0;
    }

    @Override
    public boolean setRandomPath() {
        Vector3d vector3d = this.func_213303_ch().func_72441_c((6.0 + (double)this.field_70146_Z.nextFloat() * 6.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), ((double)this.field_70146_Z.nextFloat() - 0.5) * 8.0 + this.addPathY(), (6.0 + (double)this.field_70146_Z.nextFloat() * 6.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
        if (this.onLand()) {
            vector3d = new Vector3d(this.func_226277_ct_() + (4.0 + (double)this.field_70146_Z.nextFloat() * 12.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), vector3d.field_72448_b, this.func_226281_cx_() + (4.0 + (double)this.field_70146_Z.nextFloat() * 12.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
        }
        if (this.isClearPath(vector3d)) {
            this.targetVec = vector3d;
            return true;
        }
        return false;
    }

    @Override
    public boolean canConsume(Entity entity) {
        return super.canConsume(entity) && (entity instanceof AbstractGroupFishEntity || entity instanceof AbstractSchoolFishEntity);
    }

    public AxisAlignedBB func_184177_bl() {
        return super.func_184177_bl().func_186662_g(3.0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Banner", this.hasBanner());
        compound.func_74757_a("Stripes", this.hasStripes());
        this.func_233682_c_(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setBanner(compound.func_74767_n("Banner"));
        this.setStripes(compound.func_74767_n("Stripes"));
        if (this.field_70170_p instanceof ServerWorld) {
            this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
        }
    }
}

